/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.TaskTagParser;

public class ErrorStrip
extends JComponent {
    private RSyntaxTextArea textArea;
    private Listener listener;
    private boolean showMarkedOccurrences;
    private Map brighterColors;
    private int levelThreshold;
    private boolean followCaret;
    private Color caretMarkerColor;
    private int caretLineY;
    private int lastLineY;
    private static final int PREFERRED_WIDTH = 14;
    private static final String MSG = "org.fife.ui.rsyntaxtextarea.ErrorStrip";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.ErrorStrip");
    private static final Color COLOR = new Color(220, 220, 220);

    public ErrorStrip(RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        this.listener = new Listener();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setLayout(null);
        this.addMouseListener(this.listener);
        this.setShowMarkedOccurrences(true);
        this.setLevelThreshold(1);
        this.setFollowCaret(true);
        this.setCaretMarkerColor(Color.BLACK);
    }

    public void addNotify() {
        super.addNotify();
        this.textArea.addCaretListener(this.listener);
        this.textArea.addPropertyChangeListener("RSTA.parserNotices", this.listener);
        this.textArea.addPropertyChangeListener("RSTA.markOccurrences", this.listener);
        this.textArea.addPropertyChangeListener("RSTA.markedOccurrencesChanged", this.listener);
        this.refreshMarkers();
    }

    public void doLayout() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Marker marker = (Marker)this.getComponent(i);
            marker.updateLocation();
        }
        this.listener.caretUpdate(null);
    }

    private Color getBrighterColor(Color color) {
        Color color2;
        if (this.brighterColors == null) {
            this.brighterColors = new HashMap(5);
        }
        if ((color2 = (Color)this.brighterColors.get(color)) == null) {
            int n = ErrorStrip.possiblyBrighter(color.getRed());
            int n2 = ErrorStrip.possiblyBrighter(color.getGreen());
            int n3 = ErrorStrip.possiblyBrighter(color.getBlue());
            color2 = new Color(n, n2, n3);
            this.brighterColors.put(color, color2);
        }
        return color2;
    }

    public Color getCaretMarkerColor() {
        return this.caretMarkerColor;
    }

    public boolean getFollowCaret() {
        return this.followCaret;
    }

    public Dimension getPreferredSize() {
        int n = this.textArea.getPreferredScrollableViewportSize().height;
        return new Dimension(14, n);
    }

    public int getLevelThreshold() {
        return this.levelThreshold;
    }

    public boolean getShowMarkedOccurrences() {
        return this.showMarkedOccurrences;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        int n = this.yToLine(mouseEvent.getY());
        if (n > -1) {
            string = msg.getString("Line");
            string = MessageFormat.format(string, new Integer(n));
        }
        return string;
    }

    private int lineToY(int n) {
        int n2 = this.textArea.getVisibleRect().height;
        float f = this.textArea.getLineCount();
        return (int)((float)n / f * (float)n2) - 2;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.caretLineY > -1) {
            graphics.setColor(this.getCaretMarkerColor());
            graphics.fillRect(0, this.caretLineY, this.getWidth(), 2);
        }
    }

    private static final int possiblyBrighter(int n) {
        if (n < 255) {
            n += (int)((float)(255 - n) * 0.8f);
        }
        return n;
    }

    private void refreshMarkers() {
        Object object;
        Object object2;
        this.removeAll();
        HashMap<Object, Marker> hashMap = new HashMap<Object, Marker>();
        List list = this.textArea.getParserNotices();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (ParserNotice)object3.next();
            if (object2.getLevel() > this.levelThreshold && !(object2 instanceof TaskTagParser.TaskNotice)) continue;
            object = new Integer(object2.getLine());
            Marker marker = (Marker)hashMap.get(object);
            if (marker == null) {
                marker = new Marker((ParserNotice)object2);
                marker.addMouseListener(this.listener);
                hashMap.put(object, marker);
                this.add(marker);
                continue;
            }
            marker.addNotice((ParserNotice)object2);
        }
        if (this.getShowMarkedOccurrences() && this.textArea.getMarkOccurrences()) {
            object3 = this.textArea.getMarkedOccurrences();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (DocumentRange)object2.next();
                int n = 0;
                try {
                    n = this.textArea.getLineOfOffset(((DocumentRange)object).getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    continue;
                }
                MarkedOccurrenceNotice markedOccurrenceNotice = new MarkedOccurrenceNotice((DocumentRange)object);
                Integer n2 = new Integer(n);
                Marker marker = (Marker)hashMap.get(n2);
                if (marker == null) {
                    marker = new Marker(markedOccurrenceNotice);
                    marker.addMouseListener(this.listener);
                    hashMap.put(n2, marker);
                    this.add(marker);
                    continue;
                }
                if (marker.containsMarkedOccurence()) continue;
                marker.addNotice(markedOccurrenceNotice);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void removeNotify() {
        super.removeNotify();
        this.textArea.removeCaretListener(this.listener);
        this.textArea.removePropertyChangeListener("RSTA.parserNotices", this.listener);
        this.textArea.removePropertyChangeListener("RSTA.markOccurrences", this.listener);
        this.textArea.removePropertyChangeListener("RSTA.markedOccurrencesChanged", this.listener);
    }

    public void setCaretMarkerColor(Color color) {
        if (color != null) {
            this.caretMarkerColor = color;
            this.listener.caretUpdate(null);
        }
    }

    public void setFollowCaret(boolean bl) {
        if (this.followCaret != bl) {
            if (this.followCaret) {
                this.repaint(0, this.caretLineY, this.getWidth(), 2);
            }
            this.caretLineY = -1;
            this.lastLineY = -1;
            this.followCaret = bl;
            this.listener.caretUpdate(null);
        }
    }

    public void setLevelThreshold(int n) {
        this.levelThreshold = n;
        if (this.isDisplayable()) {
            this.refreshMarkers();
        }
    }

    public void setShowMarkedOccurrences(boolean bl) {
        if (bl != this.showMarkedOccurrences) {
            this.showMarkedOccurrences = bl;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    private final int yToLine(int n) {
        int n2 = -1;
        int n3 = this.textArea.getVisibleRect().height;
        if (n < n3) {
            float f = (float)n / (float)n3;
            n2 = (int)((float)this.textArea.getLineCount() * f);
        }
        return n2;
    }

    private class Marker
    extends JComponent {
        private List notices = new ArrayList(1);

        public Marker(ParserNotice parserNotice) {
            this.addNotice(parserNotice);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setSize(this.getPreferredSize());
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void addNotice(ParserNotice parserNotice) {
            this.notices.add(parserNotice);
        }

        public boolean containsMarkedOccurence() {
            boolean bl = false;
            for (int i = 0; i < this.notices.size(); ++i) {
                if (!(this.notices.get(i) instanceof MarkedOccurrenceNotice)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public Color getColor() {
            Color color = null;
            int n = Integer.MAX_VALUE;
            Iterator iterator = this.notices.iterator();
            while (iterator.hasNext()) {
                ParserNotice parserNotice = (ParserNotice)iterator.next();
                if (parserNotice.getLevel() >= n) continue;
                n = parserNotice.getLevel();
                color = parserNotice.getColor();
            }
            return color;
        }

        public Dimension getPreferredSize() {
            int n = 10;
            return new Dimension(n, 5);
        }

        public String getToolTipText() {
            String string = null;
            if (this.notices.size() == 1) {
                string = ((ParserNotice)this.notices.get(0)).getMessage();
            } else {
                StringBuffer stringBuffer = new StringBuffer("<html>");
                stringBuffer.append(msg.getString("MultipleMarkers"));
                stringBuffer.append("<br>");
                for (int i = 0; i < this.notices.size(); ++i) {
                    ParserNotice parserNotice = (ParserNotice)this.notices.get(i);
                    stringBuffer.append("&nbsp;&nbsp;&nbsp;- ");
                    stringBuffer.append(parserNotice.getMessage());
                    stringBuffer.append("<br>");
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        protected void mouseClicked(MouseEvent mouseEvent) {
            ParserNotice parserNotice = (ParserNotice)this.notices.get(0);
            int n = parserNotice.getOffset();
            int n2 = parserNotice.getLength();
            if (n > -1 && n2 > -1) {
                ErrorStrip.this.textArea.setSelectionStart(n);
                ErrorStrip.this.textArea.setSelectionEnd(n + n2);
            } else {
                int n3 = parserNotice.getLine();
                try {
                    n = ErrorStrip.this.textArea.getLineStartOffset(n3);
                    ErrorStrip.this.textArea.setCaretPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
                }
            }
        }

        protected void paintComponent(Graphics graphics) {
            Color color = this.getColor();
            if (color == null) {
                color = Color.DARK_GRAY;
            }
            Color color2 = ErrorStrip.this.getBrighterColor(color);
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }

        public void removeNotify() {
            super.removeNotify();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.removeMouseListener(ErrorStrip.this.listener);
        }

        public void updateLocation() {
            int n = ((ParserNotice)this.notices.get(0)).getLine();
            int n2 = ErrorStrip.this.lineToY(n);
            this.setLocation(2, n2);
        }
    }

    private class MarkedOccurrenceNotice
    implements ParserNotice {
        private DocumentRange range;

        public MarkedOccurrenceNotice(DocumentRange documentRange) {
            this.range = documentRange;
        }

        public int compareTo(Object object) {
            return 0;
        }

        public boolean containsPosition(int n) {
            return n >= this.range.getStartOffset() && n < this.range.getEndOffset();
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public Color getColor() {
            return COLOR;
        }

        public int getLength() {
            return this.range.getEndOffset() - this.range.getStartOffset();
        }

        public int getLevel() {
            return 2;
        }

        public int getLine() {
            try {
                return ErrorStrip.this.textArea.getLineOfOffset(this.range.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        public String getMessage() {
            String string = null;
            try {
                String string2 = ErrorStrip.this.textArea.getText(this.range.getStartOffset(), this.getLength());
                string = msg.getString("OccurrenceOf");
                string = MessageFormat.format(string, string2);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
            }
            return string;
        }

        public int getOffset() {
            return this.range.getStartOffset();
        }

        public Parser getParser() {
            return null;
        }

        public boolean getShowInEditor() {
            return false;
        }

        public String getToolTipText() {
            return null;
        }

        public int hashCode() {
            return 0;
        }
    }

    private class Listener
    extends MouseAdapter
    implements PropertyChangeListener,
    CaretListener {
        private Rectangle visibleRect = new Rectangle();

        private Listener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (ErrorStrip.this.getFollowCaret()) {
                int n = ErrorStrip.this.textArea.getCaretLineNumber();
                float f = (float)n / (float)ErrorStrip.this.textArea.getLineCount();
                ErrorStrip.this.textArea.computeVisibleRect(this.visibleRect);
                ErrorStrip.this.caretLineY = (int)((float)this.visibleRect.height * f);
                if (ErrorStrip.this.caretLineY != ErrorStrip.this.lastLineY) {
                    ErrorStrip.this.repaint(0, ErrorStrip.this.lastLineY, ErrorStrip.this.getWidth(), 2);
                    ErrorStrip.this.repaint(0, ErrorStrip.this.caretLineY, ErrorStrip.this.getWidth(), 2);
                    ErrorStrip.this.lastLineY = ErrorStrip.this.caretLineY;
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            if (component instanceof Marker) {
                ((Marker)component).mouseClicked(mouseEvent);
                return;
            }
            int n = ErrorStrip.this.yToLine(mouseEvent.getY());
            if (n > -1) {
                try {
                    int n2 = ErrorStrip.this.textArea.getLineStartOffset(n);
                    ErrorStrip.this.textArea.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("RSTA.markOccurrences".equals(string)) {
                if (ErrorStrip.this.getShowMarkedOccurrences()) {
                    ErrorStrip.this.refreshMarkers();
                }
            } else if ("RSTA.parserNotices".equals(string)) {
                ErrorStrip.this.refreshMarkers();
            } else if ("RSTA.markedOccurrencesChanged".equals(string) && ErrorStrip.this.getShowMarkedOccurrences()) {
                ErrorStrip.this.refreshMarkers();
            }
        }
    }
}

