/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import processing.xml.CDATAReader;
import processing.xml.StdXMLReader;
import processing.xml.XMLEntityResolver;
import processing.xml.XMLUtil;

public class XMLValidator {
    protected XMLEntityResolver parameterEntityResolver;
    protected Hashtable<String, Properties> attributeDefaultValues = new Hashtable();
    protected Stack<Properties> currentElements = new Stack();

    public XMLValidator() {
        this.parameterEntityResolver = new XMLEntityResolver();
    }

    protected void finalize() throws Throwable {
        this.parameterEntityResolver = null;
        this.attributeDefaultValues.clear();
        this.attributeDefaultValues = null;
        this.currentElements.clear();
        this.currentElements = null;
        super.finalize();
    }

    public void setParameterEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.parameterEntityResolver = xMLEntityResolver;
    }

    public XMLEntityResolver getParameterEntityResolver() {
        return this.parameterEntityResolver;
    }

    public void parseDTD(String string, StdXMLReader stdXMLReader, XMLEntityResolver xMLEntityResolver, boolean bl) throws Exception {
        XMLUtil.skipWhitespace(stdXMLReader, null);
        int n = stdXMLReader.getStreamLevel();
        while (true) {
            String string2;
            char c;
            if ((c = (string2 = XMLUtil.read(stdXMLReader, '%')).charAt(0)) == '%') {
                XMLUtil.processEntity(string2, stdXMLReader, this.parameterEntityResolver);
                continue;
            }
            if (c == '<') {
                this.processElement(stdXMLReader, xMLEntityResolver);
            } else {
                if (c == ']') {
                    return;
                }
                XMLUtil.errorInvalidInput(stdXMLReader.getSystemID(), stdXMLReader.getLineNr(), string2);
            }
            do {
                c = stdXMLReader.read();
                if (!bl || stdXMLReader.getStreamLevel() >= n) continue;
                stdXMLReader.unread(c);
                return;
            } while (c == ' ' || c == '\t' || c == '\n' || c == '\r');
            stdXMLReader.unread(c);
        }
    }

    protected void processElement(StdXMLReader stdXMLReader, XMLEntityResolver xMLEntityResolver) throws Exception {
        String string = XMLUtil.read(stdXMLReader, '%');
        char c = string.charAt(0);
        if (c != '!') {
            XMLUtil.skipTag(stdXMLReader);
            return;
        }
        string = XMLUtil.read(stdXMLReader, '%');
        c = string.charAt(0);
        switch (c) {
            case '-': {
                XMLUtil.skipComment(stdXMLReader);
                break;
            }
            case '[': {
                this.processConditionalSection(stdXMLReader, xMLEntityResolver);
                break;
            }
            case 'E': {
                this.processEntity(stdXMLReader, xMLEntityResolver);
                break;
            }
            case 'A': {
                this.processAttList(stdXMLReader, xMLEntityResolver);
                break;
            }
            default: {
                XMLUtil.skipTag(stdXMLReader);
            }
        }
    }

    protected void processConditionalSection(StdXMLReader stdXMLReader, XMLEntityResolver xMLEntityResolver) throws Exception {
        int n;
        XMLUtil.skipWhitespace(stdXMLReader, null);
        String string = XMLUtil.read(stdXMLReader, '%');
        char c = string.charAt(0);
        if (c != 'I') {
            XMLUtil.skipTag(stdXMLReader);
            return;
        }
        string = XMLUtil.read(stdXMLReader, '%');
        c = string.charAt(0);
        switch (c) {
            case 'G': {
                this.processIgnoreSection(stdXMLReader, xMLEntityResolver);
                return;
            }
            case 'N': {
                break;
            }
            default: {
                XMLUtil.skipTag(stdXMLReader);
                return;
            }
        }
        if (!XMLUtil.checkLiteral(stdXMLReader, "CLUDE")) {
            XMLUtil.skipTag(stdXMLReader);
            return;
        }
        XMLUtil.skipWhitespace(stdXMLReader, null);
        string = XMLUtil.read(stdXMLReader, '%');
        c = string.charAt(0);
        if (c != '[') {
            XMLUtil.skipTag(stdXMLReader);
            return;
        }
        CDATAReader cDATAReader = new CDATAReader(stdXMLReader);
        StringBuffer stringBuffer = new StringBuffer(1024);
        while ((n = cDATAReader.read()) >= 0) {
            stringBuffer.append((char)n);
        }
        ((Reader)cDATAReader).close();
        stdXMLReader.startNewStream(new StringReader(stringBuffer.toString()));
    }

    protected void processIgnoreSection(StdXMLReader stdXMLReader, XMLEntityResolver xMLEntityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(stdXMLReader, "NORE")) {
            XMLUtil.skipTag(stdXMLReader);
            return;
        }
        XMLUtil.skipWhitespace(stdXMLReader, null);
        String string = XMLUtil.read(stdXMLReader, '%');
        char c = string.charAt(0);
        if (c != '[') {
            XMLUtil.skipTag(stdXMLReader);
            return;
        }
        CDATAReader cDATAReader = new CDATAReader(stdXMLReader);
        ((Reader)cDATAReader).close();
    }

    protected void processAttList(StdXMLReader stdXMLReader, XMLEntityResolver xMLEntityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(stdXMLReader, "TTLIST")) {
            XMLUtil.skipTag(stdXMLReader);
            return;
        }
        XMLUtil.skipWhitespace(stdXMLReader, null);
        String string = XMLUtil.read(stdXMLReader, '%');
        char c = string.charAt(0);
        while (c == '%') {
            XMLUtil.processEntity(string, stdXMLReader, this.parameterEntityResolver);
            string = XMLUtil.read(stdXMLReader, '%');
            c = string.charAt(0);
        }
        stdXMLReader.unread(c);
        String string2 = XMLUtil.scanIdentifier(stdXMLReader);
        XMLUtil.skipWhitespace(stdXMLReader, null);
        string = XMLUtil.read(stdXMLReader, '%');
        c = string.charAt(0);
        while (c == '%') {
            XMLUtil.processEntity(string, stdXMLReader, this.parameterEntityResolver);
            string = XMLUtil.read(stdXMLReader, '%');
            c = string.charAt(0);
        }
        Properties properties = new Properties();
        while (c != '>') {
            stdXMLReader.unread(c);
            String string3 = XMLUtil.scanIdentifier(stdXMLReader);
            XMLUtil.skipWhitespace(stdXMLReader, null);
            string = XMLUtil.read(stdXMLReader, '%');
            c = string.charAt(0);
            while (c == '%') {
                XMLUtil.processEntity(string, stdXMLReader, this.parameterEntityResolver);
                string = XMLUtil.read(stdXMLReader, '%');
                c = string.charAt(0);
            }
            if (c == '(') {
                while (c != ')') {
                    string = XMLUtil.read(stdXMLReader, '%');
                    c = string.charAt(0);
                    while (c == '%') {
                        XMLUtil.processEntity(string, stdXMLReader, this.parameterEntityResolver);
                        string = XMLUtil.read(stdXMLReader, '%');
                        c = string.charAt(0);
                    }
                }
            } else {
                stdXMLReader.unread(c);
                XMLUtil.scanIdentifier(stdXMLReader);
            }
            XMLUtil.skipWhitespace(stdXMLReader, null);
            string = XMLUtil.read(stdXMLReader, '%');
            c = string.charAt(0);
            while (c == '%') {
                XMLUtil.processEntity(string, stdXMLReader, this.parameterEntityResolver);
                string = XMLUtil.read(stdXMLReader, '%');
                c = string.charAt(0);
            }
            if (c == '#') {
                string = XMLUtil.scanIdentifier(stdXMLReader);
                XMLUtil.skipWhitespace(stdXMLReader, null);
                if (!string.equals("FIXED")) {
                    XMLUtil.skipWhitespace(stdXMLReader, null);
                    string = XMLUtil.read(stdXMLReader, '%');
                    c = string.charAt(0);
                    while (c == '%') {
                        XMLUtil.processEntity(string, stdXMLReader, this.parameterEntityResolver);
                        string = XMLUtil.read(stdXMLReader, '%');
                        c = string.charAt(0);
                    }
                    continue;
                }
            } else {
                stdXMLReader.unread(c);
            }
            String string4 = XMLUtil.scanString(stdXMLReader, '%', this.parameterEntityResolver);
            properties.put(string3, string4);
            XMLUtil.skipWhitespace(stdXMLReader, null);
            string = XMLUtil.read(stdXMLReader, '%');
            c = string.charAt(0);
            while (c == '%') {
                XMLUtil.processEntity(string, stdXMLReader, this.parameterEntityResolver);
                string = XMLUtil.read(stdXMLReader, '%');
                c = string.charAt(0);
            }
        }
        if (!properties.isEmpty()) {
            this.attributeDefaultValues.put(string2, properties);
        }
    }

    protected void processEntity(StdXMLReader stdXMLReader, XMLEntityResolver xMLEntityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(stdXMLReader, "NTITY")) {
            XMLUtil.skipTag(stdXMLReader);
            return;
        }
        XMLUtil.skipWhitespace(stdXMLReader, null);
        char c = XMLUtil.readChar(stdXMLReader, '\u0000');
        if (c == '%') {
            XMLUtil.skipWhitespace(stdXMLReader, null);
            xMLEntityResolver = this.parameterEntityResolver;
        } else {
            stdXMLReader.unread(c);
        }
        String string = XMLUtil.scanIdentifier(stdXMLReader);
        XMLUtil.skipWhitespace(stdXMLReader, null);
        c = XMLUtil.readChar(stdXMLReader, '%');
        String string2 = null;
        String string3 = null;
        switch (c) {
            case 'P': {
                if (!XMLUtil.checkLiteral(stdXMLReader, "UBLIC")) {
                    XMLUtil.skipTag(stdXMLReader);
                    return;
                }
                XMLUtil.skipWhitespace(stdXMLReader, null);
                string3 = XMLUtil.scanString(stdXMLReader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(stdXMLReader, null);
                string2 = XMLUtil.scanString(stdXMLReader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(stdXMLReader, null);
                XMLUtil.readChar(stdXMLReader, '%');
                break;
            }
            case 'S': {
                if (!XMLUtil.checkLiteral(stdXMLReader, "YSTEM")) {
                    XMLUtil.skipTag(stdXMLReader);
                    return;
                }
                XMLUtil.skipWhitespace(stdXMLReader, null);
                string2 = XMLUtil.scanString(stdXMLReader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(stdXMLReader, null);
                XMLUtil.readChar(stdXMLReader, '%');
                break;
            }
            case '\"': 
            case '\'': {
                stdXMLReader.unread(c);
                String string4 = XMLUtil.scanString(stdXMLReader, '%', this.parameterEntityResolver);
                xMLEntityResolver.addInternalEntity(string, string4);
                XMLUtil.skipWhitespace(stdXMLReader, null);
                XMLUtil.readChar(stdXMLReader, '%');
                break;
            }
            default: {
                XMLUtil.skipTag(stdXMLReader);
            }
        }
        if (string2 != null) {
            xMLEntityResolver.addExternalEntity(string, string3, string2);
        }
    }

    public void elementStarted(String string, String string2, int n) {
        Properties properties = this.attributeDefaultValues.get(string);
        properties = properties == null ? new Properties() : (Properties)properties.clone();
        this.currentElements.push(properties);
    }

    public void elementEnded(String string, String string2, int n) {
    }

    public void elementAttributesProcessed(String string, Properties properties, String string2, int n) {
        Properties properties2 = this.currentElements.pop();
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            properties.put(string3, properties2.get(string3));
        }
    }

    public void attributeAdded(String string, String string2, String string3, int n) {
        Properties properties = this.currentElements.peek();
        if (properties.containsKey(string)) {
            properties.remove(string);
        }
    }

    public void PCDataAdded(String string, int n) {
    }
}

