(ns halloween.spider.api
  (:use [halloween.spider.simulator
         :only [
                forward f
                backward b
                silk s
                turn t 
                turn-right tr 
                turn-left tl
                curve c
                curve-right cr
                curve-left cl
                retract r ; put retract in as an api only function?
                ]])
  )


; API Examples
;

(comment

  ; Fibonacci Tree
  (defn tree [n x]
    (f x)
    (if (> n 1)
      (do 
        (tl 15)
        (tree (- n 1) x)
        (tr 30)
        (tree (- n 1) x)
        (tl 15)))
    (s)
    (b x))
  (tl 90)
  (tree 6 3)      
  
  ; Flower / Eyelash Spiral
  (defn q [x]
    (dotimes [n x]
      (f n)
      (t 45))
    (dotimes [n x]
      (f (- x n))
      (t -45)))
  (s)
  (dotimes [n 11]
    (q n)
    )
  
  
  
  )