(ns halloween.core
  (:gen-class)(:use quil.core) (:use quil.applet)
  (:require [halloween.boo.renderer :as boo.renderer])
  (:require [halloween.boo.simulator :as boo.simulator])
  (:require [halloween.boo.controller :as boo.controller])
  (:require [halloween.spider.renderer :as spider.renderer])
  (:require [halloween.spider.simulator :as spider.simulator])
  (:require [halloween.spider.controller :as spider.controller])
  (:require [halloween.spider.ui :as spider.ui]))

;   .-. .-.  .--.  ,-.    ,-.    .---.  .-.  .-.,---.  ,---.  .-. .-. 
;   | | | | / /\ \ | |    | |   / .-. ) | |/\| || .-'  | .-'  |  \| | 
;   | `-' |/ /__\ \| |    | |   | | |(_)| /  \ || `-.  | `-.  |   | | 
;   | .-. ||  __  || |    | |   | | | | |  /\  || .-'  | .-'  | |\  |
;   | | |)|| |  |)|| `--. | `--.\ `-' / |(/  \ ||  `--.|  `--.| | |)| 
;   /(  (_)|_|  (_)|( __.'|( __.')---'  (_)   \|/( __.'/( __.'/(  (_) 
;  (__)            (_)    (_)   (_)            (__)   (__)   (__)       February 2013

    ;
  ; Halloween TODO
    ;
  
    ; set up git repo
    
                                                        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                __             __       
;  _____________|  |_____     _(   )                       
;  UUUUUUUUUUUUU|__|UUUUU| ,-'      )_                     
;  UUU_UUUUUU_UUUUUU_UUUU|(   (  /    )   Salem is a town generator.                  
;  UU|_|UUUU|_|UUUU|_|UUU|.  \   )  _) )              
;  UUUUUUUUUUUUUUUUUUUUUU| `.  .    )  )                 
;  ======================|(_   |  )  _)                    
;       __     __    __  |(__(_|____)____
;  |   |__|   |__|  |__| |uuuuuuuuuuuuuuu
;  |   |__|   |__|  |__| |uuuuuuuuuuuuuuu
;  ======================|uuuu_uuuuuu_uuu
;       __     __    __  |uuu| |uuuu| |uu
;  |   |__|   |__|  |__| |uuu|_|uuuu|_|uu
;  |   |__|   |__|  |__| |=_====__=======
;  ======================||  | |  |  __  
;    ___  __    ________ ||__| |__| |  | 
;  ||_|_||  |  |  |     || _______  |__| 
;  ||_|_||- |  | -|     |||   |   |      
;   |_|_||  |  |  |_____|||   |o  |  _   
;  ---. _|--|__|--|_____|||===|   |_|_|_ 
;  ----`. ___             ;---'---'      
;  --(_)-'_ _\___________/________|____/_
;  ______________________________________
;

(defn salem!
  "Starts Salem."
  []
  )
    
    
;;;;;;;;;;;;;;;;
;       ___
;     _/ oo\
;    ( \  O/__
;     \    \__) Boo is a costume & identity simulator.
;     /     \
;    /      _\
;   `"""""``

    ;
  ; Boo TODO
    ;
    
    ; nothing for now

    
(defn boo!
  "Starts Boo."
  [& arguments]
  (defsketch halloween-window
  :title "Halloween!"
  :setup   (fn [] (frame-rate 12) (no-smooth) (no-fill) (stroke 255))
  :draw (fn [] (boo.renderer/render (boo.simulator/simulate (boo.controller/control))))
  :mouse-moved boo.controller/mouse-moved
  :size [640 480])) 
  

;;;;;;;;;;;;;;;;;;;;
;      \______/
;      /\____/\
;     / /\__/\ \
;  __/_/_/\/\_\_\__ Spider is a graphics editor.
;    \ \ \/*/ /
;     \ \/__\/ 
;      \/____\  
;      /      \

    ;
  ; Spider TODO
    ;

    ; use the spider as the unit to show scale
    ; fix the mouse focus bug - the bug is when papplet was not in focus when app goes out of focus and it is clicked in center
   
    ; more examples?

    ; add something along the lines of metadata tagging (for animation / interaction etc)
    ; option to snap spider to already drawn coordinates (useful for closing shapes)
    ; think more about heading / rotation
    ; loaded and saved files should exist in their own namespace with the simulator's api exposed
    ; smarter code interpretation (shortening) on save
    ; add rotation to view
 
    ; todo 4 beauty Saturday ;-) (not in any particular order, of course!)
      ; use the (do) statement in conditionals
      ; cleanup scale shifts and such in renderer
      ; rename certain commands internally
      ; cleanup ui / loading saving
      ; structure of namespaces
      ; function order
      ; better :use and :require using :only
      ; work in more functional style
    
    ; DONE tree example
    ; DONE add keyboard commands to documentation
    ; DONE repl-ify the status bar
    ; DONE fixed delete-procedure bug
    ; DONE fix undo
    ; DONE documentation of some of the commands you can enter
    ; DONE? fix rotation negatives
    ; DONE unit size / slack (in pixels?) that refers to the (move) argument
    ; DONE better i/o  w/file browser of some kind?
    ; DONE lock zoom to certain zoom level / fix zoom controls
    ; DONE better loading + saving of files
    ; DONE fix mouse preview jump from slack thing - set slack to 0 on mouse click...
    ; DONE pan drawing
    ; DONE zoom
    ; DONE get this to work interactively with basic functions and function calls
    ; DONE set up preview-procedure for mouse
    ; DONE maybe mouse-preview goes to wherever the last (move) was in the console
    ; DONE streamline code / interface switching / interoperability with text-editor
    ; DONE add command line
    ; DONE basic formatter and input / output
    ; DONE pen up and down
    ; DONE meta data / sort of
    ; DONE undo
    ; DONE curves?
    ; DONE fix the degrees / radians thing to test line quality
    ; DONE fix curves / curve bug (use turtle graphics)
    ; DONE get repl up
    
    ;
  ; Index
    ;
    
      ; Keyboard Commands
    
       ; right = (turn-right 90)*
       ; left = (turn-left 90)*
       ; command - *toggles above angle between 30, 60 and 90 degrees
       ; up - increases (forward) move distance
       ; down - decreases move distance
       ; shift = (silk)
       ; z - undo
       ; a = (bend-left 5)
       ; s = (bend-right 5)
       ; x - delete drawing
       ; alt - zoom in/out (move mouse right and left respectively)
       ; space - pan drawing (move mouse respectively)
     
       
      ; Functions
       
        ; (forward)      (f)
        ; (backward)     (b)
        ; (silk)         (s)
        ; (turn)         (t)
        ; (turn-right)   (tr)
        ; (turn-left)    (tl)
        ; (curve)        (c)
        ; (curve-right)  (cr)
        ; (curve-left)   (cl)
      
        
      ; Combos
        
        ; retract (r) silk, backward, silk
      
     ;  Examples
        
     (comment ; Tree
       (defn tree [n x]
         (f x)
         (if (> n 1)
           (do 
             (tl 15)
             (tree (- n 1) x)
             (tr 30)
             (tree (- n 1) x)
             (tl 15)))
         (s)
         (b x))
              (tl 90)
              (tree 10 3)      
              )
     
(defn spider!
  "Starts Spider." 
  [& arguments]
  (defsketch spider-window
  :title "Spider!"
  :setup   (fn [] (frame-rate 60) (smooth) (no-fill) (stroke 255) (stroke-weight 1.5))
  :draw (fn [] (spider.renderer/render (spider.simulator/simulate)))
  :target :none
  :key-pressed spider.controller/key-pressed
  :key-released spider.controller/key-released
  :mouse-pressed spider.controller/mouse-pressed
  ;:mouse-released spider.controller/mouse-released
  ;:mouse-dragged spider.controller/mouse-dragged
  :mouse-moved spider.controller/mouse-moved
  ;:focus-lost spider.simulator/save-procedure ;reset preview procedure <-
  :focus-lost spider.controller/focus-lost
  :focus-gained spider.controller/focus-gained
  ;:focus-gained (fn [] (spider.simulator/load-procedure))
  ;:focus-gained (fn [] (binding [*ns* *ns*] (in-ns 'halloween.spider.simulator) (spider.simulator/load-procedure))) ; old
  ;:on-close (fn [] (System/exit 0))
  :renderer :java2d
  :size [800 600])
  (spider.ui/open spider-window)
  )
 

    ;
  ; Startup Sequence
    ;

 (spider!) ; graphics editor

    