(ns halloween.spider.controller
  (:use quil.core)
  (:require [halloween.spider.renderer :as renderer])
  (:require [halloween.spider.simulator :as simulator])
  (:require [halloween.spider.ui :as ui])) ; possibly remove?


(def turn-angle 90)
(def turn-angles [30 60 90])
(def key-pressed :none)
(def mouse-enabled true)
(def mouse-pressed-once true)
(def space false)
(def alt false)
(def scaler 10)
(def pan {:x 0 :y 0})

(defn switch-turn-angle
  [current-turn-angle]
  (let [x current-turn-angle]
  (if (= x 30) 60 (if (= x 60) 90 (if (= x 90) 30)))
    )
  )

(comment
(defn mouse-dragged
  []
  (let [
        location (simulator/global-coords-next-location)
        distance (dist (location :x) (location :y) (mouse-x) (mouse-y))
        old-loc (simulator/global-coords)
        p-distance (dist (location :x) (location :y) (pmouse-x) (pmouse-y))
        angle (Math/atan2 (- (old-loc :y) (mouse-y) ) (- (mouse-x) (old-loc :x)))
        difference (- (mouse-x) (pmouse-x))
        rotated-mousex (* (- (mouse-x) (location :x)) (Math/cos angle))
        ]
    
    (simulator/set-bend (Math/round (- (mouse-x) (location :x))))
    )
  )
)

(defn mouse-moved
  "Updates mouse position in relationship to the the renderer's window."
  []
  (when mouse-enabled
    
    
    (when space
        (def pan (renderer/pan
          {
           :x (- (mouse-x) (pmouse-x))
           :y (- (mouse-y) (pmouse-y))
           }
          ))
        )
    
    (when alt
      (when (< (- (mouse-x) (pmouse-x)) 0)
        (def scaler (- scaler 0.075))
        )
      (when (> (- (mouse-x) (pmouse-x)) 0)
        (def scaler (+ scaler 0.075))
        )
      (when (<= scaler 0)
        (def scaler 0.05)
        )
      (renderer/scaler scaler)
      )

    (let [
          pmx (pmouse-x)
          pmy (pmouse-y) 
          mx  (mouse-x)
          my  (mouse-y)
         ; location (simulator/global-coords-next-location)
         ; distance (dist (location :x) (location :y) (mouse-x) (mouse-y))   
         
          old-loc (simulator/global-coords)
          p-distance (dist (old-loc :x) (old-loc :y) pmx pmy)
          angle (Math/atan2 (- (old-loc :y)  my) (- mx (old-loc :x)))
         ;p-distance (dist (old-loc :x) (old-loc :y)  pmx pmy)
          ;angle (Math/atan2 (- (old-loc :y) my) (- mx (old-loc :x))) 
         ;p-angle (Math/atan2 (-(pmouse-x) (old-loc :x)) (-(pmouse-y) (old-loc :y)))
          ;a (Math/toDegrees (- angle p-angle))
        ]
      
      (simulator/set-slack (Math/round ( / p-distance scaler))) ; 20?
      ;(simulator/set-slack (Math/round (- p-distance 20))); 20?
      (simulator/set-turn (Math/round (Math/toDegrees angle)))
      (ui/print-status (simulator/output-status)) 
      )
    ))

(defn mouse-pressed 
  []
  (when mouse-pressed-once
  (when mouse-enabled
    
    (mouse-moved)
    (simulator/add-bend-slack-turn-move-procedures)
    (simulator/move)
    (simulator/commit-preview-to-web)
    ;(mouse-moved)
    (simulator/set-slack 0))
    )
    (when-not mouse-pressed-once
    (def mouse-pressed-once true)
    (renderer/highlight)
    )
  )

(defn mouse-released 
  []
    (when-not mouse-pressed-once
    (def mouse-pressed-once true)
    (renderer/highlight)
    )
  )


(defn focus-gained
  []
  (def mouse-enabled true)
  )

(defn focus-lost
  []
  (def mouse-enabled false)
  (def mouse-pressed-once false)
  (renderer/unhighlight)
  )

(defn right [] (simulator/turn (* turn-angle -1)) (simulator/add-procedure (list 'turn (* turn-angle -1))))
(defn left [] (simulator/turn turn-angle) (simulator/add-procedure (list 'turn turn-angle)))
(defn up [] (simulator/update-slack 1))
(defn down [] (simulator/update-slack -1))
(defn command [] (def turn-angle (switch-turn-angle turn-angle)))
(defn shift [] (simulator/toggle-pen))
(defn z [] (binding [*ns* *ns*] (in-ns 'halloween.spider.simulator) (simulator/undo)))
(defn a [] (simulator/bend-left 5) (simulator/add-procedure (list 'bend-left 5)))
(defn s [] (simulator/bend-right 5) (simulator/add-procedure (list 'bend-right 5)))

(defn key-pressed []
  
  (case (key-as-keyword)
    :right (right)
    :left (left)
    :up (up)
    :down (down)
    :command (command)
    :shift (shift)
    :z (z)
    :a (a)
    :s (s)
    :x (simulator/delete-procedure)
    :alt (def alt true)
    nil)
  
  (case (int (raw-key))
    32 (def space true)
  nil))

(defn key-released []
  
  (case (key-as-keyword)
    :alt (def alt false)
    nil)
  
  (case (int (raw-key))
    32 (def space false)
    nil))
