(ns halloween.spider.renderer
  (:use quil.core))

(def pan-modifier {:x 0 :y 0})
(def scale-modifier 10)
(def highlighted true)

(defn get-pan-mod [] pan-modifier)
(defn get-scaler [] scale-modifier)

(defn render [spider]
  
  (background 0)
  
  (translate (/ (width) 2)
             (/ (height) 2))
  
  
  (translate (pan-modifier :x)
             (pan-modifier :y))
  
  ;draw crosshair
  
  (if highlighted
    (stroke 100 150 0)
    (stroke 50 50 0)
    )
  (let [s 2]
  (line (- s) (- s) s s)
  (line (- s) s s (- s))
  )
  
  ;draw web

  (let [x   ((spider :location) :x)
        y   ((spider :location) :y)
        slack (spider :slack)
        orientation (spider :orientation)
        web (spider :web)
        pen (:pen (meta (peek web)))]
    
  (stroke 255 100)

  (doseq [strand web]
    (if (= (:pen (meta strand)) :on)
      (stroke 255 200)
      (stroke 255 0 0 50)
      )
    
    (push-matrix)
    
    ;(scale scale-modifier)
    
    (def t1 (random -1.0 1.0)) ; shake shake shake
    (def t2 (random -1.0 1.0))
    
    (translate t1 t2)
    
    (begin-shape)
    (doseq [location strand]
      (when (= (count strand) 1)
        (vertex (* scale-modifier (location :x))  (* scale-modifier (location :y)))
        )
      (when-not (location :curve)
        (vertex (* scale-modifier (location :x)) (* scale-modifier (location :y)))
        )
      (when (location :curve)
        (.bezierVertex 
          (quil.applet/current-applet) ; calling .bezierVertex due to bezier-vertex bug in quil
          (* scale-modifier (:x1 (:curve location)))
          (* scale-modifier (:y1 (:curve location)))
          (* scale-modifier (:x2 (:curve location)))
          (* scale-modifier (:y2 (:curve location)))
          (* scale-modifier (location :x))
          (* scale-modifier (location :y))
          )
        )
      )
    (end-shape)
    (pop-matrix)
    )
 
  (if (= pen :on)
    (stroke 100 150 100)
    (stroke 100 150 100 100)
    )
  
  (push-matrix)
  
   ; (translate (pan-modifier :x)
    ;           (pan-modifier :y))
   
   
   (when (:curve (spider :location))
     (let [
           b-x1 (:x1 (:curve (spider :location)))
           b-y1 (:y1 (:curve (spider :location)))
           b-x2 (:x2 (:curve (spider :location)))
           b-y2 (:y2 (:curve (spider :location)))
           ]
       (bezier 
         (* scale-modifier ((peek (peek web)) :x))
         (* scale-modifier ((peek (peek web)) :y))
         (* scale-modifier b-x1)
         (* scale-modifier b-y1)
         (* scale-modifier b-x2)
         (* scale-modifier b-y2)
         (* scale-modifier x)
         (* scale-modifier y))
       )
     )
   
   (when-not (:curve (spider :location))
     (line 
       (* scale-modifier ((peek (peek web)) :x) )
       (* scale-modifier ((peek (peek web)) :y) )
       (* scale-modifier x)
       (* scale-modifier y)) 
     )
   
   (pop-matrix)
 
   ;Icon
   (translate 
     (* scale-modifier x) 
     (* scale-modifier y)
     )
   ;(translate ((peek (peek web)) :x) ((peek (peek web)) :y)) ; alternative spider position
   (rotate (- orientation))
   
   (let [size 20
         quarter-size (* size 1/4)
         three-quarter-size (* size 3/4)]
     
     (stroke 255 0 0)
     
     ;pincers
     (line (+ (* size 3/2)) 0 (+ (* size 3/2) (/ size 5)) (+ (/ size  10)))
     (line (+ (* size 3/2)) 0 (+ (* size 3/2) (/ size 5)) (+ (/ size -10)))
     
     ;left legs
     (line (+ (/ size 2)) 0 (- quarter-size) (- three-quarter-size))
     (line (+ (/ size 2)) 0 (+ quarter-size) (- three-quarter-size))
     (line (+ (/ size 2)) 0 (+ three-quarter-size) (- three-quarter-size))
     (line (+ (/ size 2)) 0 (+ size quarter-size) (- three-quarter-size))
     
     ;right legs
     (line (+ (/ size 2)) 0 (- quarter-size) (+ three-quarter-size))
     (line (+ (/ size 2)) 0 (+ quarter-size) (+ three-quarter-size))
     (line (+ (/ size 2)) 0 (+ three-quarter-size) (+ three-quarter-size))
     (line (+ (/ size 2)) 0 (+ size quarter-size) (+ three-quarter-size))
     
     ;body
     (fill 80 0 0)
     (ellipse (+ (/ size 2)) 0 size size)
     (ellipse (+ (/ size 2) (* size 3/4) ) 0 (/ size 2) (/ size 2))
     (no-fill)
     
     ;cutters
     (when (= pen :off)
       (stroke 255 0 0)
       (line 0 0 (* -1 quarter-size) (+ (/ size  8)))
       (line 0 0 (* -1 quarter-size) (+ (/ size -8))))
     )
   ))

(defn get-width [] (width))
(defn get-height [] (height))

(defn highlight []
  (def highlighted true)
  )

(defn unhighlight []
  (def highlighted false)
  )

(defn pan [amount]
  (def pan-modifier (merge-with + pan-modifier amount))
  )

(defn scaler [amount]
  (def scale-modifier amount)
  )