(ns halloween.spider.ui
  (:use seesaw.core)
  (:use seesaw.chooser)
  (:use seesaw.keymap)
  (:require [halloween.spider.simulator :as simulator]))

(def input-field (editor-pane)) ; eventually  :content-type "text/x-clojure" ?
(def output-field (text "?"))

(def current-file "drawing.clj")

(native!)

(config! input-field  :font "MONOSPACED-PLAIN-16" :border 6 :background "#222222" :foreground "#DDD" :selection-color "#d80000" :caret-color "#FFF")
(config! output-field :font "MONOSPACED-PLAIN-12" :editable? false :border 6 :background "#666" :foreground "#333" :selection-color "#ccc")


(defn print-status [status](text! output-field (str status)))


(def open-action (action
                    :handler (fn [e] (choose-file :type :open :filters [["Clojure (.clj)" ["clj"]]] :success-fn (fn [fc file] (def current-file (.getAbsolutePath file)) (simulator/load-procedure current-file))))
                    :name "Open"
                    :key  "menu O"
                    :tip  "Open a file."))

(def new-action (action
                    :handler (fn [e] (simulator/delete-procedure))
                    :name "New"
                    :key  "menu X"
                    :tip  "Create a new file."))

(def save-as-action (action
                    :handler (fn [e] (choose-file :type :save :filters [["Clojure (.clj)" ["clj"]]] :success-fn (fn [fc file] (def current-file (str (.getAbsolutePath file) ".clj")) (simulator/save-procedure current-file))))
                    :name "Save as..."
                    :tip  "Saves .clj file as specified name."))

(def save-action (action
                    :handler (fn [e] (simulator/save-procedure current-file) (print-status (str "Saved " current-file)))
                    :name "Save"
                    :key  "menu S" 
                    :tip  "Overwrites the currently loaded .clj file."))
      
(def exit-action (action
                    :handler (fn [e] (.dispose (to-frame e)))
                    :name "Quit"
                    :key "menu Q"
                    :tip  "Close this window"))


(def f (frame :title "Spider"
              :width 800
              :height 680
              :resizable? false
              :on-close :exit
              :menubar (menubar :items 
                       [(menu :text "File" :items [new-action open-action save-action save-as-action exit-action])])
                        ;(menu :text "Edit" :items [copy-action paste-action])])
              ))

(defn open [papplet]
  (def contents (vertical-panel :items [papplet input-field output-field]))
  (config! f :content contents)
  (-> f show!)
  (request-focus! papplet)
  )

;(listen f :window-activated (fn [e] (simulator/load-procedure "drawing.clj") (print-status "loaded")))
;(listen f :window-deactivated (fn [e] (simulator/save-procedure "drawing.clj") (print-status "saved")))

;(listen f :window-activated (fn [e] 
                              ;(simulator/load-procedure "drawing.clj")
                              
                              ;(print-status "loaded"))
                              ;)


(defn evaluate
  []
  (simulator/reset-preview-parameters)
  (binding [*ns* (the-ns 'halloween.spider.simulator)]
    (binding [*read-eval* false] (load-string (text input-field)))) ; is this binding unnecessary?
  ;(text! output-field "<|:^)")
  )

; (with-out-str (with-pprint-dispatch code-dispatch (pprint procedure)))

(defn eval-input
  [add-to-procedure]
  (text! output-field "?")
  (try
    (print-status (str (evaluate)))
    (when add-to-procedure (simulator/concat-procedure (vec (binding [*read-eval* false] (read-string (str "(" (text input-field) ")"))))))
    (catch Exception e (text! output-field (.getLocalizedMessage e))))
    )

(def listener (listen input-field :document (fn [e] (eval-input false))))

(listen input-field :focus-gained (fn [e] (simulator/reset-saved-info) (eval-input false)))
(listen input-field :focus-lost (fn [e] (simulator/reset-preview-parameters)))

(map-key input-field "ctrl ENTER" (fn [e]
                                      (listener) ; removes document listening
                                      (eval-input true)
                                      (text! input-field "");
                                      (def listener (listen input-field :document (fn [e] (eval-input false))))
                                      (simulator/commit-preview-to-web)
                                      ))
