;-
; Copyright 2011 © Meikel Brandmeyer.
; All rights reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
; THE SOFTWARE.

(ns ^{:doc
  "Provide some Clojure sugar for internationalisation using the usual
  Java infrastructure of ResourceBundles."
      :author "Meikel Brandmeyer <m@kotka.de>"}
  j18n.core
  (:import
    java.util.ResourceBundle
    java.util.Set))

(def ^{:private true :tag Set} bundle-keys
  (memoize #(.keySet ^ResourceBundle %)))

(defn resource
  "Look up the given key in the given bundle. A key is a fully qualified
  keyword. The namespace part of the keyword specifies the bundle. The name
  part of the keyword is finally looked up as the key in the bundle.

  Optionally the bundle might be given explicitly as second argument. In
  that case the key may also be an unqualified keyword or a string."
  ([key]
   {:pre [(keyword? key) (namespace key)]}
   (let [bundle (-> key namespace munge ResourceBundle/getBundle)]
     (resource key bundle)))
  ([key ^ResourceBundle bundle]
   {:pre [(or (keyword? key) (string? key))]}
   (let [key (name key)]
     (when (.contains (bundle-keys bundle) key)
       (.getString bundle key)))))
