/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.GlobalOptimizer;
import adobe.abc.Namespace;
import adobe.abc.Nsset;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Name
implements Comparable<Name> {
    final int kind;
    final Nsset nsset;
    final String name;
    private final Name type_param;
    private final Name parameterized_type;
    public int iid;
    private static final HashMap<Namespace, Name> m_anyMapByNamespace = new HashMap();
    private static final int ANYflags = Integer.MAX_VALUE;

    Name(int kind, int apiVersion) {
        this(kind, GlobalOptimizer.uniqueNs(apiVersion), GlobalOptimizer.unique());
        assert (kind != Integer.MAX_VALUE);
    }

    Name(Namespace ns, String name) {
        this(7, ns, name);
    }

    public Name(int kind, Namespace ns, String name) {
        this(kind, name, new Nsset(new Namespace[]{ns}), null, null);
        assert (kind != Integer.MAX_VALUE);
    }

    public Name(int kind, String name, Nsset nsset) {
        this(kind, name, nsset, null, null);
        assert (kind != Integer.MAX_VALUE);
    }

    Name(Name parameterized_type_name, Name type_param_name) {
        this(29, parameterized_type_name.name, parameterized_type_name.nsset, parameterized_type_name, type_param_name);
    }

    private Name(int kind, String name, Nsset nsset, Name parameterized_type_name, Name type_param_name) {
        assert (nsset != null);
        this.kind = kind;
        this.nsset = nsset;
        this.name = name;
        this.type_param = type_param_name;
        this.parameterized_type = parameterized_type_name;
        this.iid = -1;
    }

    private Name(Name n2, Namespace ns) {
        assert (n2 != null);
        this.name = n2.name;
        this.kind = n2.kind;
        this.parameterized_type = n2.parameterized_type;
        this.type_param = n2.type_param;
        Namespace[] nss = new Namespace[]{ns};
        this.nsset = new Nsset(nss);
    }

    public Namespace nsset(int i2) {
        return this.nsset.nsset[i2];
    }

    public String toString() {
        return this.name != null ? this.name : "*";
    }

    public String format() {
        if (this.nsset.length == 1) {
            String typeParamStr = this.type_param != null ? ".<" + this.type_param.format() + ">" : "";
            String nStr = this.name != null ? this.name : "*";
            return this.nsset(0) + "::" + nStr + typeParamStr;
        }
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        for (Namespace n2 : this.nsset) {
            list.add(n2);
        }
        String typeParamStr = this.type_param != null ? ".<" + this.type_param.format() + ">" : "";
        String nStr = this.name != null ? this.name : "*";
        return list + "::" + nStr + typeParamStr;
    }

    public Name append(String s2) {
        String newName = this.name != null ? this.name + s2 : s2;
        return new Name(this.kind, newName, this.nsset, this.parameterized_type, this.type_param);
    }

    private int hc(Object o2) {
        return o2 != null ? o2.hashCode() : 0;
    }

    public int hashCode() {
        return this.kind ^ this.hc(this.nsset) ^ this.hc(this.name) ^ this.hc(this.type_param);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Name)) {
            return false;
        }
        Name o2 = (Name)other;
        return this.kind == o2.kind && this.name != null == (o2.name != null) && (this.name == o2.name || this.name.equals(o2.name)) && this.nsset.equals(o2.nsset) && this.equals(this.type_param, o2.type_param);
    }

    private boolean equals(Object a, Object b3) {
        if (a == b3) {
            return true;
        }
        if (a == null || b3 == null) {
            return false;
        }
        return a.equals(b3);
    }

    @Override
    public int compareTo(Name other) {
        int d2 = this.kind - other.kind;
        if (d2 != 0) {
            return d2;
        }
        if (this.name != null && other.name != null) {
            d2 = this.name.compareTo(other.name);
        } else if (this.name != null) {
            d2 = 1;
        } else if (other.name != null) {
            d2 = -1;
        }
        if (d2 != 0) {
            return d2;
        }
        d2 = Nsset.compareTo(this.nsset, other.nsset);
        if (d2 != 0) {
            return d2;
        }
        d2 = this.type_param != null && other.type_param != null ? this.type_param.compareTo(other.type_param) : (this.type_param != null ? 1 : (other.type_param != null ? -1 : 0));
        return d2;
    }

    public boolean isAttr() {
        return this.kind == 14 || this.kind == 13 || this.kind == 16 || this.kind == 18 || this.kind == 28;
    }

    private int attr() {
        return this.isAttr() ? 1 : 0;
    }

    public boolean isQname() {
        return this.kind == 7 || this.kind == 13 || this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 18;
    }

    public boolean isParameterizedTypeName() {
        assert (this.type_param != null == (this.kind == 29));
        return this.type_param != null;
    }

    public Name getParameterizedTypeName() {
        assert (this.isParameterizedTypeName());
        return this.parameterized_type;
    }

    public Name getTypeParamName() {
        assert (this.isParameterizedTypeName());
        return this.type_param;
    }

    public boolean runtimeName() {
        return this.kind == 17 || this.kind == 18 || this.kind == 27 || this.kind == 28;
    }

    public boolean runtimeNamespace() {
        return this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 18;
    }

    private boolean isStaticName() {
        return this.kind == 7 || this.kind == 9 || this.kind == 13 || this.kind == 14 || this.isParameterizedTypeName() && (this.type_param.isStaticName() || this.type_param.isAny()) && this.parameterized_type.isStaticName();
    }

    public boolean isAny() {
        return this.kind == Integer.MAX_VALUE && this.name.equals("*");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean match(Name b3) {
        assert (b3.isStaticName());
        assert (b3.nsset.length == 1);
        if (this == b3) {
            return true;
        }
        if (!this.isStaticName()) {
            return false;
        }
        if (this.attr() - b3.attr() != 0) {
            return false;
        }
        if (this.name != null && b3.name != null) {
            if (this.name.compareTo(b3.name) != 0) {
                return false;
            }
        } else {
            if (this.name != null) {
                return false;
            }
            if (b3.name != null) {
                return false;
            }
        }
        if (this.type_param != null) {
            if (b3.type_param == null) return false;
            if (this.type_param.compareTo(b3.type_param) == 0) return this.nsset.match(b3.nsset);
            return false;
        }
        if (b3.type_param == null) return this.nsset.match(b3.nsset);
        return false;
    }

    public boolean containsPublic() {
        return this.nsset.containsPublic();
    }

    public static Name ANY(Namespace ns) {
        Name result = m_anyMapByNamespace.get(ns);
        if (result == null) {
            result = new Name(Integer.MAX_VALUE, "*", new Nsset(new Namespace[]{ns}), null, null);
            m_anyMapByNamespace.put(ns, result);
        }
        return result;
    }

    public static Name getVersionedName(Name name) {
        assert (name != null);
        Namespace ns = name.nsset(0);
        if (!ns.isPrivate()) {
            int apiVersion = 24;
            for (Namespace nsi : name.nsset) {
                int a = Namespace.getValidApiVersion(nsi.getApiVersion());
                if (a >= apiVersion) continue;
                apiVersion = a;
            }
            ns = Namespace.getVersionedNamespace(ns, apiVersion);
        }
        return new Name(name, ns);
    }
}

