/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.APIVersionedURI;
import adobe.abc.APIVersions;
import adobe.abc.Domain;
import adobe.abc.GlobalOptimizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Namespace
implements Comparable<Namespace> {
    final int kind;
    final String uri;
    private int api;
    private String comparableUri;
    private static ArrayList<Namespace> m_namespaces;
    private static final int MIN_API_MARK = 58004;

    Namespace(int kind, String uri, int api) {
        this.kind = kind;
        this.api = api;
        this.uri = uri == null ? "" : uri;
        this.comparableUri = this.isPrivate() ? GlobalOptimizer.unique() : uri;
    }

    private Namespace(int kind, String uri, Domain domain) {
        this(kind, uri, 0);
        this.api = 0;
        if (Namespace.isPublicKind(kind)) {
            ApiVersionInfo versionInfo = this.getBaseURIAndApiVersion(uri, 0);
            int apiVersion = versionInfo.api;
            if (domain.isBuiltin()) {
                if (versionInfo.hasVersionMark) {
                    this.comparableUri = versionInfo.uri;
                } else if (Namespace.isVersionedURI(uri)) {
                    apiVersion = 24;
                }
            } else {
                apiVersion = domain.api;
            }
            this.api = Namespace.getValidApiVersion(apiVersion);
        } else assert (!this.getBaseURIAndApiVersion((String)this.uri, (int)0).hasVersionMark);
    }

    private ApiVersionInfo getBaseURIAndApiVersion(String uri, int api) {
        int idx;
        char mark;
        if (uri.length() > 0 && (mark = uri.charAt(idx = uri.length() - 1)) >= '\ue294' && mark < '\ue2ad') {
            api = mark - 58004;
            uri = idx > 0 ? uri.substring(0, idx) : "";
            return new ApiVersionInfo(api, true, uri);
        }
        return new ApiVersionInfo(api, false, uri);
    }

    private static boolean isVersionedURI(String uri) {
        boolean result;
        assert (uri != null);
        if (uri.length() == 0) {
            return true;
        }
        boolean bl2 = result = Arrays.binarySearch(APIVersionedURI.builtin_versioned_uris, uri) >= 0;
        if (!result) {
            result = Arrays.binarySearch(APIVersionedURI.avmglue_versioned_uris, uri) >= 0;
        }
        return result;
    }

    public int getApiVersion() {
        return this.api;
    }

    public static int getValidApiVersion(int apiVersion) {
        assert (apiVersion >= 0 && apiVersion < 25);
        return APIVersions.kApiVersionSeriesTransfer[apiVersion][0];
    }

    boolean isPublic() {
        return this.kind == 8 || this.kind == 22;
    }

    boolean isInternal() {
        return this.kind == 23;
    }

    boolean isPrivate() {
        return this.kind == 5;
    }

    boolean isPrivateOrInternal() {
        return this.isPrivate() || this.isInternal();
    }

    boolean isProtected() {
        return this.kind == 24 || this.kind == 26;
    }

    public String toString() {
        return this.uri.length() > 0 ? this.uri : "public";
    }

    public int hashCode() {
        return this.kind ^ this.uri.hashCode();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace)o2;
        return this.kind == other.kind && this.comparableUri.equals(other.comparableUri);
    }

    @Override
    public int compareTo(Namespace other) {
        if (other == null) {
            return 1;
        }
        int i2 = this.kind - other.kind;
        if (i2 != 0) {
            return i2;
        }
        return this.comparableUri.compareTo(other.comparableUri);
    }

    public static int compareTo(Namespace a, Namespace b3) {
        if (a == null && b3 == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        return a.compareTo(b3);
    }

    public static boolean isPublicKind(int kind) {
        return kind == 8 || kind == 22;
    }

    public static Namespace findNamespace(int kind, String uri, int api) {
        Namespace result = null;
        ArrayList<Namespace> namespaces = Namespace.getNamespaces();
        boolean found = false;
        Iterator<Namespace> nsi = namespaces.iterator();
        while (!found && nsi.hasNext()) {
            result = nsi.next();
            found = result.kind == kind && result.comparableUri.equals(uri) && result.api == api;
        }
        return found ? result : null;
    }

    public static Namespace getNamespaceFromVersionedURI(int kind, String uri, Domain domain) {
        Namespace result = new Namespace(kind, uri, domain);
        if (Namespace.findNamespace(result.kind, result.uri, result.api) == null) {
            Namespace.getNamespaces().add(result);
        }
        return result;
    }

    public static Namespace getVersionedNamespace(int kind, String uri, int api) {
        Namespace result = Namespace.findNamespace(kind, uri, api);
        if (result == null) {
            result = Namespace.createNamespace(kind, uri, api);
        }
        return result;
    }

    public static Namespace getVersionedNamespace(Namespace ns, int api) {
        assert (!ns.isPrivate());
        Namespace result = ns;
        if (!Namespace.isVersionedURI(ns.comparableUri)) {
            return result;
        }
        result = Namespace.findNamespace(ns.kind, ns.comparableUri, api);
        if (result == null) {
            result = Namespace.createNamespace(ns.kind, ns.comparableUri, api);
        }
        return result;
    }

    private static Namespace createNamespace(int kind, String uri, int api) {
        Namespace result = new Namespace(kind, uri, api);
        Namespace.getNamespaces().add(result);
        return result;
    }

    private static ArrayList<Namespace> getNamespaces() {
        if (m_namespaces == null) {
            m_namespaces = new ArrayList();
        }
        return m_namespaces;
    }

    private class ApiVersionInfo {
        public final int api;
        public final boolean hasVersionMark;
        public final String uri;

        ApiVersionInfo(int api, boolean hasVersion, String uri) {
            this.api = api;
            this.hasVersionMark = hasVersion;
            this.uri = uri;
        }
    }
}

