/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.CentralDirectoryReader;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.ucf.UCF;
import com.adobe.ucf.UCFOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ADTOutputStream
extends UCFOutputStream {
    protected static final String ICON_PNG = "Icon.png";
    protected static final String ICON_2X_PNG = "Icon@2x.png";
    protected static final String ICON_SMALL_PNG = "Icon-Small.png";
    protected static final String ICON_SMALL_48 = "Icon-Small-50.png";
    protected static final String ICON_SMALL_50 = "Icon-Small-50.png";
    protected static final String ICON_SMALL_50_2X = "Icon-Small-50@2x.png";
    protected static final String ICON_SMALL_2X = "Icon-Small@2x.png";
    protected static final String ICON_LARGE_PNG = "Icon-Large.png";
    protected static final String ICON_2X_LARGE_PNG = "Icon@2x-Large.png";
    protected static final String ITUNES_ARTWORK = "iTunesArtwork";
    protected static final String ITUNES_ARTWORK_2X = "iTunesArtwork@2x";
    private static Set<Pattern> RESTRICTED_PATTERNS;
    protected static final Map<String, Integer> SPECIAL_ICON_SIZES;
    protected ApplicationDescriptor.ValidationParams m_validationParams = null;
    protected ApplicationPackager m_packager;
    protected boolean m_validate = true;
    protected Listener m_listener;
    protected ApplicationDescriptor m_applicationDescriptor;
    private ZipEntry m_signatureEntry = null;

    public void addAIRFile(ZipFile inputFile, String expectedMimetype) throws InvalidInputException, SDKDamagedException {
        this.addAIRFile(inputFile, expectedMimetype, "ALL", null);
    }

    protected void addAIRFile(ZipFile inputFile, String expectedMimetype, String targetPlatform, Set<String> exclusionSet) throws InvalidInputException, SDKDamagedException {
        CentralDirectoryReader cdr = null;
        try {
            Pattern platformSpecificExtensionFile = Pattern.compile("META-INF/AIR/extensions/[^/]+/META-INF/ANE/([^/]+)/.+");
            cdr = new CentralDirectoryReader(inputFile);
            Enumeration<? extends ZipEntry> entries = inputFile.entries();
            boolean expectSignature = !expectedMimetype.equals("application/vnd.adobe.air-application-intermediate-package+zip");
            boolean sawInitialContent = false;
            HashSet<String> seenIconPaths = new HashSet<String>();
            int index = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                cdr.advanceHeader(name);
                ZipEntryInputStream is = new ZipEntryInputStream(inputFile, entry);
                if (name.equals("mimetype")) {
                    if (index != 0) {
                        throw new InvalidInputException("mimetype out of place");
                    }
                    String currentMimetype = UCF.stringFromInputStream(is);
                    if (!currentMimetype.equals(expectedMimetype)) {
                        throw new InvalidInputException("wrong mimetype");
                    }
                } else if (name.equals("META-INF/AIR/application.xml")) {
                    if (index != 1) {
                        throw new InvalidInputException("application descriptor out of place");
                    }
                    this.addDescriptorFromZipEntry(entry, is);
                    this.addHashFile("META-INF/AIR/hash");
                } else if (name.equals("META-INF/AIR/hash")) {
                    if (index != 2) {
                        throw new InvalidInputException("hash file out of place");
                    }
                } else {
                    if (index < 3) {
                        throw new InvalidInputException("incorrect file order");
                    }
                    if (name.equals("META-INF/signatures.xml")) {
                        if (!expectSignature) {
                            throw new InvalidInputException("intermediate file contains a signature");
                        }
                        if (this.m_signatureEntry != null) {
                            throw new InvalidInputException("contains more than one signature file");
                        }
                        this.m_signatureEntry = entry;
                    } else if (this.m_applicationDescriptor != null && this.m_applicationDescriptor.initialContent().equals(name)) {
                        this.addInitialContentFromZipEntry(entry, is, cdr.getPermissions());
                        sawInitialContent = true;
                    } else if (this.m_applicationDescriptor != null && this.m_applicationDescriptor.icons().contains(name)) {
                        this.addIconFromZipEntry(entry, is, cdr.getPermissions());
                        seenIconPaths.add(name);
                    } else if (exclusionSet == null || !exclusionSet.contains(name)) {
                        if (targetPlatform.equals("ALL")) {
                            this.addFileFromZipEntry(entry, is, cdr.getPermissions());
                        } else {
                            Matcher m2 = platformSpecificExtensionFile.matcher(name);
                            if (!m2.matches() || m2.group(1).equals(targetPlatform)) {
                                this.addFileFromZipEntry(entry, is, cdr.getPermissions());
                            }
                        }
                    }
                }
                ((InputStream)is).close();
                ++index;
            }
            if (!expectSignature && index < 3) {
                throw new InvalidInputException("not a complete airi file");
            }
            if (expectSignature && (index < 4 || this.m_signatureEntry == null)) {
                throw new InvalidInputException("not a complete air(n) file");
            }
            if (!sawInitialContent) {
                throw new InvalidInputException("initial content missing: " + this.m_applicationDescriptor.initialContent());
            }
            for (String iconPath : this.m_applicationDescriptor.icons()) {
                if (seenIconPaths.contains(iconPath)) continue;
                throw new InvalidInputException("icon missing: " + iconPath);
            }
        }
        catch (DescriptorValidationException e2) {
            throw new InvalidInputException("File " + inputFile.getName() + " has an invalid descriptor: " + e2.getMessage());
        }
        catch (InvalidInputException e3) {
            throw new InvalidInputException("File " + inputFile.getName() + " is malformed: " + e3.getMessage());
        }
        catch (IOException e4) {
            throw new InvalidInputException("File " + inputFile.getName() + " is malformed");
        }
        finally {
            try {
                if (cdr != null) {
                    cdr.close();
                }
            }
            catch (IOException e5) {}
        }
    }

    public void addANEFile(ZipFile inputFile, boolean inputSigned) throws InvalidInputException {
        CentralDirectoryReader cdr = null;
        try {
            cdr = new CentralDirectoryReader(inputFile);
            Enumeration<? extends ZipEntry> entries = inputFile.entries();
            int index = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                cdr.advanceHeader(name);
                ZipEntryInputStream is = new ZipEntryInputStream(inputFile, entry);
                if (name.equals("mimetype")) {
                    if (index != 0) {
                        throw new InvalidInputException("mimetype out of place");
                    }
                    String inputMimeType = "application/vnd.adobe.air-native-extension-package+zip";
                    String currentMimeType = UCF.stringFromInputStream(is);
                    if (!currentMimeType.equals(inputMimeType)) {
                        throw new InvalidInputException("wrong mimetype");
                    }
                    ((InputStream)is).reset();
                    this.addFileFromZipEntry(entry, is, DEFAULT_FILE_PERMISSONS);
                } else if (name.equals("META-INF/ANE/extension.xml")) {
                    if (index != 1) {
                        throw new InvalidInputException("extension descriptor out of place");
                    }
                    this.addFileFromZipEntry(entry, is, DEFAULT_FILE_PERMISSONS);
                } else if (name.equals("META-INF/signatures.xml")) {
                    if (!inputSigned) {
                        throw new InvalidInputException("intermediate file contains a signature");
                    }
                    if (this.m_signatureEntry != null) {
                        throw new InvalidInputException("contains more than one signature file");
                    }
                    this.m_signatureEntry = entry;
                } else {
                    this.addFileFromZipEntry(entry, is, cdr.getPermissions());
                }
                ((InputStream)is).close();
                ++index;
            }
            if (!inputSigned && index < 3) {
                throw new InvalidInputException("not a complete ane file");
            }
            if (inputSigned && (index < 4 || this.m_signatureEntry == null)) {
                throw new InvalidInputException("not a complete air file");
            }
        }
        catch (DescriptorValidationException e2) {
            throw new InvalidInputException("File " + inputFile.getName() + " has an invalid descriptor: " + e2.getMessage());
        }
        catch (InvalidInputException e3) {
            throw new InvalidInputException("File " + inputFile.getName() + " is malformed: " + e3.getMessage());
        }
        catch (IOException e4) {
            throw new InvalidInputException("File " + inputFile.getName() + " is malformed");
        }
        finally {
            try {
                if (cdr != null) {
                    cdr.close();
                }
            }
            catch (IOException e5) {}
        }
    }

    public ZipEntry getSignatureEntry() {
        return this.m_signatureEntry;
    }

    public void addApplicationDescriptor(ApplicationDescriptor descriptor, boolean sign) throws IOException {
        this.m_applicationDescriptor = descriptor;
        if (this.m_validationParams == null) {
            this.setValidationParams(this.m_packager.getValidationParams(this.m_applicationDescriptor));
        }
        if (this.m_validate) {
            ADTOutputStream.addRestrictedFileName(this.getApplicationDescriptor().filename() + ".exe");
            ADTOutputStream.addRestrictedFileName(this.getApplicationDescriptor().filename());
        }
    }

    public abstract void addHashFile(String var1) throws IOException;

    public abstract void addInitialContentFromZipEntry(ZipEntry var1, InputStream var2, long var3) throws IOException;

    public abstract void addIconFromZipEntry(ZipEntry var1, InputStream var2, long var3) throws IOException;

    public abstract void addDescriptorFromZipEntry(ZipEntry var1, InputStream var2) throws IOException;

    public void addFileFromZipEntry(ZipEntry entry, ZipFile file, String path) throws IOException {
        this.addFileFromZipEntry(entry, file, path, DEFAULT_FILE_PERMISSONS);
    }

    public void addFileFromZipEntry(ZipEntry entry, ZipFile file, String path, long permissions) throws IOException {
        this.checkPath(path);
        this.addFileFromStream(path, file.getInputStream(entry), entry.getSize(), permissions, entry.getTime(), true);
    }

    public void addFileFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.checkPath(entry.getName());
        this.addFileFromStream(entry.getName(), data, entry.getSize(), permissions, entry.getTime(), true);
    }

    protected void addFileFromStream(String name, InputStream in, long permissions, boolean addToSignature) throws IOException {
        this.addFileFromStream(name, in, in.available(), permissions, new Date().getTime(), addToSignature);
    }

    protected void addFileFromStream(String name, InputStream in, long size, long permissions, long time, boolean addToSignature) throws IOException {
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date(time));
        record.path = name;
        record.permissions = permissions != 0L ? permissions : DEFAULT_FILE_PERMISSONS;
        this.addFile(record, in, addToSignature, true);
    }

    @Override
    public void addFile(File file, String path, boolean addToSignature) throws IOException {
        if (this.m_validate) {
            this.checkPath(path);
        }
        super.addFile(file, path, addToSignature);
    }

    protected void checkPath(String path) throws InvalidInputException {
        for (String icon : SPECIAL_ICON_SIZES.keySet()) {
            if (icon.compareToIgnoreCase(path) != 0) continue;
            int size = SPECIAL_ICON_SIZES.get(icon);
            if (icon.compareTo(path) != 0) {
                throw new InvalidInputException("The path " + path + " is restricted. If you were trying to package " + icon + " you should correct the case.");
            }
            if (path.equals(this.getApplicationDescriptor().getIcon(size))) continue;
            throw new InvalidInputException("The file with the path " + path + " cannot be packaged unless the descriptor field application.icon.image" + size + "x" + size + " is set to " + path);
        }
        for (Pattern restrictedPattern : RESTRICTED_PATTERNS) {
            if (!restrictedPattern.matcher(path).matches()) continue;
            throw new InvalidInputException("The path " + path + " is restricted. Choose another name for this file.");
        }
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return this.m_applicationDescriptor;
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    public void setValidationParams(ApplicationDescriptor.ValidationParams validationParams) {
        this.m_validationParams = validationParams;
    }

    public void setPackager(ApplicationPackager packager) {
        this.m_packager = packager;
    }

    private static void addRestrictedFileName(String name) {
        RESTRICTED_PATTERNS.add(Pattern.compile(name, 2));
    }

    protected void setValidate(boolean validate) {
        this.m_validate = validate;
    }

    static {
        String[] restrictedPaths;
        RESTRICTED_PATTERNS = new HashSet<Pattern>();
        for (String path : restrictedPaths = new String[]{"setup.msi", "setup.reg", "Adobe AIR", "Icon.icns", "DocumentIcon\\d*\\.icns", "CodeResources", "_CodeSignature", "_Codesignature/.*", "Info.plist", "ResourceRules.plist", "MainWindow.nib", "[^/]*\\.lproj/InfoPlist.strings"}) {
            ADTOutputStream.addRestrictedFileName(path);
        }
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put(ICON_SMALL_PNG, 29);
        tempMap.put("Icon-Small-50.png", 48);
        tempMap.put("Icon-Small-50.png", 50);
        tempMap.put(ICON_PNG, 57);
        tempMap.put(ICON_SMALL_2X, 58);
        tempMap.put(ICON_LARGE_PNG, 72);
        tempMap.put(ICON_SMALL_50_2X, 100);
        tempMap.put(ICON_2X_PNG, 114);
        tempMap.put(ICON_2X_LARGE_PNG, 144);
        tempMap.put(ITUNES_ARTWORK, 512);
        tempMap.put(ITUNES_ARTWORK_2X, 1024);
        SPECIAL_ICON_SIZES = Collections.unmodifiableMap(tempMap);
    }

    private class ZipEntryInputStream
    extends InputStream {
        private InputStream _in;
        private ZipFile _zip;
        private ZipEntry _entry;

        public ZipEntryInputStream(ZipFile zip, ZipEntry entry) throws IOException {
            this._zip = zip;
            this._entry = entry;
            this._in = zip.getInputStream(entry);
        }

        public int read() throws IOException {
            return this._in.read();
        }

        public int read(byte[] b3, int off, int len) throws IOException {
            return this._in.read(b3, off, len);
        }

        public int read(byte[] b3) throws IOException {
            return this._in.read(b3);
        }

        public int available() throws IOException {
            return this._in.available();
        }

        public void close() throws IOException {
            this._in.close();
        }

        public void reset() throws IOException {
            this._in.close();
            this._in = this._zip.getInputStream(this._entry);
        }
    }
}

