/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.air.validator.DescriptorValidator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Descriptor {
    protected Map<String, String> _localizedNames = null;
    protected DescriptorValidationException _failureException = null;
    protected DescriptorValidator _validator = null;
    protected Document _document;
    protected byte[] _descriptorBytes;
    protected String _descriptorFileName = "Descriptor";

    public Descriptor(File descriptorFile) throws DescriptorValidationException {
        this(descriptorFile, true);
    }

    public Descriptor(InputStream in) throws DescriptorValidationException {
        this(in, true);
    }

    public Descriptor(File descriptorFile, boolean validate) throws DescriptorValidationException {
        this.setInput(descriptorFile);
        if (validate) {
            this.validateXML();
        }
    }

    public Descriptor(InputStream in, boolean validate) throws DescriptorValidationException {
        this.setInput(in);
        if (validate) {
            this.validateXML();
        }
    }

    public Descriptor(InputStream in, boolean validate, String name) throws DescriptorValidationException {
        this._descriptorFileName = name;
        this.setInput(in);
        if (validate) {
            this.validateXML();
        }
    }

    protected void setInput(File descriptorFile) throws DescriptorValidationException {
        if (descriptorFile == null) {
            throw new IllegalArgumentException("set null descriptor");
        }
        this._descriptorFileName = descriptorFile.getPath();
        try {
            FileInputStream in = new FileInputStream(descriptorFile);
            this.setInput(in);
            ((InputStream)in).close();
        }
        catch (IOException e2) {
            this.dispatchError(301);
        }
    }

    protected void setInput(InputStream in) throws DescriptorValidationException {
        try {
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            this.setInput(bytes);
        }
        catch (IOException e2) {
            this.dispatchError(301);
        }
    }

    private void setInput(byte[] descriptorFileBytes) throws DescriptorValidationException {
        this._descriptorBytes = descriptorFileBytes;
    }

    protected void validateXML() throws DescriptorValidationException {
        String validatorClassName;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        this._document = null;
        documentBuilderFactory.setNamespaceAware(true);
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            this._document = builder.parse(new ByteArrayInputStream(this._descriptorBytes));
        }
        catch (IOException e2) {
            this.dispatchError(301);
        }
        catch (SAXException e3) {
            this.dispatchError(100);
        }
        catch (ParserConfigurationException e4) {
            this.dispatchError(100);
        }
        String namespaceUri = this._document.getDocumentElement().getNamespaceURI();
        if (namespaceUri == null) {
            this.dispatchError(101, -1, -1, null);
        }
        if ((validatorClassName = this.getValidatorClassNameFromNamespaceUri(namespaceUri)) == null) {
            this.dispatchError(102, -1, -1, new String[]{namespaceUri});
        }
        Class<?> validatorClass = null;
        try {
            validatorClass = Class.forName(validatorClassName);
            this._validator = (DescriptorValidator)validatorClass.newInstance();
            this._validator.setDescriptorName(this._descriptorFileName);
            this._validator.setListener(new Listener(){

                public void message(Message message) {
                    if (Descriptor.this._failureException == null) {
                        Descriptor.this._failureException = new DescriptorValidationException(message);
                    } else {
                        Descriptor.this._failureException.appendErrorMessage(message);
                    }
                }

                public void progress(int soFar, int total) {
                }
            });
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            SAXParser parser = null;
            parser = saxParserFactory.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(this._descriptorBytes), (DefaultHandler)this._validator);
            this.failIfError();
        }
        catch (ClassNotFoundException e5) {
            throw new RuntimeException("cannot load appropriate validator:'" + e5.getMessage() + "'");
        }
        catch (DescriptorValidationException e6) {
            throw e6;
        }
        catch (IOException e7) {
            e7.printStackTrace();
            throw new RuntimeException(e7.getMessage());
        }
        catch (SAXException e8) {
            throw new RuntimeException(e8.getMessage());
        }
        catch (ParserConfigurationException e9) {
            throw new RuntimeException(e9.getMessage());
        }
        catch (InstantiationException e10) {
            throw new RuntimeException(e10.getMessage());
        }
        catch (IllegalAccessException e11) {
            throw new RuntimeException(e11.getMessage());
        }
    }

    protected void failIfError() throws DescriptorValidationException {
        if (this._failureException != null) {
            throw this._failureException;
        }
    }

    protected void dispatchError(int code) throws DescriptorValidationException {
        this.dispatchError(code, -1, -1, null);
    }

    protected void dispatchError(int code, int line, int column, String[] identifiers) throws DescriptorValidationException {
        throw new DescriptorValidationException(new Message(code, "ERROR", this._descriptorFileName, line, column, identifiers));
    }

    public byte[] getBytes() {
        return this._descriptorBytes;
    }

    protected DescriptorValidator getValidator() {
        return this._validator;
    }

    protected abstract String getValidatorClassNameFromNamespaceUri(String var1);
}

