/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.ADTException;
import com.adobe.air.ADTOutputStream;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ExtensionDescriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.android.AndroidDeviceSDK;
import com.adobe.air.apk.APKSigner;
import com.adobe.air.apk.AppManifestHandler;
import com.adobe.air.apk.ReplaceStringFile;
import com.adobe.air.apk.ResourceBytecodeGenerator;
import com.adobe.air.mobile.DebuggingModes;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.ucf.CodeSigner;
import com.adobe.ucf.UCFOutputStream;
import com.adobe.ucf.Utils;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jf.smali.main;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APKOutputStream
extends ADTOutputStream {
    protected static final String ASSETS_FOLDER = "assets/";
    protected static final String METAINF_FOLDER = "META-INF/AIR/";
    protected static final String RES_RAW_FOLDER = "res/raw/";
    protected static final String DEBUG_INFO = "debuginfo";
    protected static final String RGBA8888 = "rgba8888";
    protected static final String RES_FOLDER = "res/";
    protected static final String RES_DRAWABLE_FOLDER = "res/drawable/";
    protected static final String RES_DRAWABLE_H_FOLDER = "res/drawable-hdpi/";
    protected static final String RES_DRAWABLE_L_FOLDER = "res/drawable-ldpi/";
    protected static final String RES_DRAWABLE_M_FOLDER = "res/drawable-mdpi/";
    protected static final String ICON_NAME = "icon.png";
    protected static final String ANDROID_MANIFEST_PATH = "AndroidManifest_template.xml";
    protected static final String ANDROID_MANIFEST_BIN = "AndroidManifest.xml";
    protected static final String RESOURCES_ARSC = "resources.arsc";
    protected static final String CLASSES_DEX_RELEASE_PATH = "Dex/classes_release.dex";
    protected static final String CLASSES_DEX_DEBUG_PATH = "Dex/classes_debug.dex";
    protected static final String CLASSES_DEX_OUT = "classes.dex";
    protected static final String PACKAGE_NAME_PRE = "air.";
    protected static final String APPLICATION_XML_FILE = "application.xml";
    protected static final String SMALI_OUT_DIR = "/out/air/com/adobe/appentry/";
    protected static final String PACKAGE_TO_REPLACE = "air/com/adobe/appentry";
    protected static final String VERSION_CODE_TO_REPLACE = "__VERSION_CODE_TO_REPLACE__";
    protected static final String ARMEABI_V7A_MARKER = "lib/armeabi-v7a/libNativeABI.so";
    protected static final String NATIVE_LIBS_FOLDER = "lib/armeabi/";
    protected static final String NATIVE_LIBS_DEVICE_FOLDER = "lib/armeabi-v7a/";
    protected static final String RUNTIME_APK_PATH = "air/android/device/Runtime.apk";
    protected static final String MIN_SDK_VERSION = "android:minSdkVersion";
    protected static final String TARGET_SDK_VERSION = "android:targetSdkVersion";
    protected static final String PRELOAD_PROFILE_SWF = "prof/profileragent.swf";
    protected static final String PRELOAD_PROFILE_SWF_NAME = "profileragent.swf";
    private final int MAX_ASSET_FILE_NAME = 100;
    protected static final int ANDROID_LOW_DENSITY_ICON_SIZE = 36;
    protected static final int ANDROID_MEDIUM_DENSITY_ICON_SIZE = 48;
    protected static final int ANDROID_HIGH_DENSITY_ICON_SIZE = 72;
    protected File OsTempDir = new File(System.getProperty("java.io.tmpdir"));
    private Map<String, File> _sources;
    private HashMap<String, Set<String>> mExcludedAttributeList = null;
    private Set<String> mRestrictedNodeNames = null;
    private HashMap<String, Set<String>> mOverrideableAttributeList = null;
    private static String m_configType = "apk";
    private String m_debugHost;
    private int m_debugPort = -1;
    private static String m_preloadSWFPath = null;
    private AndroidDeviceSDK m_androidSDK;
    private File[] m_extensionsJars;
    private File[] m_extensionsLibs;
    private List<File> m_extraResources;
    private List<File> m_extraLibs;
    private Set<String> m_extraResourceDirectoriesSet;
    private List<String> m_extraResourceDirectories;
    private File m_tmpJarsDir;
    private File m_resourceApk;
    private File m_resourceJar;
    static Set<String> s_androidSupportedTags;
    private DescriptorValidationException mFailureException = null;
    private String mDescriptorFileName = null;
    private Listener mLocalListener = null;
    private int index = 0;
    private String m_airDownloadURL = null;
    private DebuggingModes.DebugMode mDebugMode = DebuggingModes.DebugMode.None;

    @Override
    public void close() throws IOException {
        if (this.m_tmpJarsDir != null) {
            this.m_tmpJarsDir.delete();
        }
        super.close();
    }

    public void setAndroidDeviceSDK(AndroidDeviceSDK sdk) throws InvalidInputException {
        if (sdk == null) {
            throw new InvalidInputException("sdk must be non-null");
        }
        this.m_androidSDK = sdk;
    }

    private AndroidDeviceSDK getAndroidSDKDirectory() {
        try {
            if (this.m_androidSDK == null) {
                this.m_androidSDK = new AndroidDeviceSDK(null);
            }
        }
        catch (Exception ex) {
            this.m_androidSDK = null;
        }
        return this.m_androidSDK;
    }

    protected void setConfigType(String config) {
        m_configType = config;
    }

    protected String getConfigType() {
        return m_configType;
    }

    protected void setForOutgoingDebuggingConnection(String debugHost, int debugPort) throws IOException {
        this.m_debugHost = debugHost;
        this.m_debugPort = debugPort;
        if (this.mDebugMode == DebuggingModes.DebugMode.ListenMode || this.mDebugMode == DebuggingModes.DebugMode.ConflictMode) {
            this.mDebugMode = DebuggingModes.DebugMode.ConflictMode;
            throw new IOException("setForIncomingDebuggerConnection and setForOutgoingDebuggingConnection are mutually exclusive.");
        }
        this.mDebugMode = DebuggingModes.DebugMode.ConnectMode;
    }

    protected void setPreloadSWFPath(String path) {
        m_preloadSWFPath = path;
    }

    protected void setForIncomingDebuggerConnection(int debuggerPort) throws IOException {
        this.m_debugPort = debuggerPort;
        if (this.mDebugMode == DebuggingModes.DebugMode.ConnectMode || this.mDebugMode == DebuggingModes.DebugMode.ConflictMode) {
            this.mDebugMode = DebuggingModes.DebugMode.ConflictMode;
            throw new IOException("setForIncomingDebuggerConnection and setForOutgoingDebuggingConnection are mutually exclusive.");
        }
        this.mDebugMode = DebuggingModes.DebugMode.ListenMode;
    }

    public void setAIRDownloadURL(String airDownloadURL) {
        this.m_airDownloadURL = airDownloadURL;
    }

    @Override
    protected CodeSigner getCodeSigner() {
        return new APKSigner();
    }

    public static String getPackageName(String appID) {
        String packageName = appID;
        packageName = PACKAGE_NAME_PRE + packageName;
        packageName = packageName.replace('-', '_');
        if ((packageName = packageName.replaceAll("\\.\\.*", ".")).endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        packageName = packageName.replaceAll("\\.([0-9_])", "\\.A$1");
        return packageName;
    }

    @Override
    public void addApplicationDescriptor(ApplicationDescriptor descriptor, boolean sign) throws IOException {
        super.addApplicationDescriptor(descriptor, sign);
        if (this._sources == null) {
            this.getApplicationDescriptor().validate(this.m_validationParams);
        }
        if (this._sources != null) {
            this.addIconFolder();
        }
        this.mDescriptorFileName = descriptor.getDescriptorFileName();
        if (this.mLocalListener == null) {
            this.mLocalListener = new Listener(){

                public void message(Message message) {
                    if (APKOutputStream.this.mFailureException == null) {
                        APKOutputStream.this.mFailureException = new DescriptorValidationException(message);
                    } else {
                        APKOutputStream.this.mFailureException.appendErrorMessage(message);
                    }
                }

                public void progress(int soFar, int total) {
                }
            };
        }
        String packageName = APKOutputStream.getPackageName(descriptor.id());
        String[] version = descriptor.versionNumber().split("\\.");
        int versionNumber = 0;
        int multiplier = 1000000;
        for (int i2 = 0; i2 < version.length; ++i2) {
            versionNumber += Integer.parseInt(version[i2]) * multiplier;
            multiplier /= 1000;
        }
        this.generateResourcesAndManifest(packageName, descriptor, versionNumber);
        this.generateClassesDex(packageName);
        this.addResourcesAndManifest();
        this.addARMEABIv7AMarker();
        StringBuilder buf = new StringBuilder();
        switch (this.mDebugMode) {
            case ListenMode: {
                buf.append("incomingDebugPort=").append(this.m_debugPort).append("\n");
                break;
            }
            case ConnectMode: {
                buf.append("outgoingDebugHost=").append(this.m_debugHost).append("\n");
                buf.append("outgoingDebugPort=").append(this.m_debugPort).append("\n");
                break;
            }
            case ConflictMode: {
                throw new InvalidInputException(" -connect and -listen options cannot be used together.");
            }
        }
        if (descriptor.useAndroid32bitColorDepth()) {
            this.addFileFromStream(RGBA8888, new ByteArrayInputStream(new byte[0]), DEFAULT_FILE_PERMISSONS, true, RES_RAW_FOLDER);
        }
        this.writeDebuggerValuesToPackage(buf);
        this.addPreloadSWFPath();
        this.addCaptiveRuntimeLibs();
    }

    private void addPreloadSWFPath() throws IOException {
        if (!m_configType.equals("apk-profile")) {
            return;
        }
        if (m_preloadSWFPath == null) {
            this.addFileFromStream(PRELOAD_PROFILE_SWF_NAME, this.getClass().getResourceAsStream(PRELOAD_PROFILE_SWF), DEFAULT_FILE_PERMISSONS, true, RES_RAW_FOLDER);
        } else {
            File swfDir = new File(m_preloadSWFPath);
            if (!swfDir.isDirectory()) {
                throw new InvalidInputException(" Preload SWF path is not a valid directory ");
            }
            File swfFilePath = new File(swfDir.getAbsolutePath() + File.separator + PRELOAD_PROFILE_SWF_NAME);
            if (!swfFilePath.exists()) {
                throw new InvalidInputException(" Preload SWF does not exist in the path. ");
            }
            this.addFileFromStream(PRELOAD_PROFILE_SWF_NAME, new FileInputStream(swfFilePath), DEFAULT_FILE_PERMISSONS, true, RES_RAW_FOLDER);
        }
    }

    public void setSources(Map<String, File> sources) {
        this._sources = sources;
    }

    @Override
    protected void addAIRFile(ZipFile inputFile, String expectedMimetype, String targetPlatform, Set<String> exclusionList) throws InvalidInputException, SDKDamagedException {
        HashMap<String, String> nativeLibs = new HashMap<String, String>();
        try {
            Pattern extensionDescriptorPattern = Pattern.compile("META-INF/AIR/extensions/([^/]+)/META-INF/ANE/extension.xml");
            Enumeration<? extends ZipEntry> entries = inputFile.entries();
            while (entries.hasMoreElements()) {
                ExtensionDescriptor ed;
                String nativeLibrary;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                Matcher em = extensionDescriptorPattern.matcher(name);
                if (!em.matches() || (nativeLibrary = (ed = new ExtensionDescriptor(inputFile.getInputStream(entry), true, entry.getName())).getNativeLibrary("Android-ARM")) == null) continue;
                String extensionId = em.group(1);
                nativeLibs.put(extensionId, "META-INF/AIR/extensions/" + extensionId + "/" + "META-INF/ANE" + "/" + "Android-ARM" + "/" + nativeLibrary);
            }
            this.m_tmpJarsDir = Utils.createTempDirectory();
            for (String extId : nativeLibs.keySet()) {
                String nativeLibPath = (String)nativeLibs.get(extId);
                InputStream inStream = inputFile.getInputStream(inputFile.getEntry(nativeLibPath));
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(this.m_tmpJarsDir + File.separator + extId + ".jar"));
                byte[] buf = new byte[1024];
                int n2 = 0;
                while ((n2 = inStream.read(buf, 0, 1024)) > -1) {
                    ((OutputStream)outStream).write(buf, 0, n2);
                }
                inStream.close();
                ((OutputStream)outStream).close();
            }
            this.m_extensionsJars = this.m_tmpJarsDir.listFiles();
        }
        catch (DescriptorValidationException e2) {
            throw new InvalidInputException("File " + inputFile.getName() + " has an invalid extension descriptor: " + e2.getMessage());
        }
        catch (IOException e3) {
            throw new InvalidInputException("File " + inputFile.getName() + " is malformed. " + e3.getMessage());
        }
        super.addAIRFile(inputFile, expectedMimetype, targetPlatform, new HashSet<String>(nativeLibs.values()));
        if (this.m_applicationDescriptor != null && this.m_applicationDescriptor.appIcons().isEmpty()) {
            try {
                this.addIconFolder();
            }
            catch (IOException e4) {
                throw new InvalidInputException("Unable to add default icon");
            }
        }
    }

    public void addApplicationDescriptorFile(File desFile) throws IOException {
        FileInputStream in = new FileInputStream(desFile);
        this.addFileFromStream(APPLICATION_XML_FILE, in, DEFAULT_FILE_PERMISSONS, true, "assets/META-INF/AIR/");
    }

    private int getClosestIconSize(int size) {
        int closestSmallerSize = size;
        int closestLargerSize = size;
        if (this.getApplicationDescriptor().getIcon(size) == null) {
            HashMap iconSizes = (HashMap)this.getApplicationDescriptor().appIconsMap();
            closestLargerSize = 0;
            closestSmallerSize = 0;
            for (Map.Entry entry : iconSizes.entrySet()) {
                int iconSize = (Integer)entry.getKey();
                if (iconSize <= size) {
                    if (closestSmallerSize != 0 && iconSize - size <= closestSmallerSize - size || this.getApplicationDescriptor().getIcon(iconSize) == null) continue;
                    closestSmallerSize = iconSize;
                    continue;
                }
                if (closestLargerSize != 0 && iconSize - size >= closestLargerSize - size || this.getApplicationDescriptor().getIcon(iconSize) == null) continue;
                closestLargerSize = iconSize;
            }
        }
        return closestLargerSize != 0 ? closestLargerSize : closestSmallerSize;
    }

    private void addAndroidIcon(int size) throws IOException {
        String folder = null;
        switch (size) {
            case 36: {
                folder = RES_DRAWABLE_L_FOLDER;
                break;
            }
            case 48: {
                folder = RES_DRAWABLE_M_FOLDER;
                break;
            }
            case 72: {
                folder = RES_DRAWABLE_H_FOLDER;
            }
        }
        String iconPath = this.getApplicationDescriptor().getIcon(this.getClosestIconSize(size));
        if (iconPath != null) {
            File file = this._sources.get(iconPath);
            this.addFileFromStream(ICON_NAME, new FileInputStream(file), DEFAULT_FILE_PERMISSONS, true, folder);
        } else {
            this.addFileFromResource(ICON_NAME, true, folder);
        }
    }

    private void addMiscIcons() throws IOException {
        String ERROR_ICON_PATH = "miscIcons/mp_warning_32x32_n.png";
        String ERROR_ICON = "mp_warning_32x32_n.png";
        if (m_configType.equals("apk-debug")) {
            this.addFileFromStream("mp_warning_32x32_n.png", this.getClass().getResourceAsStream("miscIcons/mp_warning_32x32_n.png"), DEFAULT_FILE_PERMISSONS, true, RES_DRAWABLE_FOLDER);
        }
    }

    private void addIconFolder() throws IOException {
        this.addAndroidIcon(36);
        this.addAndroidIcon(48);
        this.addAndroidIcon(72);
    }

    public void addResourcesArsc() throws IOException {
        this.addFileFromResource(RESOURCES_ARSC, true, "");
    }

    private void failIfError() throws DescriptorValidationException {
        if (this.mFailureException != null) {
            throw this.mFailureException;
        }
    }

    private File createAndroidManifestXml(String packageName, ApplicationDescriptor descriptor, int appVersionCode, File tempDir) throws IOException {
        File tempAMF = new File(tempDir, ANDROID_MANIFEST_BIN);
        if (tempAMF != null) {
            this.editAndroidManifest(descriptor, tempAMF);
            this.failIfError();
            String appVersionName = descriptor.versionLabel();
            if (appVersionName.startsWith("@")) {
                appVersionName = "\\" + appVersionName;
            }
            String appSpecificAndroidManifest = AppManifestHandler.createAppSpecificManifestXml(tempAMF.getCanonicalPath(), packageName, appVersionCode, appVersionName, this.mLocalListener, this.mDescriptorFileName, this.hasCaptiveRuntime());
            this.failIfError();
            if (appSpecificAndroidManifest != null) {
                File source = new File(appSpecificAndroidManifest);
                tempAMF.delete();
                source.renameTo(tempAMF);
            } else {
                throw new IOException("Unable to create AndroidManifest ");
            }
        }
        return tempAMF;
    }

    private void replaceVersionCode(File smaliFile, String versionCode) throws IOException {
        char[] buffer = new char[(int)smaliFile.length()];
        FileReader inFile = new FileReader(smaliFile);
        inFile.read(buffer);
        inFile.close();
        String s2 = new String(buffer);
        s2 = s2.replace(VERSION_CODE_TO_REPLACE, versionCode);
        FileWriter outFile = new FileWriter(smaliFile);
        outFile.write(s2);
        outFile.close();
    }

    private File renameAppEntryPackage(String outputDexPath, String tmpFolderPath, String packageName) throws IOException {
        String[] argsDecompile = new String[]{outputDexPath, "-o", tmpFolderPath + "/out"};
        org.jf.baksmali.main.main((String[])argsDecompile);
        File inputDir = new File(tmpFolderPath + SMALI_OUT_DIR);
        File[] listOfFiles = inputDir.listFiles();
        for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
            File input = listOfFiles[i2];
            if (!input.isFile()) continue;
            File output = new File(input.getCanonicalPath() + ".temp");
            input.renameTo(output);
            ReplaceStringFile.replace(output.getCanonicalPath(), input.getCanonicalPath(), PACKAGE_TO_REPLACE, packageName);
            if (!input.getName().equals("GetVersionCode.smali")) continue;
            this.replaceVersionCode(input, this.m_applicationDescriptor.versionNumber());
        }
        File input = new File(tmpFolderPath + "/out");
        File target = new File(tmpFolderPath + "/out/classes.dex");
        String[] args = new String[]{input.getCanonicalPath(), "-o", target.getCanonicalPath()};
        main.main((String[])args);
        return target;
    }

    private String getAndroidSDKPlatformToolPath() throws IOException, ADTException {
        if (null == this.getAndroidSDKDirectory()) {
            throw new ADTException("Could not locate Android SDK platforms tools directory", 13);
        }
        File androidSDKPlatformToolPath = new File(this.m_androidSDK.getPlatformDirectoryForLatestAPI(), "tools");
        if (!androidSDKPlatformToolPath.exists() && !(androidSDKPlatformToolPath = new File(this.m_androidSDK.getSDKLocation(), "platform-tools")).exists()) {
            throw new ADTException("Could not locate Android SDK platforms tools directory", 13);
        }
        return androidSDKPlatformToolPath.getCanonicalPath();
    }

    private String getAndroidSDKPlatformDataPath() throws IOException {
        File androidSDKPlatformDataPath;
        if (null != this.getAndroidSDKDirectory() && (androidSDKPlatformDataPath = new File(this.m_androidSDK.getPlatformDirectoryForLatestAPI(), "data")).exists()) {
            return androidSDKPlatformDataPath.getCanonicalPath();
        }
        throw new IOException("Could not locate Android SDK platforms data directory");
    }

    private File getAapt() throws IOException {
        String name = "aapt" + (System.getProperty("os.name").indexOf("Windows") != -1 ? ".exe" : "");
        if (this.getAndroidSDKDirectory() != null) {
            return new File(this.getAndroidSDKPlatformToolPath(), name);
        }
        return new File(Utils.getSDKLibDir(), "android/bin/" + name);
    }

    private File editAppEntryResources(ApplicationDescriptor descriptor, File tempDir) throws IOException {
        File copiedAppEntryResources = this.copySupportedLanguagesResources(new File(Utils.getSDKLibDir(), "android/lib/resources/app_entry/res"), tempDir, "app_entry_res");
        String defaultAppName = descriptor.name();
        Map<String, String> localizedNames = descriptor.localizedNames();
        if (localizedNames.containsKey("en")) {
            defaultAppName = localizedNames.get("en");
        }
        int prefixLength = "values-".length();
        for (String langFolder : copiedAppEntryResources.list()) {
            String lang;
            if (!langFolder.startsWith("values")) continue;
            String appName = defaultAppName;
            String string = lang = langFolder.length() < prefixLength ? "en" : langFolder.substring(prefixLength, langFolder.length());
            if (lang.equals("zh-rCN")) {
                lang = "zh-CN";
            }
            if (lang.equals("zh-rTW")) {
                lang = "zh-TW";
            }
            if (descriptor.localizedNames().containsKey(lang)) {
                appName = descriptor.localizedNames().get(lang);
            }
            if (appName.startsWith("@")) {
                appName = "\\" + appName;
            }
            appName = appName.replaceAll("&", "&amp;");
            appName = appName.replaceAll("<", "&lt;");
            appName = appName.replaceAll(">", "&gt;");
            appName = appName.replaceAll("\"", "&quot;");
            appName = appName.replaceAll("'", "\\\\'");
            String APP_VERSION_TAG = "APP_VERSION";
            String APP_NAME_TAG = "APP_NAME";
            File stringsFile = new File(copiedAppEntryResources, langFolder + "/strings.xml");
            FileInputStream stringsIn = new FileInputStream(stringsFile);
            StringBuilder strings = new StringBuilder(new String(Utils.readIn(stringsIn), "UTF-8"));
            stringsIn.close();
            int startidx = strings.indexOf("APP_NAME");
            strings.replace(startidx, startidx + "APP_NAME".length(), appName);
            FileOutputStream stringsOut = new FileOutputStream(stringsFile);
            Utils.writeThrough(new ByteArrayInputStream(strings.toString().getBytes("UTF-8")), stringsOut);
            stringsOut.close();
        }
        return copiedAppEntryResources;
    }

    private File copySupportedLanguagesResources(File sourceFolder, File tempDir, String destFolderName) throws IOException {
        File destFolder = new File(tempDir, destFolderName);
        if (!sourceFolder.exists()) {
            throw new SDKDamagedException(sourceFolder.getPath());
        }
        destFolder.mkdirs();
        for (File sourceChild : sourceFolder.listFiles()) {
            String folderName = sourceChild.getName();
            if (folderName.startsWith("values")) {
                List<String> supportedLanguages;
                String lang;
                int prefixLength = "values-".length();
                String string = lang = folderName.length() < prefixLength ? "en" : folderName.substring(prefixLength, folderName.length());
                if (lang.equals("zh-rCN") || lang.equals("zh-rTW")) {
                    lang = "zh";
                }
                if ((supportedLanguages = this.getApplicationDescriptor().supportedLanguages()) == null) {
                    this.getApplicationDescriptor();
                    supportedLanguages = new ArrayList<String>(ApplicationDescriptor.ALL_SUPPORTED_LANGUAGES);
                }
                if (!supportedLanguages.contains(lang.toLowerCase()) && !lang.equals("en")) continue;
            }
            File destChild = new File(destFolder, sourceChild.getName());
            Utils.copyTo(sourceChild, destChild);
        }
        return destFolder;
    }

    private void generateResourcesAndManifest(String packageName, ApplicationDescriptor descriptor, int appVersionCode) throws IOException {
        String pathToApptTool = this.getAapt().getPath();
        if (!new File(pathToApptTool).exists()) {
            throw new SDKDamagedException(pathToApptTool);
        }
        File tempDir = Utils.createTempDirectory(this.OsTempDir);
        tempDir.deleteOnExit();
        File androidManifestXmlFile = this.createAndroidManifestXml(packageName, descriptor, appVersionCode, tempDir);
        if (!androidManifestXmlFile.exists()) {
            new IOException("Unable to create AndroidManifest.");
        }
        String destDirForRJavaFile = tempDir.getCanonicalPath();
        String destDirForRJavaClasses = tempDir.getCanonicalPath();
        File appEntryResources = this.editAppEntryResources(descriptor, tempDir);
        File captiveRuntimeResources = this.copySupportedLanguagesResources(new File(Utils.getSDKLibDir(), "android/lib/resources/captive_runtime/res"), tempDir, "captive_runtime_res");
        File androidResJar = new File(Utils.getSDKLibDir(), "android/lib/resources/android-res.jar");
        File apkFileToOutput = new File(tempDir, "resources.apk");
        if (this.hasCaptiveRuntime() && !captiveRuntimeResources.exists()) {
            throw new SDKDamagedException(captiveRuntimeResources.getPath());
        }
        if (!androidResJar.exists()) {
            throw new SDKDamagedException(androidResJar.getPath());
        }
        LinkedList<String> aaptCommand = new LinkedList<String>();
        aaptCommand.add(pathToApptTool);
        aaptCommand.add("package");
        aaptCommand.add("-z");
        aaptCommand.add("-u");
        aaptCommand.add("-J");
        aaptCommand.add(destDirForRJavaFile);
        aaptCommand.add("-M");
        aaptCommand.add(androidManifestXmlFile.getPath());
        aaptCommand.add("-S");
        aaptCommand.add(appEntryResources.getPath());
        boolean needsAutoAddOverlayArg = false;
        if (this.hasCaptiveRuntime()) {
            aaptCommand.add("-S");
            aaptCommand.add(captiveRuntimeResources.getPath());
            needsAutoAddOverlayArg = true;
        }
        if (this.m_extraResourceDirectories != null) {
            Iterator<String> i2 = this.m_extraResourceDirectories.iterator();
            while (i2.hasNext()) {
                aaptCommand.add("-S");
                aaptCommand.add(i2.next());
                needsAutoAddOverlayArg = true;
            }
        }
        if (needsAutoAddOverlayArg) {
            aaptCommand.add("--auto-add-overlay");
        }
        aaptCommand.add("-I");
        aaptCommand.add(androidResJar.getPath());
        aaptCommand.add("--min-sdk-version");
        aaptCommand.add("8");
        aaptCommand.add("--target-sdk-version");
        aaptCommand.add("14");
        aaptCommand.add("--version-code");
        aaptCommand.add(Integer.toString(appVersionCode));
        aaptCommand.add("--version-name");
        aaptCommand.add(descriptor.versionLabel());
        aaptCommand.add("-F");
        aaptCommand.add(apkFileToOutput.getPath());
        String aaptOutputString = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(aaptCommand);
            Process p2 = pb.start();
            ByteArrayOutputStream aaptOutput = new ByteArrayOutputStream();
            new Utils.OutputEater(p2.getErrorStream(), aaptOutput).start();
            new Utils.OutputEater(p2.getInputStream()).start();
            p2.waitFor();
            if (p2.exitValue() != 0) {
                aaptOutputString = new String(aaptOutput.toByteArray(), "UTF-8");
            }
        }
        catch (Exception e2) {
            throw new IOException("Unable to run aapt");
        }
        if (aaptOutputString != null) {
            throw new ADTException("aapt tool failed:" + aaptOutputString.toString(), 17);
        }
        File rJavaFile = new File(destDirForRJavaFile, "R.java");
        if (!rJavaFile.exists()) {
            throw new IOException("could not generate an R.java file.");
        }
        File resourceJarFile = ResourceBytecodeGenerator.generateFromRFile(rJavaFile, new File(destDirForRJavaClasses));
        if (!resourceJarFile.exists()) {
            throw new IOException("could not generate bytecode for R.java class.");
        }
        if (!apkFileToOutput.exists()) {
            throw new IOException("could not generate a resource apk.");
        }
        this.m_resourceJar = resourceJarFile;
        this.m_resourceApk = apkFileToOutput;
    }

    private void generateClassesDex(String packageName) throws IOException {
        int numberOfExtensions;
        int len;
        InputStream inClsJarStream;
        if (m_configType.equals("apk") || m_configType.equals("apk-emulator") || m_configType.equals("apk-captive-runtime")) {
            inClsJarStream = this.getClass().getResourceAsStream("Dex/AppEntry_release.jar");
        } else if (m_configType.equals("apk-debug") || m_configType.equals("apk-profile")) {
            inClsJarStream = this.getClass().getResourceAsStream("Dex/AppEntry_debug.jar");
        } else {
            throw new IOException("Unknown APK Config Type");
        }
        File tempDir = Utils.createTempDirectory(this.OsTempDir);
        tempDir.deleteOnExit();
        String inputJarPath = tempDir.getCanonicalPath() + "/inputJAR.jar";
        String outputDexPath = tempDir.getCanonicalPath() + "/outputDEX.dex";
        String flashRuntimeExtensionsJarPath = tempDir.getCanonicalPath() + "/FlashRuntimeExtensions.jar";
        File inputJar = new File(inputJarPath);
        FileOutputStream outTmpClsJarStream = new FileOutputStream(inputJar);
        byte[] buf = new byte[1024];
        while ((len = inClsJarStream.read(buf)) > 0) {
            ((OutputStream)outTmpClsJarStream).write(buf, 0, len);
        }
        ((OutputStream)outTmpClsJarStream).close();
        inClsJarStream.close();
        InputStream inFlashRuntimeJarStream = this.getClass().getResourceAsStream("Dex/FlashRuntimeExtensions.jar");
        File flashRuntimeExtensionsJar = new File(flashRuntimeExtensionsJarPath);
        FileOutputStream outTmpFlashRuntimeJarStream = new FileOutputStream(flashRuntimeExtensionsJar);
        while ((len = inFlashRuntimeJarStream.read(buf)) > 0) {
            ((OutputStream)outTmpFlashRuntimeJarStream).write(buf, 0, len);
        }
        ((OutputStream)outTmpFlashRuntimeJarStream).close();
        inFlashRuntimeJarStream.close();
        String dxJarPath = this.getAndroidSDKDirectory() != null ? this.getAndroidSDKPlatformToolPath() + File.separator + "lib" + File.separator + "dx.jar" : Utils.getSDKLibDir() + File.separator + "android" + File.separator + "bin" + File.separator + "dx.jar";
        if (!new File(dxJarPath).exists()) {
            throw new SDKDamagedException(dxJarPath);
        }
        LinkedList<String> dexCommand = new LinkedList<String>();
        dexCommand.add("java");
        for (String vmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!vmArg.startsWith("-Xms") && !vmArg.startsWith("-Xmx")) continue;
            dexCommand.add(vmArg);
        }
        dexCommand.add("-jar");
        dexCommand.add(dxJarPath);
        dexCommand.add("--dex");
        dexCommand.add("--output=" + outputDexPath);
        dexCommand.add(inputJarPath);
        if (this.m_resourceJar != null) {
            dexCommand.add(this.m_resourceJar.getCanonicalPath());
        }
        if (this.hasCaptiveRuntime()) {
            File runtimeClassesJar = new File(Utils.getSDKLibDir(), "android/lib/runtimeClasses.jar");
            if (!runtimeClassesJar.exists()) {
                throw new SDKDamagedException(runtimeClassesJar.getCanonicalPath());
            }
            dexCommand.add(runtimeClassesJar.getAbsolutePath());
        }
        int n2 = numberOfExtensions = this.m_extensionsJars == null ? 0 : this.m_extensionsJars.length;
        if (numberOfExtensions > 0) {
            dexCommand.add(flashRuntimeExtensionsJarPath);
            for (int j2 = 0; j2 < numberOfExtensions; ++j2) {
                dexCommand.add(this.m_extensionsJars[j2].getCanonicalPath());
            }
        }
        String dxOutputString = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(dexCommand);
            Map<String, String> env = pb.environment();
            Process p2 = pb.start();
            ByteArrayOutputStream dxOutput = new ByteArrayOutputStream();
            new Utils.OutputEater(p2.getErrorStream(), dxOutput).start();
            new Utils.OutputEater(p2.getInputStream()).start();
            p2.waitFor();
            if (p2.exitValue() != 0) {
                dxOutputString = new String(dxOutput.toByteArray(), "UTF-8");
            }
        }
        catch (Exception e2) {
            throw new IOException("Unable to run dx");
        }
        if (dxOutputString != null) {
            throw new ADTException("dx tool failed:" + dxOutputString.toString(), 17);
        }
        if (!new File(outputDexPath).exists()) {
            throw new IOException("failed to create: " + outputDexPath);
        }
        File target = this.renameAppEntryPackage(outputDexPath, tempDir.getCanonicalPath(), packageName);
        FileInputStream inClsDexStream = new FileInputStream(target);
        this.addFileFromStream(CLASSES_DEX_OUT, inClsDexStream, DEFAULT_FILE_PERMISSONS, true, "");
        ((InputStream)inClsDexStream).close();
        APKOutputStream.recursiveFileOrFolderDelete(tempDir);
    }

    public void writeDebuggerValuesToPackage(StringBuilder buf) throws IOException {
        try {
            ByteArrayInputStream pInfo = new ByteArrayInputStream(buf.toString().getBytes("UTF-8"));
            this.addFileFromStream(DEBUG_INFO, pInfo, DEFAULT_FILE_PERMISSONS, true, RES_RAW_FOLDER);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IOException("Unable to add information.");
        }
    }

    public void addARMEABIv7AMarker() throws IOException {
        if (m_configType.equals("apk")) {
            this.addFileFromResource(ARMEABI_V7A_MARKER, true, "");
        }
    }

    private void addCaptiveRuntimeLibs() throws SDKDamagedException {
        if (this.hasCaptiveRuntime()) {
            String apkVersionString;
            ZipFile runtimeAPKZip;
            try {
                File runtimeAPK = new File(Utils.getSDKRuntimesDir(), RUNTIME_APK_PATH);
                runtimeAPKZip = new ZipFile(runtimeAPK);
                apkVersionString = this.getRuntimeVersion(runtimeAPK);
            }
            catch (IOException e2) {
                throw new SDKDamagedException(RUNTIME_APK_PATH);
            }
            if (apkVersionString == null || Utils.compareVersionStrings(apkVersionString, "3") < 0) {
                throw new SDKDamagedException(RUNTIME_APK_PATH, true);
            }
            try {
                Enumeration<? extends ZipEntry> entries = runtimeAPKZip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String path = entry.getName();
                    boolean isNativeLib = path.startsWith(NATIVE_LIBS_DEVICE_FOLDER) && path.endsWith(".so");
                    if (!isNativeLib) continue;
                    InputStream in = runtimeAPKZip.getInputStream(entry);
                    this.addFileFromStream(path, in, DEFAULT_FILE_PERMISSONS, true, "");
                    in.close();
                }
                runtimeAPKZip.close();
            }
            catch (IOException e3) {
                throw new IllegalStateException("Unable to add captive runtime");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRuntimeVersion(File runtime) throws IOException {
        BufferedReader in = null;
        try {
            String line;
            Process aaptProcess = new ProcessBuilder(this.getAapt().getPath(), "l", "-a", runtime.getPath()).start();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            new Utils.OutputEater(aaptProcess.getInputStream(), output).start();
            new Utils.OutputEater(aaptProcess.getErrorStream()).start();
            aaptProcess.waitFor();
            in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.toByteArray())));
            Pattern printedVersion = Pattern.compile(".*android:versionName.*=\\\"(\\d*\\.\\d*\\.\\d*\\.\\d*)\\\".*");
            while ((line = in.readLine()) != null) {
                Matcher versionMatcher = printedVersion.matcher(line);
                if (!versionMatcher.matches()) continue;
                String string = versionMatcher.group(1);
                return string;
            }
            String string = null;
            return string;
        }
        catch (InterruptedException e2) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {}
        }
    }

    private void addFileFromResource(String filename, boolean addToSignature, String folderInPackage) throws IOException {
        this.addFileFromStream(filename, this.getClass().getResourceAsStream(filename), DEFAULT_FILE_PERMISSONS, addToSignature, folderInPackage);
    }

    protected void addFileFromStream(String filename, InputStream in, long permissions, boolean addToSignature, String folderInPackage) throws IOException {
        this.addFileFromStream(filename, in, in.available(), permissions, new Date().getTime(), addToSignature, folderInPackage);
    }

    protected void addFileFromStream(String filename, InputStream in, long size, long permissions, long time, boolean addToSignature, String folderInPackage) throws IOException {
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date(time));
        record.path = folderInPackage + filename;
        if (folderInPackage.equals(ASSETS_FOLDER)) {
            this.validateAssetsFileName(filename);
        }
        record.size = in.available();
        record.permissions = permissions != 0L ? permissions : DEFAULT_FILE_PERMISSONS;
        super.addFile(record, in, addToSignature, true);
    }

    @Override
    public void addFile(File file, String path, boolean addToSignature, long permissions) throws IOException {
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date(file.lastModified()));
        record.path = ASSETS_FOLDER + path;
        this.validateAssetsFileName(path);
        record.size = file.length();
        record.permissions = permissions;
        super.addFile(record, new FileInputStream(file), addToSignature, true);
    }

    private void validateAssetsFileName(String path) throws InvalidInputException {
        String[] a = path.split("/");
        int len = 0;
        for (int i2 = 0; i2 < a.length; ++i2) {
            len = a[i2].length();
            if (len > 100) {
                throw new InvalidInputException(" Asset file or directory name cannot be more than 100 bytes long. Error occurred for : " + a[i2]);
            }
            for (int j2 = 0; j2 < len; ++j2) {
                char ch = a[i2].charAt(j2);
                if ((ch & 0x80) == 0 && ch >= ' ' && ch < '\u007f') continue;
                throw new InvalidInputException(" Asset file or directory name contains invalid characters. Error occurred for : " + a[i2]);
            }
        }
    }

    public void addExtensionsNativeLibs() throws IOException {
        String destApkDirectory = m_configType.equals("apk") || this.hasCaptiveRuntime() ? NATIVE_LIBS_DEVICE_FOLDER : NATIVE_LIBS_FOLDER;
        boolean addToSignature = true;
        if (this.m_extensionsLibs != null) {
            for (File nativeLib : this.m_extensionsLibs) {
                this.addFileFromStream("lib" + nativeLib.getName(), new FileInputStream(nativeLib), DEFAULT_FILE_PERMISSONS, addToSignature, destApkDirectory);
            }
        }
        if (this.m_extraLibs != null) {
            int numberOfLibs = this.m_extraLibs.size();
            for (int k2 = 0; k2 < numberOfLibs; ++k2) {
                File nativeLib;
                nativeLib = this.m_extraLibs.get(k2);
                this.addFileFromStream(nativeLib.getName(), new FileInputStream(nativeLib), DEFAULT_FILE_PERMISSONS, addToSignature, destApkDirectory);
            }
        }
    }

    private void addResourcesAndManifest() throws IOException {
        if (this.m_resourceApk != null) {
            boolean addToSignature = true;
            ZipFile resourceApkZip = new ZipFile(this.m_resourceApk);
            Enumeration<? extends ZipEntry> entries = resourceApkZip.entries();
            while (entries.hasMoreElements()) {
                boolean isResourceFile;
                ZipEntry entry = entries.nextElement();
                String path = entry.getName();
                boolean isDebugInfo = path.equals("res/raw/debugger.info") || path.equals("res/raw/debuginfo");
                boolean isSpecialResource = path.equals("res/raw/rgba8888") || path.equals("res/raw/ss_cfg.png") || path.equals("res/raw/ss_sgn.png") || path.equals("res/raw/mms_cfg.png") || path.equals("res/drawable/icon.png") || path.equals("res/drawable-ldpi/icon.png") || path.equals("res/drawable-mdpi/icon.png") || path.equals("res/drawable-hdpi/icon.png");
                boolean bl2 = isResourceFile = path.startsWith(RES_FOLDER) || path.equals(RESOURCES_ARSC) || path.equals(ANDROID_MANIFEST_BIN);
                if (isDebugInfo || isSpecialResource || !isResourceFile) continue;
                InputStream in = resourceApkZip.getInputStream(entry);
                this.addFileFromStream(path, in, DEFAULT_FILE_PERMISSONS, addToSignature, "");
                in.close();
            }
            resourceApkZip.close();
        }
    }

    @Override
    protected void addFile(UCFOutputStream.FileRecord record, InputStream data, boolean addToSignature, boolean compress) throws IOException {
    }

    @Override
    public void addFileFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.checkPath(entry.getName());
        this.addFileFromStream(entry.getName(), data, entry.getSize(), permissions, entry.getTime(), true, ASSETS_FOLDER);
    }

    @Override
    public void addFileFromZipEntry(ZipEntry entry, ZipFile file, String path) throws IOException {
        this.addFileFromZipEntry(entry, file, path, DEFAULT_FILE_PERMISSONS);
    }

    @Override
    public void addFileFromZipEntry(ZipEntry entry, ZipFile file, String path, long permissions) throws IOException {
        this.checkPath(entry.getName());
        this.addFileFromStream(path, file.getInputStream(entry), entry.getSize(), permissions, entry.getTime(), true, ASSETS_FOLDER);
    }

    @Override
    public void addDescriptorFromZipEntry(ZipEntry entry, InputStream data) throws IOException {
        this.addApplicationDescriptor(new ApplicationDescriptor(data), true);
        data.reset();
        this.addFileFromStream(entry.getName(), data, DEFAULT_FILE_PERMISSONS, true, ASSETS_FOLDER);
    }

    @Override
    public void addIconFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        String entryName = entry.getName();
        if (!this.getApplicationDescriptor().appIcons().contains(entryName)) {
            return;
        }
        this.getApplicationDescriptor().validateIcon(data, entryName, false);
        Dimension iconDim = this.getApplicationDescriptor().getIconDimension(entryName);
        if (iconDim.width == this.getClosestIconSize(36)) {
            data.reset();
            this.addFileFromStream(ICON_NAME, data, DEFAULT_FILE_PERMISSONS, true, RES_DRAWABLE_L_FOLDER);
        }
        if (iconDim.width == this.getClosestIconSize(48)) {
            data.reset();
            this.addFileFromStream(ICON_NAME, data, DEFAULT_FILE_PERMISSONS, true, RES_DRAWABLE_M_FOLDER);
        }
        if (iconDim.width == this.getClosestIconSize(72)) {
            data.reset();
            this.addFileFromStream(ICON_NAME, data, DEFAULT_FILE_PERMISSONS, true, RES_DRAWABLE_H_FOLDER);
        }
    }

    @Override
    public void addInitialContentFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.getApplicationDescriptor().validateInitialContent(data, false);
        data.reset();
        this.addFileFromStream(entry.getName(), data, DEFAULT_FILE_PERMISSONS, true, ASSETS_FOLDER);
    }

    @Override
    public void addHashFile(String path) throws IOException {
    }

    @Override
    public void addMimeTypeFile(String mimeType, boolean addToSignature) throws IOException {
    }

    private short paddingSize(UCFOutputStream.FileRecord r2) {
        if (r2.size != r2.compressedSize) {
            return 0;
        }
        long lfhSize = 30 + r2.path.length();
        long dataOffset = r2.lfhOffset + lfhSize;
        return (short)((4 - (int)(dataOffset % 4L)) % 4);
    }

    @Override
    protected short getLFExtraFieldLength(UCFOutputStream.FileRecord r2) {
        return this.paddingSize(r2);
    }

    @Override
    protected void writeLFExtraField(UCFOutputStream.FileRecord r2) throws IOException {
        short padding = this.paddingSize(r2);
        for (short i2 = 0; i2 < padding; i2 = (short)(i2 + 1)) {
            this.os.writeByte(0);
        }
    }

    @Override
    public void finalizeSig() throws IOException, GeneralSecurityException {
        if (this.codeSigner != null) {
            byte[] manifest = ((APKSigner)this.codeSigner).getManifestFile();
            UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date());
            record.path = ((APKSigner)this.codeSigner).getManifestFilePath();
            record.size = manifest.length;
            record.permissions = DEFAULT_FILE_PERMISSONS;
            super.addFile(record, new ByteArrayInputStream(manifest), false, true);
            byte[] certsf = ((APKSigner)this.codeSigner).getSignedManifestFile();
            record = new UCFOutputStream.FileRecord(new Date());
            record.path = ((APKSigner)this.codeSigner).getSignedManifestFilePath();
            record.size = certsf.length;
            record.permissions = DEFAULT_FILE_PERMISSONS;
            super.addFile(record, new ByteArrayInputStream(certsf), false, true);
            byte[] certalgo = ((APKSigner)this.codeSigner).getSignatureBlockFile();
            record = new UCFOutputStream.FileRecord(new Date());
            record.path = ((APKSigner)this.codeSigner).getSignatureBlockFilePath();
            record.size = certalgo.length;
            record.permissions = DEFAULT_FILE_PERMISSONS;
            super.addFile(record, new ByteArrayInputStream(certalgo), false, true);
        }
    }

    public File createTempFileInTempFolder() throws IOException {
        File tempFile2;
        String dirName = UUID.randomUUID().toString();
        File tempFolder = new File(this.OsTempDir, dirName);
        tempFolder.mkdir();
        try {
            tempFile2 = File.createTempFile("apk", "tmp", tempFolder);
        }
        catch (IOException e2) {
            Object tempFile2 = null;
            throw new IOException(" Unable to create Temporary file in Temporary Folder");
        }
        return tempFile2;
    }

    public static void recursiveFileOrFolderDelete(File fileOrDir) {
        for (File innerFile : fileOrDir.listFiles()) {
            if (innerFile.isDirectory()) {
                APKOutputStream.recursiveFileOrFolderDelete(innerFile);
            }
            innerFile.delete();
        }
        fileOrDir.delete();
    }

    private boolean isManifestFirstNode(Document manifestInfoDoc) {
        NodeList manifestList = manifestInfoDoc.getElementsByTagName("manifest");
        Boolean isManifestFirstNode = false;
        if (manifestList.getLength() > 0 && manifestList.item(0).getParentNode().getNodeName().equals("dict")) {
            isManifestFirstNode = true;
        }
        if (isManifestFirstNode.booleanValue()) {
            Node prevNode = manifestList.item(0).getPreviousSibling();
            if (prevNode == null) {
                isManifestFirstNode = true;
            } else {
                while (prevNode != null) {
                    if (!prevNode.getNodeName().equals("#text")) {
                        isManifestFirstNode = false;
                        break;
                    }
                    prevNode = prevNode.getPreviousSibling();
                }
            }
        }
        return isManifestFirstNode;
    }

    private void editAndroidManifest(ApplicationDescriptor descriptor, File tempAMF) throws IOException {
        try {
            NodeList usesPermissionList;
            String namespaceVersion = descriptor.getNamespaceVersion();
            String manifestInfo = descriptor.androidManifestInfo();
            String aspectRatio = descriptor.aspectRatio();
            Boolean autoOrients = descriptor.autoOrients();
            Boolean fullScreen = descriptor.fullscreen();
            String initialContent = descriptor.initialContent();
            String uniqueAppVersionID = UUID.randomUUID().toString();
            InputStream inAndMan = this.getClass().getResourceAsStream(ANDROID_MANIFEST_PATH);
            String dataPath = null;
            try {
                dataPath = this.getAndroidSDKPlatformDataPath();
            }
            catch (Exception ex) {
                dataPath = null;
            }
            if (manifestInfo == null && aspectRatio == null && autoOrients == null && fullScreen == null && uniqueAppVersionID == null && initialContent == null) {
                int len;
                System.out.println("Warning: Application has not specified its permission requirements in application.xml");
                FileOutputStream out = new FileOutputStream(tempAMF);
                byte[] buf = new byte[1024];
                while ((len = inAndMan.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                inAndMan.close();
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document androidManifestDoc = docBuilder.parse(inAndMan);
            if (namespaceVersion != null) {
                this.addMetaDataString(androidManifestDoc, "namespaceVersion", namespaceVersion);
            }
            if (manifestInfo != null) {
                this.mRestrictedNodeNames = new HashSet<String>();
                this.mRestrictedNodeNames.add("manifest");
                this.mRestrictedNodeNames.add("activity");
                this.mRestrictedNodeNames.add("application");
                this.mOverrideableAttributeList = new HashMap();
                this.mOverrideableAttributeList.put("application", new HashSet<String>(Arrays.asList("android:hardwareAccelerated")));
                this.mOverrideableAttributeList.put("application", new HashSet<String>(Arrays.asList("android:hardwareAccelerated")));
                this.mOverrideableAttributeList.put("activity", new HashSet<String>(Arrays.asList("android:launchMode")));
                this.PopulateExcludeAttributeList(androidManifestDoc);
                String manifestInfoList = "<list><dict>" + manifestInfo + "</dict></list>";
                Document manifestInfoDoc = docBuilder.parse(new InputSource(new StringReader(manifestInfoList)));
                if (this.isManifestFirstNode(manifestInfoDoc)) {
                    this.addNodes(androidManifestDoc, manifestInfoDoc, "manifest");
                } else {
                    this.mLocalListener.message(new Message(405, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{"manifest"}));
                }
            }
            if (this.m_airDownloadURL != null) {
                this.addMetaDataString(androidManifestDoc, "airDownloadURL", this.m_airDownloadURL);
            }
            if (aspectRatio != null) {
                this.addMetaDataString(androidManifestDoc, "aspectRatio", aspectRatio);
            }
            if (autoOrients != null) {
                this.addMetaDataBoolean(androidManifestDoc, "autoOrients", autoOrients);
            }
            if (fullScreen != null) {
                this.addMetaDataBoolean(androidManifestDoc, "fullScreen", fullScreen);
            }
            if (uniqueAppVersionID != null) {
                this.addMetaDataString(androidManifestDoc, "uniqueappversionid", uniqueAppVersionID);
            }
            if (initialContent != null) {
                this.addMetaDataString(androidManifestDoc, "initialcontent", initialContent);
            }
            if ((usesPermissionList = androidManifestDoc.getElementsByTagName("uses-permission")).getLength() == 0) {
                System.out.println("Warning: Application has not specified its permission requirements in application.xml");
            }
            this.writeAndroidManifest(androidManifestDoc, tempAMF);
            inAndMan.close();
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (SAXException e3) {
            this.mLocalListener.message(new Message(100, "ERROR", this.mDescriptorFileName, -1, -1, null));
        }
        catch (ParserConfigurationException e4) {
            this.mLocalListener.message(new Message(100, "ERROR", this.mDescriptorFileName, -1, -1, null));
        }
    }

    private void PopulateExcludeAttributeList(Document androidManifestDoc) {
        this.mExcludedAttributeList = new HashMap();
        NodeList lst = androidManifestDoc.getChildNodes();
        for (int i2 = 0; i2 < lst.getLength(); ++i2) {
            Node node = lst.item(i2);
            if (node.getNodeType() != 1) continue;
            this.PopulateExcludeAttributeListHelper(node);
        }
    }

    private void PopulateExcludeAttributeListHelper(Node root) {
        String nodeName = root.getNodeName();
        if (this.mRestrictedNodeNames.contains(nodeName)) {
            NamedNodeMap nodeAttrList = root.getAttributes();
            Set<String> overrideableList = this.mOverrideableAttributeList.get(nodeName);
            for (int i2 = 0; i2 < nodeAttrList.getLength(); ++i2) {
                Set<Object> attrLst;
                String attrName = nodeAttrList.item(i2).getNodeName();
                if (overrideableList != null && overrideableList.contains(attrName)) continue;
                if (!this.mExcludedAttributeList.containsKey(nodeName)) {
                    attrLst = new HashSet<String>();
                    attrLst.add(attrName);
                    this.mExcludedAttributeList.put(nodeName, attrLst);
                    continue;
                }
                attrLst = this.mExcludedAttributeList.get(nodeName);
                attrLst.add(attrName);
            }
        }
        NodeList lst = root.getChildNodes();
        for (int i3 = 0; i3 < lst.getLength(); ++i3) {
            Node node = lst.item(i3);
            if (node.getNodeType() != 1) continue;
            this.PopulateExcludeAttributeListHelper(node);
        }
    }

    private void addAttributes(Document androidManifestDoc, Document appDescriptorDoc, String tag) {
        NodeList androidManifestList = androidManifestDoc.getElementsByTagName(tag);
        Node androidmanifest = androidManifestList.item(0);
        Element e2 = (Element)androidmanifest;
        Node root = tag.equals("activity") ? appDescriptorDoc.getElementsByTagName(tag).item(this.index) : appDescriptorDoc.getElementsByTagName(tag).item(0);
        NamedNodeMap nodeAttrList = root.getAttributes();
        for (int i2 = 0; i2 < nodeAttrList.getLength(); ++i2) {
            Node node = nodeAttrList.item(i2);
            String attrName = node.getNodeName();
            if (!(attrName.startsWith("android:") || tag.equals("manifest") && attrName.equals("package"))) {
                this.mLocalListener.message(new Message(400, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{attrName}));
            }
            if (this.IsAttributeInExcludeList(attrName, tag)) continue;
            String attrValue = node.getNodeValue();
            if (tag.equals("uses-sdk")) {
                for (String sdkVersionTag : new String[]{MIN_SDK_VERSION, TARGET_SDK_VERSION}) {
                    if (!attrName.equals(sdkVersionTag) || Integer.parseInt(attrValue) >= 8) continue;
                    this.mLocalListener.message(new Message(406, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{sdkVersionTag, "uses-sdk", attrValue}));
                }
            }
            if (e2.hasAttribute(attrName)) {
                e2.removeAttribute(attrName);
            }
            e2.setAttribute(attrName, attrValue);
        }
    }

    private boolean IsAndroidSupportedTag(String tagName) {
        if (s_androidSupportedTags == null) {
            s_androidSupportedTags = new HashSet<String>();
            s_androidSupportedTags.add("manifest");
            s_androidSupportedTags.add("application");
            s_androidSupportedTags.add("permission");
            s_androidSupportedTags.add("permissiongroup");
            s_androidSupportedTags.add("permissiontree");
            s_androidSupportedTags.add("usespermission");
            s_androidSupportedTags.add("usesconfiguration");
            s_androidSupportedTags.add("usesfeature");
            s_androidSupportedTags.add("usessdk");
            s_androidSupportedTags.add("useslibrary");
            s_androidSupportedTags.add("supportsscreens");
            s_androidSupportedTags.add("protectedbroadcast");
            s_androidSupportedTags.add("provider");
            s_androidSupportedTags.add("granturipermission");
            s_androidSupportedTags.add("pathpermission");
            s_androidSupportedTags.add("service");
            s_androidSupportedTags.add("receiver");
            s_androidSupportedTags.add("activity");
            s_androidSupportedTags.add("activityalias");
            s_androidSupportedTags.add("metadata");
            s_androidSupportedTags.add("intentfilter");
            s_androidSupportedTags.add("action");
            s_androidSupportedTags.add("data");
            s_androidSupportedTags.add("category");
            s_androidSupportedTags.add("instrumentation");
            s_androidSupportedTags.add("compatiblescreens");
            s_androidSupportedTags.add("screen");
        }
        String dashlessTagName = tagName.replace("-", "");
        return s_androidSupportedTags.contains(dashlessTagName);
    }

    private boolean IsAttributeInExcludeList(String attribute, String tag) {
        boolean isExcluded;
        boolean bl2 = isExcluded = this.mExcludedAttributeList.containsKey(tag) && this.mExcludedAttributeList.get(tag).contains(attribute);
        if (isExcluded) {
            this.mLocalListener.message(new Message(404, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{attribute}));
        }
        return isExcluded;
    }

    private boolean isLauncherActivity(Element activity) {
        boolean isActionMain = false;
        boolean isCategoryLauncher = false;
        NodeList intentFilterList = activity.getElementsByTagName("intent-filter");
        for (int i2 = 0; i2 < intentFilterList.getLength(); ++i2) {
            int j2;
            isActionMain = false;
            isCategoryLauncher = false;
            Element intentFilter = (Element)intentFilterList.item(i2);
            NodeList actionList = intentFilter.getElementsByTagName("action");
            NodeList categoryList = intentFilter.getElementsByTagName("category");
            for (j2 = 0; j2 < actionList.getLength(); ++j2) {
                Element action = (Element)actionList.item(j2);
                if (!action.getAttribute("android:name").equals("android.intent.action.MAIN")) continue;
                isActionMain = true;
                break;
            }
            for (j2 = 0; j2 < categoryList.getLength(); ++j2) {
                Element category = (Element)categoryList.item(j2);
                if (!category.getAttribute("android:name").equals("android.intent.category.LAUNCHER")) continue;
                isCategoryLauncher = true;
                break;
            }
            if (isActionMain && isCategoryLauncher) break;
        }
        return isActionMain && isCategoryLauncher;
    }

    private void addNodes(Document androidManifestDoc, Document appDescriptorDoc, String tag) {
        Node root;
        NodeList androidManifestList = androidManifestDoc.getElementsByTagName(tag);
        Node androidmanifest = androidManifestList.item(0);
        if (tag.equals("activity")) {
            root = appDescriptorDoc.getElementsByTagName(tag).item(this.index);
            Node intentFilter = ((Element)androidmanifest).getElementsByTagName("intent-filter").item(0);
            androidmanifest.removeChild(intentFilter);
        } else {
            root = appDescriptorDoc.getElementsByTagName(tag).item(0);
        }
        NodeList nodeList = root.getChildNodes();
        this.addAttributes(androidManifestDoc, appDescriptorDoc, tag);
        boolean firstLauncherActivity = false;
        boolean firstApplication = false;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (tag.equals("manifest") && node.getNodeName().equals("application") && !firstApplication) {
                firstApplication = true;
                this.addNodes(androidManifestDoc, appDescriptorDoc, "application");
                continue;
            }
            if (tag.equals("application") && node.getNodeName().equals("activity") && !firstLauncherActivity) {
                if (this.isLauncherActivity((Element)node)) {
                    firstLauncherActivity = true;
                    this.addNodes(androidManifestDoc, appDescriptorDoc, "activity");
                    continue;
                }
                ++this.index;
            }
            if (tag.equals("manifest") && node.getNodeName().equals("uses-sdk")) {
                this.addAttributes(androidManifestDoc, appDescriptorDoc, "uses-sdk");
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (!this.IsAndroidSupportedTag(node.getNodeName())) {
                this.mLocalListener.message(new Message(402, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{node.getNodeName()}));
                continue;
            }
            androidmanifest.appendChild(androidManifestDoc.importNode(node, true));
        }
    }

    private void writeAndroidManifest(Document androidManifestDoc, File tempAMF) throws IOException {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(androidManifestDoc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            String xmlUTF8String = new String(xmlString.getBytes(), "UTF-8");
            byte[] buf = xmlUTF8String.getBytes();
            FileOutputStream out = new FileOutputStream(tempAMF);
            ((OutputStream)out).write(buf, 0, buf.length);
            ((OutputStream)out).close();
            buf = null;
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (TransformerConfigurationException e3) {
            this.mLocalListener.message(new Message(100, "ERROR", this.mDescriptorFileName, -1, -1, null));
        }
        catch (TransformerException e4) {
            this.mLocalListener.message(new Message(100, "ERROR", this.mDescriptorFileName, -1, -1, null));
        }
    }

    private void addMetaDataString(Document androidManifestDoc, String name, String value) {
        NodeList activityElem = androidManifestDoc.getElementsByTagName("activity");
        Element elem = androidManifestDoc.createElement("meta-data");
        elem.setAttribute("android:name", name);
        elem.setAttribute("android:value", value);
        activityElem.item(0).appendChild(elem);
    }

    private void addMetaDataBoolean(Document androidManifestDoc, String name, Boolean value) {
        NodeList activityElem = androidManifestDoc.getElementsByTagName("activity");
        Element elem = androidManifestDoc.createElement("meta-data");
        elem.setAttribute("android:name", name);
        if (value.booleanValue()) {
            elem.setAttribute("android:value", "true");
        } else {
            elem.setAttribute("android:value", "false");
        }
        activityElem.item(0).appendChild(elem);
    }

    public void setExtensionsJars(File[] extensions) {
        this.m_extensionsJars = extensions;
    }

    public void setExtensionsLibs(File[] extensions) {
        this.m_extensionsLibs = extensions;
    }

    public boolean hasCaptiveRuntime() {
        return m_configType.equals("apk-captive-runtime");
    }

    private void addExtraResourceDirectory(String extraResourceDirectory) {
        if (this.m_extraResourceDirectoriesSet == null) {
            this.m_extraResourceDirectoriesSet = new HashSet<String>();
            this.m_extraResourceDirectories = new LinkedList<String>();
        }
        if (!this.m_extraResourceDirectoriesSet.contains(extraResourceDirectory)) {
            this.m_extraResourceDirectories.add(extraResourceDirectory);
            this.m_extraResourceDirectoriesSet.add(extraResourceDirectory);
        }
    }

    public void addExtraResources(List<File> extraResources) throws IOException {
        for (File item : extraResources) {
            File itemDir;
            for (itemDir = item.getParentFile(); itemDir != null && !itemDir.getName().equals("res"); itemDir = itemDir.getParentFile()) {
            }
            if (itemDir == null) continue;
            this.addExtraResourceDirectory(itemDir.getCanonicalPath());
        }
        if (this.m_extraResources != null) {
            this.m_extraResources.addAll(extraResources);
        } else {
            this.m_extraResources = extraResources;
        }
    }

    public void addExtraLibs(List<File> extraLibs) {
        if (this.m_extraLibs != null) {
            this.m_extraLibs.addAll(extraLibs);
        } else {
            this.m_extraLibs = extraLibs;
        }
    }
}

