/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ios;

import com.adobe.air.ADTDeviceOperations;
import com.adobe.air.ADTException;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.ucf.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOSDeviceOperations
implements ADTDeviceOperations {
    private File m_idb = null;
    private String m_deviceID = null;

    private String getIDBDevice() throws IOException, InvalidInputException {
        List<String> devices = this.getIDBDevices();
        if (devices.size() == 0) {
            throw new ADTException("No Devices Detected", 15);
        }
        if (devices.size() > 1) {
            throw new InvalidInputException("Must specify -device parameter when more than one device is available");
        }
        return devices.get(0);
    }

    private List<String> getIDBDevices() throws IOException, InvalidInputException {
        String stdout;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.m_idb.getCanonicalPath());
        command.add("-devices");
        try {
            stdout = IOSDeviceOperations.execIDB(command);
        }
        catch (Exception e2) {
            throw new ADTException("Unable to enumerate devices", 13);
        }
        Pattern packagePatt = Pattern.compile("[\\s]+([0-9]+)[\\s]+[a-zA-Z]+[\\s]+[0-9a-fA-F]+[\\s]+[^\n]+$", 8);
        Matcher match = packagePatt.matcher(stdout);
        ArrayList<String> results = new ArrayList<String>();
        while (match.find()) {
            results.add(match.group(1));
        }
        return results;
    }

    void checkForDevice() throws IOException, InvalidInputException {
        if (this.m_deviceID == null || this.m_deviceID.length() == 0) {
            this.m_deviceID = this.getIDBDevice();
        } else {
            List<String> devices = this.getIDBDevices();
            if (!devices.contains(this.m_deviceID)) {
                throw new InvalidInputException("Invalid <device> specified");
            }
        }
    }

    @Override
    public void installApplication(File application) throws IOException, InvalidInputException {
        if (application == null) {
            throw new InvalidInputException("Missing <ipa-file> ");
        }
        if (!application.exists()) {
            throw new InvalidInputException("Cannot find <ipa-file> " + application.getPath());
        }
        this.checkForDevice();
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.m_idb.getCanonicalPath());
            command.add("-install");
            command.add(application.getAbsolutePath());
            command.add(this.m_deviceID);
            IOSDeviceOperations.execIDB(command, false);
        }
        catch (ADTException adtEx) {
            throw adtEx;
        }
        catch (Exception e2) {
            throw new ADTException("Failed to install " + application.getCanonicalPath(), 14);
        }
    }

    @Override
    public void installRuntime(File runtime) throws IOException, InvalidInputException, SDKDamagedException {
        throw new InvalidInputException("Runtime install/uninstall is not supported on ios devices");
    }

    @Override
    public void uninstallApplication(String appId) throws IOException, InvalidInputException {
        if (appId == null || appId.equals("")) {
            throw new InvalidInputException("<app-id> must be of non-zero length");
        }
        this.checkForDevice();
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.m_idb.getCanonicalPath());
            command.add("-uninstall");
            command.add(appId);
            command.add(this.m_deviceID);
            IOSDeviceOperations.execIDB(command, false);
        }
        catch (ADTException adtEx) {
            throw adtEx;
        }
        catch (Exception e2) {
            throw new ADTException("Failed to uninstall " + appId, 14);
        }
    }

    @Override
    public void uninstallRuntime() throws IOException, InvalidInputException {
        throw new InvalidInputException("Runtime install/uninstall not supported on ios device");
    }

    @Override
    public void launchApplication(String application) throws InvalidInputException, IOException {
        throw new InvalidInputException("Launching an application is not supported on ios device");
    }

    @Override
    public void launchApplication(String application, int debuggerPort) throws InvalidInputException, IOException {
        throw new InvalidInputException("Launching an application is not supported on ios device");
    }

    @Override
    public String getApplicationVersion(String application) throws InvalidInputException, IOException {
        throw new InvalidInputException("Getting the application version is not supported on ios device");
    }

    @Override
    public String getRuntimeVersion() throws InvalidInputException, IOException {
        throw new InvalidInputException("Getting the runtime version is not supported on ios device");
    }

    @Override
    public void listDevices() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.m_idb.getCanonicalPath());
        command.add("-devices");
        try {
            String stdout = IOSDeviceOperations.execIDB(command);
            System.out.println(stdout);
        }
        catch (ADTException adtEx) {
            throw adtEx;
        }
        catch (Exception e2) {
            throw new ADTException("Unable to enumerate devices", 13);
        }
    }

    public void setIDBtoolPath(String idbPath) throws IOException, InvalidInputException {
        if (idbPath == null) {
            throw new InvalidInputException("idb path must be non-null");
        }
        this.m_idb = new File(idbPath);
        if (!this.m_idb.exists()) {
            throw new InvalidInputException("Could not locate idb");
        }
    }

    public void setDeviceID(String deviceID) throws InvalidInputException {
        this.m_deviceID = deviceID;
    }

    private static String execIDB(List<String> command) throws InterruptedException, IOException, ADTException {
        return IOSDeviceOperations._execIDB(command, false);
    }

    private static String execIDB(List<String> command, boolean ignoreStdErr) throws InterruptedException, IOException, ADTException {
        return IOSDeviceOperations._execIDB(command, ignoreStdErr);
    }

    private static String _execIDB(List<String> command, boolean ignoreStdErr) throws InterruptedException, IOException, ADTException {
        Process idb = Utils.execSafely(null, command);
        ByteArrayOutputStream idbOutBytes = new ByteArrayOutputStream();
        ByteArrayOutputStream idbErrBytes = new ByteArrayOutputStream();
        new Utils.OutputEater(idb.getInputStream(), idbOutBytes).run();
        new Utils.OutputEater(idb.getErrorStream(), idbErrBytes).run();
        idb.waitFor();
        if (!ignoreStdErr && idbErrBytes.size() > 0) {
            throw new ADTException(idbErrBytes.toString(), 14);
        }
        return idbOutBytes.toString("UTF-8");
    }
}

