/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ADTOutputStream;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Message;
import com.adobe.air.Plist;
import com.adobe.air.SDK;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.AOTCompiler;
import com.adobe.air.ipa.AOTCompilerOptions;
import com.adobe.air.ipa.EntitlementsPlist;
import com.adobe.air.ipa.ExtensionData;
import com.adobe.air.ipa.IPAInfoPlist;
import com.adobe.air.ipa.IPAPackager;
import com.adobe.air.ipa.IPASigner;
import com.adobe.air.ipa.ResponseFileDatabase;
import com.adobe.air.mobile.DebuggingModes;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.argv.Arguments;
import com.adobe.argv.UsageError;
import com.adobe.png.PNGUtils;
import com.adobe.ucf.CodeSigner;
import com.adobe.ucf.UCF;
import com.adobe.ucf.UCFOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAOutputStream
extends ADTOutputStream {
    protected static final String CODE_RESOURCES_LINK = "CodeResources";
    protected static final String MAIN_WINDOW_NIB = "MainWindow.nib";
    protected static final String MAIN_WINDOW_IPAD_NIB = "MainWindow-iPad.nib";
    protected static final String RESOURCE_RULES_PLIST = "ResourceRules.plist";
    protected static final String EMBEDDED_PROVISIONING_PROFILE = "embedded.mobileprovision";
    protected static final String INFO_PLIST = "Info.plist";
    protected static final String SIGNATURES_PATH = "_CodeSignature/CodeResources";
    protected static final String IOS_SDK_FOLDER_NAME = "lib/aot";
    protected static final String APP_CONTENT_PATH = "appContent/";
    protected static final String SDK_SETTINGS_PLIST = "SDKSettings.plist";
    protected static final String VERSION = "Version";
    protected static final String VERSION_INFO = "Version-Info";
    public static final String ANY = "any";
    public static final String PORTRAIT = "portrait";
    public static final String LANDSCAPE = "landscape";
    public static final String ORIENTATION_PORTRAIT = "UIInterfaceOrientationPortrait";
    public static final String ORIENTATION_PORTRAIT_UPSIDE_DOWN = "UIInterfaceOrientationPortraitUpsideDown";
    public static final String ORIENTATION_LANDSCAPE_LEFT = "UIInterfaceOrientationLandscapeLeft";
    public static final String ORIENTATION_LANDSCAPE_RIGHT = "UIInterfaceOrientationLandscapeRight";
    public static final String DEVICE_FAMILY = "UIDeviceFamily";
    public static final String REQUIRED_DEVICE_CAPABILITIES = "UIRequiredDeviceCapabilities";
    public static final String ARMV7 = "armv7";
    public static final String OPENGLES2 = "opengles-2";
    private DebuggingModes.DebugMode mDebugMode = DebuggingModes.DebugMode.None;
    private String m_configType = "ipa-app-store";
    private File m_mobileProvisionProfile = null;
    private boolean m_compressSWF = false;
    private int m_verbose = 0;
    private boolean m_debug = false;
    private boolean m_debugRuntime = false;
    private boolean m_debugBuiltins = false;
    private boolean m_samplerEnabled = false;
    private boolean m_useInterpreter = false;
    private boolean m_dryRun = false;
    private boolean m_noStrip = false;
    private boolean m_enableSSC = false;
    private int m_moduleSplitLimit = 0;
    private int m_poolSize = 0;
    private boolean m_force32Bit = false;
    private boolean m_logPerf = false;
    private boolean m_hideAneSymbols = false;
    private String m_target = "arm-air";
    private String m_stackSize = "1500K";
    private File m_SDKLocation = null;
    private File m_platformSDKLocation = null;
    private int m_optimizeLevel = 0;
    private int m_inlineLevel = 0;
    private int m_timeoutSeconds = 0;
    private String m_remoteContentURI = null;
    private ArrayList<String> m_linkerOptions = new ArrayList();
    private ArrayList<File> m_extraABCs = new ArrayList();
    private Set<String> m_addedFolders = new HashSet<String>();
    private HashSet<String> filesInIpa = new HashSet();
    private File m_rootSwf = null;
    private File m_tempSwf = null;
    private String m_debugHost = null;
    private int m_debugPort = -1;
    private String m_extLibDir = null;
    private boolean m_linkAllFrameworks = false;
    private HashMap<String, ExtensionData> m_extensionsMap = new HashMap();
    private ArrayList<Pattern> m_resourceRuleOmitPatterns = new ArrayList();
    private boolean m_simulator = false;
    private String m_iosSdkVersion = null;

    public IPAOutputStream() {
        this.GetResourceRulesOmitPatterns();
    }

    private void GetResourceRulesOmitPatterns() {
        try {
            String RULES_KEY = "rules";
            String OMIT_KEY = "omit";
            InputStream inputStream = this.getClass().getResourceAsStream(RESOURCE_RULES_PLIST);
            String rulesStr = UCF.stringFromInputStream(inputStream);
            Plist rulesPlist = Plist.newFromString(rulesStr);
            Plist.DictionaryNode rootDict = rulesPlist.getRootDictionary();
            if (rootDict != null && rootDict.getNode("rules") instanceof Plist.DictionaryNode) {
                Plist.DictionaryNode rulesDict = (Plist.DictionaryNode)rootDict.getNode("rules");
                for (String patternStr : rulesDict.keySet()) {
                    Plist.BooleanNode omitNode;
                    if (!(rulesDict.getNode(patternStr) instanceof Plist.DictionaryNode) || !(((Plist.DictionaryNode)rulesDict.getNode(patternStr)).getNode("omit") instanceof Plist.BooleanNode) || !(omitNode = (Plist.BooleanNode)((Plist.DictionaryNode)rulesDict.getNode(patternStr)).getNode("omit")).equals(new Plist.BooleanNode(true))) continue;
                    this.m_resourceRuleOmitPatterns.add(Pattern.compile(".*" + patternStr + ".*"));
                }
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected CodeSigner getCodeSigner() {
        return new IPASigner();
    }

    private void addExtraLinkerArgsFromResponseFile() throws InvalidInputException {
        String[] responseFileArgs = ResponseFileDatabase.getArgumentsForAppId(this.getApplicationDescriptor().id());
        if (responseFileArgs != null) {
            ArrayList<String> extraLinkerOptions = new ArrayList<String>();
            Arguments args = new Arguments(responseFileArgs);
            try {
                while (args.peek()) {
                    if (args.acceptEquals("-Xlinker")) {
                        extraLinkerOptions.add(args.accept());
                        continue;
                    }
                    throw new UsageError("Unsupported option or argument in response file.");
                }
                for (String extraLinkerOption : extraLinkerOptions) {
                    this.addLinkerOption(extraLinkerOption);
                }
            }
            catch (UsageError e2) {
                throw new InvalidInputException(e2.getMessage());
            }
        }
    }

    @Override
    public void addApplicationDescriptor(ApplicationDescriptor descriptor, boolean sign) throws IOException {
        super.addApplicationDescriptor(descriptor, sign);
        this.addExtraLinkerArgsFromResponseFile();
        this.addInfoPlist();
        this.addResourceRulesPlist();
        this.addCodeResources();
        this.addMainWindowNib();
        this.addData(descriptor.getBytes(), "META-INF/AIR/application.xml", new Date(), sign, true);
        List<String> supportedLanguages = ((IPAPackager)this.m_packager).getSupportedLanguagesList(this.getApplicationDescriptor());
        for (String lang : this.getApplicationDescriptor().localizedNames().keySet()) {
            boolean includeName = false;
            ListIterator<String> it = supportedLanguages.listIterator();
            while (it.hasNext()) {
                if (!it.next().equalsIgnoreCase(lang)) continue;
                includeName = true;
                break;
            }
            if (!includeName) continue;
            String name = this.getApplicationDescriptor().localizedNames().get(lang);
            String entry = "CFBundleName = \"" + name + "\";" + "\nCFBundleDisplayName = \"" + name + "\";";
            this.addData(entry.getBytes("UTF-8"), lang + ".lproj/InfoPlist.strings", new Date(), true, true);
        }
        this.addLocalizationResources();
    }

    @Override
    public void addHashFile(String path) throws IOException {
    }

    @Override
    public void addMimeTypeFile(String mimeType, boolean addToSignature) throws IOException {
    }

    @Override
    public void addDescriptorFromZipEntry(ZipEntry entry, InputStream data) throws IOException {
        this.addApplicationDescriptor(new ApplicationDescriptor(data), true);
        if (this.m_validationParams == null) {
            this.setValidationParams(((IPAPackager)this.m_packager).getValidationParams(this.m_applicationDescriptor));
        }
        this.getApplicationDescriptor().validate(this.m_validationParams);
    }

    @Override
    public void addIconFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.getApplicationDescriptor().validateIcon(data, entry.getName(), false);
        data.reset();
        this.addSpecialIcon(data, entry.getName());
        data.reset();
        this.addFileFromZipEntry(entry, data, permissions);
    }

    @Override
    public void addInitialContentFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.getApplicationDescriptor().validateInitialContent(data, false);
        data.reset();
        this.m_rootSwf = this.m_tempSwf = File.createTempFile("swf", null, this.outputDir);
        Utils.writeOut(data, this.m_tempSwf);
    }

    @Override
    public void addFile(File file, String path, boolean addToSignature) throws IOException {
        if (path.equals(this.getApplicationDescriptor().initialContent()) && !this.m_useInterpreter) {
            this.m_rootSwf = file;
        } else {
            try {
                FileInputStream in = new FileInputStream(file);
                this.addSpecialIcon(in, path);
                ((InputStream)in).close();
                super.addFile(file, path, addToSignature);
            }
            catch (FileNotFoundException e2) {
                throw new InvalidInputException(e2.getMessage());
            }
        }
    }

    private void addSpecialIcon(InputStream in, String path) throws IOException {
        ApplicationDescriptor appDescriptor = this.getApplicationDescriptor();
        if (!this.m_configType.equals("ipa-app-store") && path.equals(appDescriptor.getIcon(512)) && !path.equals("iTunesArtwork")) {
            this.addFileFromStream("iTunesArtwork", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(72)) && !path.equals("Icon-Large.png")) {
            this.addFileFromStream("Icon-Large.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(57)) && !path.equals("Icon.png")) {
            this.addFileFromStream("Icon.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(114)) && !path.equals("Icon@2x.png")) {
            this.addFileFromStream("Icon@2x.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(48)) && !path.equals("Icon-Small-50.png")) {
            if (appDescriptor.getIcon(50) == null || appDescriptor.getIcon(50).length() == 0) {
                this.addFileFromStream("Icon-Small-50.png", in, DEFAULT_FILE_PERMISSONS, true);
            }
        } else if (path.equals(appDescriptor.getIcon(29)) && !path.equals("Icon-Small.png")) {
            this.addFileFromStream("Icon-Small.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(144)) && !path.equals("Icon@2x-Large.png")) {
            this.addFileFromStream("Icon@2x-Large.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(50)) && !path.equals("Icon-Small-50.png")) {
            this.addFileFromStream("Icon-Small-50.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(58)) && !path.equals("Icon-Small@2x.png")) {
            this.addFileFromStream("Icon-Small@2x.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(100)) && !path.equals("Icon-Small-50@2x.png")) {
            this.addFileFromStream("Icon-Small-50@2x.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (!this.m_configType.equals("ipa-app-store") && path.equals(appDescriptor.getIcon(1024)) && !path.equals("iTunesArtwork@2x")) {
            this.addFileFromStream("iTunesArtwork@2x", in, DEFAULT_FILE_PERMISSONS, true);
        }
    }

    private File createIosBinary(Boolean createShellApp) throws IOException {
        Set<String> profiles;
        ApplicationDescriptor appDescriptor = this.getApplicationDescriptor();
        if (this.m_optimizeLevel == 0 && (this.m_configType.equals("ipa-ad-hoc") || this.m_configType.equals("ipa-app-store"))) {
            this.m_optimizeLevel = 3;
        }
        String supportedProfile = "";
        if (!createShellApp.booleanValue() && (profiles = appDescriptor.supportedProfiles()).contains("mobileDeviceBase") && !profiles.contains("mobileDevice") && !profiles.contains("extendedMobileDevice")) {
            supportedProfile = "/base";
        }
        AOTCompilerOptions opt = new AOTCompilerOptions();
        opt.target = this.m_target;
        opt.namespaceURI = createShellApp != false ? null : this.getApplicationDescriptor().getNamespaceURI();
        opt.filename = createShellApp != false ? null : this.getApplicationDescriptor().filename();
        opt.airIosSdkRoot = this.getAirIosSDKDir().getAbsolutePath();
        opt.platformSdkRoot = this.m_platformSDKLocation != null ? this.m_platformSDKLocation.getAbsolutePath() : null;
        opt.outputPath = this.outputDir.getAbsolutePath();
        opt.optLevel = this.m_optimizeLevel;
        opt.inlineLevel = this.m_inlineLevel;
        opt.verbosity = this.m_verbose;
        opt.compressSWF = this.m_compressSWF;
        opt.noStrip = this.m_noStrip || this.m_configType.equals("ipa-debug");
        opt.enableSSC = this.m_enableSSC;
        opt.moduleSplitLimit = this.m_moduleSplitLimit;
        opt.poolSize = this.m_poolSize;
        opt.force32Bit = this.m_force32Bit;
        opt.dryRun = this.m_dryRun;
        opt.interpreter = this.m_useInterpreter;
        opt.linkerOptions = this.m_linkerOptions;
        opt.extLibDir = this.m_extLibDir;
        opt.extensionsMap = this.m_extensionsMap;
        opt.linkAllFrameworks = this.m_linkAllFrameworks;
        opt.timeoutSeconds = this.m_timeoutSeconds;
        opt.debugger = this.m_useInterpreter ? false : this.m_debug;
        opt.debugRuntime = this.m_useInterpreter ? false : this.m_debugRuntime;
        opt.debugBuiltins = this.m_useInterpreter ? false : this.m_debugBuiltins;
        opt.samplerEnabled = this.m_useInterpreter ? false : this.m_samplerEnabled;
        opt.shellAbcs = this.m_useInterpreter ? null : this.m_extraABCs;
        opt.stackSize = this.m_stackSize;
        opt.logPerf = this.m_logPerf;
        opt.hideAneSymbols = this.m_hideAneSymbols;
        opt.supportedProfile = supportedProfile;
        opt.rootSwf = this.m_rootSwf;
        AOTCompiler compiler = new AOTCompiler(opt);
        if (this.m_listener != null) {
            compiler.setListener(this.m_listener);
        }
        File executable = null;
        try {
            compiler.generateMachineBinaries();
            executable = compiler.getExecutable();
        }
        catch (InvalidInputException e2) {
            throw e2;
        }
        catch (SDKDamagedException e3) {
            throw e3;
        }
        catch (RuntimeException e4) {
            throw e4;
        }
        catch (Exception e5) {
            e5.printStackTrace();
            throw new IOException("Error:" + e5.getMessage());
        }
        return executable;
    }

    private File getAirIosSDKDir() throws IOException {
        if (this.m_SDKLocation == null) {
            this.m_SDKLocation = Utils.getSDKLibDir().getParentFile();
        }
        return new File(this.m_SDKLocation, IOS_SDK_FOLDER_NAME);
    }

    private String join(Collection<?> s2, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = s2.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    private String parsePlistVersion(String versionNumber) {
        List<Object> numbers = new ArrayList<Integer>();
        String[] versionArray = versionNumber.split("\\.");
        int versionArrayLength = versionArray.length;
        if (versionArrayLength > 0) {
            for (int i2 = 0; i2 < 3; ++i2) {
                if (i2 < versionArrayLength) {
                    numbers.add(new Integer(versionArray[i2]));
                    continue;
                }
                numbers.add(new Integer(0));
            }
        } else {
            numbers = Arrays.asList(1, 1, 1);
        }
        if (numbers.size() > 1 && (Integer)numbers.get(1) > 99) {
            numbers.set(1, 99);
        }
        if (numbers.size() > 2 && (Integer)numbers.get(2) > 99) {
            numbers.set(2, 99);
        }
        return this.join(numbers, ".");
    }

    private boolean containsInvalidDeviceFamilyValues(Plist.PlistNode deviceFamilyArray) {
        try {
            Plist.ArrayNode deviceFamilyArrayNode = (Plist.ArrayNode)deviceFamilyArray;
            int nodeCount = deviceFamilyArrayNode.nodeCount();
            Plist.StringNode deviceFamily_default = new Plist.StringNode("1");
            Plist.StringNode deviceFamily_iPad = new Plist.StringNode("2");
            for (int index = 0; index < nodeCount; ++index) {
                Plist.StringNode deviceFamilyNode = (Plist.StringNode)deviceFamilyArrayNode.getNode(index);
                if (deviceFamilyNode.equals(deviceFamily_default) || deviceFamilyNode.equals(deviceFamily_iPad)) continue;
                return true;
            }
        }
        catch (ClassCastException e2) {
            return true;
        }
        return false;
    }

    public void addInfoPlist() throws IOException, DescriptorValidationException {
        Set<String> extensions;
        ApplicationDescriptor appDescriptor = this.getApplicationDescriptor();
        IPAInfoPlist plist = IPAInfoPlist.newTemplate();
        Plist.DictionaryNode dict = plist.getRootDictionary();
        dict.putString("CFBundleVersion", this.parsePlistVersion(appDescriptor.versionNumber()));
        dict.putString("CFBundleShortVersionString", appDescriptor.versionNumber());
        dict.putString("CFBundleIdentifier", appDescriptor.id());
        dict.putString("CFBundleExecutable", appDescriptor.filename());
        if (appDescriptor.namespaceCompare("http://ns.adobe.com/air/application/3.1") == 0) {
            dict.putString("CFBundleName", appDescriptor.name());
            dict.putString("CFBundleDisplayName", appDescriptor.filename());
        } else {
            dict.putString("CFBundleName", appDescriptor.name());
            if (!appDescriptor.localizedNames().isEmpty()) {
                dict.putString("CFBundleDisplayName", appDescriptor.name());
            }
        }
        dict.putBoolean("UIStatusBarHidden", appDescriptor.fullscreen() == null ? false : appDescriptor.fullscreen());
        String initialAspectRatio = appDescriptor.aspectRatio();
        if (initialAspectRatio != null && !initialAspectRatio.equals(ANY)) {
            String orientation = appDescriptor.aspectRatio().equals(LANDSCAPE) ? ORIENTATION_LANDSCAPE_RIGHT : ORIENTATION_PORTRAIT;
            dict.putString("UIInterfaceOrientation", orientation);
        }
        if (appDescriptor.renderMode() != null) {
            dict.putString("renderMode", appDescriptor.renderMode());
        }
        if (appDescriptor.iosDisplayTagVal() != null) {
            dict.putString("CTRequestedDisplayResolution", appDescriptor.iosDisplayTagVal());
        }
        switch (this.mDebugMode) {
            case ListenMode: {
                dict.putString("incomingDebugPort", Integer.toString(this.m_debugPort));
                break;
            }
            case ConnectMode: {
                if (this.m_debugHost == null) break;
                dict.putString("DebugHost", this.m_debugHost);
                break;
            }
            case ConflictMode: {
                throw new InvalidInputException("-connect and -listen options cannot be used together.");
            }
        }
        dict.putBoolean("DebugMode", this.m_debug);
        if (appDescriptor.softKeyboardBehavior() != null) {
            dict.putString("CTSoftKeyboardBehavior", appDescriptor.softKeyboardBehavior());
        }
        dict.putString("CTNamespaceURI", appDescriptor.getNamespaceURI());
        dict.putBoolean("CTAutoOrients", appDescriptor.autoOrients() == null ? false : appDescriptor.autoOrients());
        dict.putString("CTInitialWindowTitle", appDescriptor.initialWindowTitle());
        if (this.m_remoteContentURI != null) {
            dict.putString("CTInitialWindowContent", this.m_remoteContentURI);
        } else if (this.m_useInterpreter) {
            dict.putString("CTInitialWindowContent", appDescriptor.filename() + ".app/" + appDescriptor.initialContent());
        }
        dict.putString("CTMaxSWFMajorVersion", String.valueOf(appDescriptor.maxSWFVersion()));
        Plist.ArrayNode supportedPlatformsArray = dict.putArray("CFBundleSupportedPlatforms");
        supportedPlatformsArray.addString("iPhoneOS");
        if (appDescriptor.iosInfoAdditions() != null) {
            dict.addDictionaryFragment(appDescriptor.iosInfoAdditions());
        }
        if (dict.getNode(DEVICE_FAMILY) == null) {
            Plist.ArrayNode deviceFamilyArray = dict.putArray(DEVICE_FAMILY);
            deviceFamilyArray.addNode(new Plist.StringNode("1"));
        } else if (this.containsInvalidDeviceFamilyValues(dict.getNode(DEVICE_FAMILY))) {
            throw new DescriptorValidationException(new Message(105, "ERROR", new String[]{DEVICE_FAMILY}));
        }
        Plist.PlistNode capabilitiesNode = dict.getNode(REQUIRED_DEVICE_CAPABILITIES);
        if (capabilitiesNode == null || !capabilitiesNode.isCollection()) {
            Plist.ArrayNode capabilitiesArray = dict.putArray(REQUIRED_DEVICE_CAPABILITIES);
            capabilitiesArray.addString(ARMV7);
            capabilitiesArray.addString(OPENGLES2);
        } else {
            capabilitiesNode.setSupport(ARMV7);
            capabilitiesNode.setSupport(OPENGLES2);
        }
        if (appDescriptor.getIcon(29) != null || appDescriptor.getIcon(48) != null || appDescriptor.getIcon(50) != null || appDescriptor.getIcon(57) != null || appDescriptor.getIcon(58) != null || appDescriptor.getIcon(72) != null || appDescriptor.getIcon(100) != null || appDescriptor.getIcon(114) != null || appDescriptor.getIcon(144) != null) {
            Plist.ArrayNode iconsArray = dict.putArray("CFBundleIconFiles");
            if (appDescriptor.getIcon(144) != null) {
                iconsArray.addString("Icon@2x-Large.png");
            }
            if (appDescriptor.getIcon(114) != null) {
                iconsArray.addString("Icon@2x.png");
            }
            if (appDescriptor.getIcon(100) != null) {
                iconsArray.addString("Icon-Small-50@2x.png");
            }
            if (appDescriptor.getIcon(72) != null) {
                iconsArray.addString("Icon-Large.png");
            }
            if (appDescriptor.getIcon(58) != null) {
                iconsArray.addString("Icon-Small@2x.png");
            }
            if (appDescriptor.getIcon(57) != null) {
                iconsArray.addString("Icon.png");
            }
            if (appDescriptor.getIcon(50) != null) {
                iconsArray.addString("Icon-Small-50.png");
            }
            if (appDescriptor.getIcon(48) != null) {
                iconsArray.addString("Icon-Small-50.png");
            }
            if (appDescriptor.getIcon(29) != null) {
                iconsArray.addString("Icon-Small.png");
            }
        }
        Plist.ArrayNode orientationsArray = dict.putArray("UISupportedInterfaceOrientations");
        if (initialAspectRatio == null || initialAspectRatio.equals(PORTRAIT) || initialAspectRatio.equals(ANY)) {
            orientationsArray.addString(ORIENTATION_PORTRAIT);
            orientationsArray.addString(ORIENTATION_PORTRAIT_UPSIDE_DOWN);
        }
        if (initialAspectRatio == null || initialAspectRatio.equals(LANDSCAPE) || initialAspectRatio.equals(ANY)) {
            orientationsArray.addString(ORIENTATION_LANDSCAPE_RIGHT);
            orientationsArray.addString(ORIENTATION_LANDSCAPE_LEFT);
        }
        if ((extensions = appDescriptor.getRequiredExtensions()) != null) {
            Plist.ArrayNode extensionsArray = dict.putArray("Extensions");
            for (String extensionid : extensions) {
                extensionsArray.addString(extensionid);
            }
        }
        if (this.m_iosSdkVersion == null) {
            this.m_iosSdkVersion = " ";
            File versionInfo = new File(this.getAirIosSDKDir(), VERSION_INFO);
            if (versionInfo.exists()) {
                Scanner sc = new Scanner(versionInfo);
                this.m_iosSdkVersion = sc.nextLine();
            }
        }
        dict.putString("CTIosSdkVersion", this.m_iosSdkVersion);
        dict.putString("CTAirSdkVersion", SDK.getVersion());
        dict.putBoolean("CTHideAneSymbols", this.m_hideAneSymbols);
        this.addData(plist.getXMLString().getBytes("UTF-8"), INFO_PLIST, new Date(), false, true);
    }

    public void addMainWindowNib() throws IOException, SDKDamagedException {
        File mainWindowNib = new File(this.getAirIosSDKDir(), "lib" + File.separator + MAIN_WINDOW_NIB);
        if (!mainWindowNib.exists()) {
            throw new SDKDamagedException(MAIN_WINDOW_NIB);
        }
        this.addFile(mainWindowNib, MAIN_WINDOW_NIB, true, DEFAULT_FILE_PERMISSONS);
        File mainWindowIPadNib = new File(this.getAirIosSDKDir(), "lib" + File.separator + MAIN_WINDOW_IPAD_NIB);
        if (!mainWindowIPadNib.exists()) {
            throw new SDKDamagedException(MAIN_WINDOW_IPAD_NIB);
        }
        this.addFile(mainWindowIPadNib, MAIN_WINDOW_IPAD_NIB, true, DEFAULT_FILE_PERMISSONS);
    }

    public void addResourceRulesPlist() throws IOException {
        this.addFileFromResource(RESOURCE_RULES_PLIST, false);
    }

    private void addFileFromResource(String name, boolean addToSignature) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            in = this.getClass().getResourceAsStream("/" + name);
        }
        this.addFileFromStream(name, in, DEFAULT_FILE_PERMISSONS, addToSignature);
    }

    public void addCodeResources() throws IOException {
        this.addFileFromStream(CODE_RESOURCES_LINK, new ByteArrayInputStream(SIGNATURES_PATH.getBytes()), SYMLINK_FILE_PERMISSIONS, false);
    }

    private void addLocalizationResources() throws IOException {
        List<String> supportedLanguages = ((IPAPackager)this.m_packager).getSupportedLanguagesList(this.getApplicationDescriptor());
        for (int index = 0; index < supportedLanguages.size(); ++index) {
            String localizationPath = supportedLanguages.get(index) + ".lproj/com.adobe.air.localizable.strings";
            this.addFileFromResource(localizationPath, true);
        }
    }

    @Override
    protected String getSignaturesPath() {
        return SIGNATURES_PATH;
    }

    @Override
    protected void addFile(UCFOutputStream.FileRecord record, InputStream data, boolean addToSignature, boolean compress) throws IOException, InvalidInputException {
        String[] iconPaths;
        String path = record.path;
        if (this.filesInIpa.contains(path)) {
            throw new InvalidInputException("Conflict in file name : " + path);
        }
        String[] pathParts = this.getZipPath(record).split("/");
        String currentFolder = "";
        for (int i2 = 0; i2 < pathParts.length - 1; ++i2) {
            if (this.m_addedFolders.contains(currentFolder = currentFolder + pathParts[i2] + "/")) continue;
            UCFOutputStream.FileRecord parentRecord = new UCFOutputStream.FileRecord(record);
            parentRecord.path = currentFolder;
            parentRecord.permissions = FOLDER_FILE_PERMISSIONS;
            parentRecord.absolute = true;
            super.addFile(parentRecord, new EmptyInputStream(), false, false);
            this.m_addedFolders.add(currentFolder);
        }
        if (record.path.equals("Icon-Small-50.png")) {
            data = PNGUtils.addTransparentBorder(data, 1);
        }
        if (Arrays.asList(iconPaths = new String[]{"Icon.png", "Icon@2x.png", "Icon-Small.png", "Icon-Small@2x.png", "Icon-Large.png", "Icon@2x-Large.png", "Icon-Small-50.png", "Icon-Small-50@2x.png", "Icon-Small@2x.png", "iTunesArtwork", "iTunesArtwork@2x"}).contains(record.path)) {
            data = PNGUtils.updatePNGMetadata(data, "Software", "Adobe AIR for iOS ", SDK.getVersion());
        }
        for (Pattern pattern : this.m_resourceRuleOmitPatterns) {
            if (!pattern.matcher(path).matches()) continue;
            addToSignature = false;
        }
        super.addFile(record, data, addToSignature, compress);
        this.filesInIpa.add(path);
    }

    @Override
    protected String getZipPath(UCFOutputStream.FileRecord record) {
        if (record.absolute) {
            return record.path;
        }
        return "Payload/" + this.getApplicationDescriptor().filename() + ".app/" + record.path;
    }

    @Override
    protected void processBytes(String path, byte[] bytes, int numBytes) {
        if (!this.m_simulator) {
            if (path.equals(INFO_PLIST)) {
                ((IPASigner)this.codeSigner).updateInfoPlistDigest(bytes, numBytes);
            } else if (path.equals(SIGNATURES_PATH)) {
                ((IPASigner)this.codeSigner).updateCodeResourcesDigest(bytes, numBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeSig() throws IOException, GeneralSecurityException, InvalidInputException {
        File executable = null;
        try {
            if (this.m_simulator) {
                executable = this.createIosBinary(false);
                this.addFile(executable, this.getApplicationDescriptor().filename(), false, EXECUTABLE_FILE_PERMISSIONS);
            } else {
                if (this.m_mobileProvisionProfile == null) {
                    throw new InvalidInputException("Mobile provisioning profile not specified.");
                }
                if (this.m_mobileProvisionProfile != null) {
                    this.addFile(this.m_mobileProvisionProfile, EMBEDDED_PROVISIONING_PROFILE, true);
                }
                EntitlementsPlist plist = this.createNewEntitlementPlist();
                ((IPASigner)this.codeSigner).setEntitlementsPlist(plist);
                ((IPASigner)this.codeSigner).setAppIdentifier(this.getApplicationDescriptor().id());
                super.finalizeSig();
                ((IPASigner)this.codeSigner).prepareToSign();
                executable = this.createIosBinary(false);
                ((IPASigner)this.codeSigner).setMachoFile(executable);
                ((IPASigner)this.codeSigner).signMacho();
                this.addFile(executable, this.getApplicationDescriptor().filename(), false, EXECUTABLE_FILE_PERMISSIONS);
            }
        }
        finally {
            if (executable != null) {
                executable.delete();
            }
        }
    }

    private EntitlementsPlist createNewEntitlementPlist() throws InvalidInputException {
        ApplicationDescriptor appDescriptor = this.getApplicationDescriptor();
        String applicationIdentifierPrefix = this.m_mobileProvisionProfile != null ? this.getAppIdentifierPrefix(this.m_mobileProvisionProfile) : new String("");
        EntitlementsPlist plist = EntitlementsPlist.newTemplate(applicationIdentifierPrefix, appDescriptor.id());
        Plist.DictionaryNode dict = plist.getRootDictionary();
        if (appDescriptor.iosEntitlements() != null) {
            try {
                dict.addDictionaryFragment(appDescriptor.iosEntitlements());
            }
            catch (IOException e2) {
                throw new InvalidInputException("Invalid entitlements fragment: " + e2.getMessage());
            }
        }
        return plist;
    }

    private String getAppIdentifierPrefix(File mobileProvisioningProfile) throws InvalidInputException {
        try {
            Scanner s2 = new Scanner(new BufferedReader(new FileReader(mobileProvisioningProfile)));
            while (s2.hasNext()) {
                if (!s2.next().equals("<key>ApplicationIdentifierPrefix</key>")) continue;
                if (s2.next().equals("<array>")) {
                    String[] prefix = s2.next().split("<|>");
                    s2.close();
                    return prefix[2];
                }
                throw new InvalidInputException("Malformed provisioning profile: unexpected token after ApplicationIdentifierPrefix.");
            }
            throw new InvalidInputException("Malformed provisioning profile: ApplicationIdentifierPrefix not found.");
        }
        catch (IOException ie) {
            throw new InvalidInputException("Unable to open mobile provisioning profile.");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_tempSwf != null) {
            this.m_tempSwf.delete();
        }
        super.close();
    }

    public void setOptimizeLevel(int optLevel) {
        this.m_optimizeLevel = optLevel;
    }

    public void setInlineLevel(int inlineLevel) {
        this.m_inlineLevel = inlineLevel;
    }

    @Override
    protected long determineFilePermissions(File file) {
        return DEFAULT_FILE_PERMISSONS;
    }

    public void setVerbose(int verbosity) {
        this.m_verbose = verbosity;
    }

    public int getVerbose() {
        return this.m_verbose;
    }

    public void setCompressSWF(boolean compressSWFFlag) {
        this.m_compressSWF = compressSWFFlag;
    }

    public boolean getCompressSWF() {
        return this.m_compressSWF;
    }

    public void setDebug(boolean debugFlag) {
        this.m_debug = debugFlag;
    }

    public void setNoStrip(boolean stripFlag) {
        this.m_noStrip = stripFlag;
    }

    public void setEnableSSC(boolean enableSSC) {
        this.m_enableSSC = enableSSC;
    }

    public void setModuleSplitLimit(int splitLimit) {
        this.m_moduleSplitLimit = splitLimit;
    }

    public void setPoolSize(int poolSize) {
        this.m_poolSize = poolSize;
    }

    public void setForce32Bit(boolean force32Bit) {
        this.m_force32Bit = force32Bit;
    }

    public void setStackSize(String stackSize) {
        this.m_stackSize = stackSize;
    }

    public void setLogAOTPerf(boolean logPerf) {
        this.m_logPerf = logPerf;
    }

    public void setHideAneSymbols(boolean hide) {
        this.m_hideAneSymbols = hide;
    }

    public void setDebugRuntime(boolean debugRuntimeFlag) {
        this.m_debugRuntime = debugRuntimeFlag;
    }

    public void setDebugBuiltins(boolean debugBuiltinsFlag) {
        this.m_debugBuiltins = debugBuiltinsFlag;
    }

    public void setSamplerEnabled(boolean samplerEnabledFlag) {
        this.m_samplerEnabled = samplerEnabledFlag;
    }

    public void setForOutgoingDebuggingConnection(String debugHost, int debugPort) throws IOException {
        this.m_debugHost = debugHost;
        if (this.mDebugMode == DebuggingModes.DebugMode.ListenMode || this.mDebugMode == DebuggingModes.DebugMode.ConflictMode) {
            this.mDebugMode = DebuggingModes.DebugMode.ConflictMode;
            throw new IOException("setForIncomingDebuggerConnection and setForOutgoingDebuggingConnection are mutually exclusive.");
        }
        this.mDebugMode = DebuggingModes.DebugMode.ConnectMode;
    }

    public void setForIncomingDebuggerConnection(int portToListenOn) throws IOException {
        this.m_debugPort = portToListenOn;
        if (this.mDebugMode == DebuggingModes.DebugMode.ConnectMode || this.mDebugMode == DebuggingModes.DebugMode.ConflictMode) {
            this.mDebugMode = DebuggingModes.DebugMode.ConflictMode;
            throw new IOException("setForIncomingDebuggerConnection and setForOutgoingDebuggingConnection are mutually exclusive.");
        }
        this.mDebugMode = DebuggingModes.DebugMode.ListenMode;
    }

    public void setUseInterpreter(boolean interpreterFlag) {
        this.m_useInterpreter = interpreterFlag;
    }

    public boolean getUseInterpreter() {
        return this.m_useInterpreter;
    }

    public void setMobileProvisioningProfile(File mobileProvisionProfile) {
        this.m_mobileProvisionProfile = mobileProvisionProfile;
    }

    public void setDryRun(boolean dryRun) {
        this.m_dryRun = dryRun;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public void setSDKLocation(File sdkDir) {
        this.m_SDKLocation = sdkDir;
    }

    public void setPlatformSDKLocation(File sdkDir) {
        this.m_platformSDKLocation = sdkDir;
        this.setSDKVersion(sdkDir);
    }

    public void setTimeout(int timeoutSeconds) {
        this.m_timeoutSeconds = timeoutSeconds;
    }

    public void addExtraABC(String abc) {
        this.m_extraABCs.add(new File(abc));
    }

    public void addLinkerOption(String linkoption) {
        this.m_linkerOptions.add(linkoption);
    }

    public void compileShellApp() throws IOException {
        this.createIosBinary(true);
    }

    public void setRemoteContentURI(String remoteContent) {
        this.m_remoteContentURI = remoteContent;
    }

    public void setPackageConfiguration(String configType) {
        assert (configType.equals("ipa-test") || configType.equals("ipa-debug") || configType.equals("ipa-app-store") || configType.equals("ipa-ad-hoc") || configType.equals("ipa-test-interpreter") || configType.equals("ipa-debug-interpreter") || configType.equals("ipa-test-interpreter-simulator") || configType.equals("ipa-debug-interpreter-simulator"));
        if (configType.equals("ipa-debug") || configType.equals("ipa-debug-interpreter") || configType.equals("ipa-debug-interpreter-simulator")) {
            this.m_debug = true;
        }
        if (configType.equals("ipa-test-interpreter-simulator") || configType.equals("ipa-debug-interpreter-simulator")) {
            this.m_simulator = true;
        }
        this.m_configType = configType;
    }

    public void addExtensionsLib(String extension) {
        if (extension != null) {
            assert (this.m_extensionsMap.get(extension) == null);
            ExtensionData extData = new ExtensionData();
            extData.id = extension;
            this.m_extensionsMap.put(extension, extData);
        }
    }

    public void addExtensionAbc(String extension, File abcFile) {
        ExtensionData extData = this.m_extensionsMap.get(extension);
        assert (extData != null);
        assert (extData.abcs != null);
        extData.abcs.add(abcFile);
    }

    public void addExtensionExportedSymbol(String extension, String symbol) {
        ExtensionData extData = this.m_extensionsMap.get(extension);
        assert (extData != null);
        assert (extData.exportedSymbols != null);
        extData.exportedSymbols.add(symbol);
    }

    public void addExtensionPlatformOptions(String extension, ArrayList<String> platformOptions) {
        ExtensionData extData = this.m_extensionsMap.get(extension);
        assert (extData != null);
        extData.platformOptions = platformOptions;
    }

    public void setExtLibDir(String directory) {
        if (directory != null) {
            this.m_extLibDir = directory;
        }
    }

    public void setLinkAllFrameworks(boolean value) {
        this.m_linkAllFrameworks = value;
    }

    public void setSDKVersion(File sdkDir) {
        try {
            Plist settingsPlist;
            Plist.DictionaryNode dict;
            String sdkPath = sdkDir.getAbsolutePath();
            File settingsPlistFile = new File(sdkPath + "/" + SDK_SETTINGS_PLIST);
            if (settingsPlistFile.exists() && (dict = (settingsPlist = Plist.newFromFile(settingsPlistFile)).getRootDictionary()).getNode(VERSION) instanceof Plist.StringNode) {
                Plist.StringNode version = (Plist.StringNode)dict.getNode(VERSION);
                this.m_iosSdkVersion = version.getValue();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

