/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ADTException;
import com.adobe.air.ANEFile;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.IPAOutputStream;
import com.adobe.air.ipa.IosExtensionDescriptor;
import com.adobe.air.ipa.SWFUtils;
import com.adobe.air.validator.DescriptorValidationException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IPAPackager
extends ApplicationPackager {
    public static final ApplicationDescriptor.ValidationParams IPA_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/2.0", "http://ns.adobe.com/air/application/3.0", new String[]{"mobileDevice", "mobileDeviceBase"}, false, true);

    public IPAPackager() {
        super("AIR", "iPhone-ARM", true, false);
        this.setStream(new IPAOutputStream());
    }

    @Override
    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("air");
    }

    @Override
    protected ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor appDescriptor) {
        return IPA_VALIDATION_PARAMS;
    }

    public void setOptimizeLevel(int optLevel) {
        this.getIPAStream().setOptimizeLevel(optLevel);
    }

    public void setInlineLevel(int inlineLevel) {
        this.getIPAStream().setInlineLevel(inlineLevel);
    }

    public void setCompressSWF(boolean compressFlag) {
        this.getIPAStream().setCompressSWF(compressFlag);
    }

    public void setVerbose(int verbosity) {
        this.getIPAStream().setVerbose(verbosity);
    }

    public int getVerbose() {
        return this.getIPAStream().getVerbose();
    }

    @Override
    public void setDebug(boolean debugFlag) {
        this.getIPAStream().setDebug(debugFlag);
    }

    public void setNoStrip(boolean stripFlag) {
        this.getIPAStream().setNoStrip(stripFlag);
    }

    public void setEnableSSC(boolean enableSSC) {
        this.getIPAStream().setEnableSSC(enableSSC);
    }

    public void setModuleSplitLimit(int splitLimit) {
        this.getIPAStream().setModuleSplitLimit(splitLimit);
    }

    public void setPoolSize(int poolSize) {
        this.getIPAStream().setPoolSize(poolSize);
    }

    public void setForce32Bit(boolean force32Bit) {
        this.getIPAStream().setForce32Bit(force32Bit);
    }

    public void setStackSize(String stackSize) {
        this.getIPAStream().setStackSize(stackSize);
    }

    public void setLogAOTPerf(boolean logPerf) {
        this.getIPAStream().setLogAOTPerf(logPerf);
    }

    public void setHideAneSymbols(boolean hide) {
        this.getIPAStream().setHideAneSymbols(hide);
    }

    public void setDebugRuntime(boolean debugRuntimeFlag) {
        this.getIPAStream().setDebugRuntime(debugRuntimeFlag);
    }

    public void setDebugBuiltins(boolean debugBuiltinsFlag) {
        this.getIPAStream().setDebugBuiltins(debugBuiltinsFlag);
    }

    public void setSamplerEnabled(boolean samplerEnabledFlag) {
        this.getIPAStream().setSamplerEnabled(samplerEnabledFlag);
    }

    @Override
    public void setForOutgoingDebuggingConnection(String debugHost, int debugPort) throws IOException {
        this.getIPAStream().setForOutgoingDebuggingConnection(debugHost, debugPort);
    }

    @Override
    public void setForIncomingDebuggerConnection(int portToListenOn) throws IOException {
        this.getIPAStream().setForIncomingDebuggerConnection(portToListenOn);
    }

    public void setUseInterpreter(boolean interpreterFlag) {
        this.getIPAStream().setUseInterpreter(interpreterFlag);
    }

    public void setDryRun(boolean dryRun) {
        this.getIPAStream().setDryRun(dryRun);
    }

    public void setTarget(String target) {
        if (target.equals("x86-simulator-air")) {
            this.m_targetPlatform = "iPhone-x86";
        }
        this.getIPAStream().setTarget(target);
    }

    public void setSDKLocation(String location) {
        this.getIPAStream().setSDKLocation(new File(location));
    }

    @Override
    public void setDeviceSDKDirectory(File sdkDir) throws InvalidInputException {
        if (!sdkDir.exists()) {
            throw new InvalidInputException("Directory " + sdkDir.getPath() + " does not exist.");
        }
        if (!sdkDir.isDirectory()) {
            throw new InvalidInputException(sdkDir.getPath() + " is not a directory.");
        }
        this.getIPAStream().setPlatformSDKLocation(sdkDir);
    }

    public void setRemoteContentURI(String remoteContent) {
        this.getIPAStream().setRemoteContentURI(remoteContent);
    }

    public void setTimeout(int timeoutSeconds) {
        this.getIPAStream().setTimeout(timeoutSeconds);
    }

    public void addExtraABC(String abc) {
        this.getIPAStream().addExtraABC(abc);
    }

    public void addLinkerOption(String linkoption) {
        this.getIPAStream().addLinkerOption(linkoption);
    }

    public void compileShellApp() throws IOException {
        this.getIPAStream().compileShellApp();
    }

    @Override
    public void setPackageConfiguration(String configType) {
        this.getIPAStream().setPackageConfiguration(configType);
    }

    public void setMobileProvisioningProfile(File profile) {
        this.getIPAStream().setMobileProvisioningProfile(profile);
    }

    public void createIPA() throws GeneralSecurityException, IOException {
        this.createPackage();
    }

    @Override
    public void createPackage() throws IOException, GeneralSecurityException {
        if (System.getProperty("os.name").indexOf("Mac") != -1) {
            String[] versionNumbers = System.getProperty("os.version").split("\\.");
            int majorVersion = Integer.parseInt(versionNumbers[0]);
            int minorVersion = Integer.parseInt(versionNumbers[1]);
            if (majorVersion < 10 || majorVersion == 10 && minorVersion < 5) {
                throw new ADTException("IPA packaging is not supported on mac 10.4 and earlier", 5);
            }
        }
        super.createPackage();
    }

    @Override
    public void setValidate(boolean validate) {
        super.setValidate(validate);
    }

    @Override
    protected void processExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        super.processExtensions();
        File tempDir = Utils.createTempDirectory();
        this.addFileForCleanup(tempDir);
        byte[] buf = new byte[1024];
        for (ANEFile ane : this.getExtensions()) {
            try {
                String nativeLibraryPath = ane.getNativeLibraryPath(this.m_targetPlatform);
                if (nativeLibraryPath == null) continue;
                ZipFile zipFile = new ZipFile(ane.getFile());
                InputStream in = zipFile.getInputStream(zipFile.getEntry(nativeLibraryPath));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(tempDir, "lib" + ane.id() + ".a")));
                int n2 = 0;
                while ((n2 = in.read(buf, 0, 1024)) > -1) {
                    ((OutputStream)out).write(buf, 0, n2);
                }
                in.close();
                ((OutputStream)out).close();
                this.getIPAStream().addExtensionsLib(ane.id());
                this.getIPAStream().addExtensionExportedSymbol(ane.id(), ane.getInitializer(this.m_targetPlatform));
                this.getIPAStream().addExtensionExportedSymbol(ane.id(), ane.getFinalizer(this.m_targetPlatform));
                if (ane.getDescriptor().namespaceCompare("http://ns.adobe.com/air/extension/3.1") >= 0) {
                    String platformOptionsPath = ane.getPlatformPath(this.m_targetPlatform) + "/" + "platform.xml";
                    ZipEntry platformOptionsFile = zipFile.getEntry(platformOptionsPath);
                    if (platformOptionsFile != null) {
                        IosExtensionDescriptor desc = new IosExtensionDescriptor(zipFile.getInputStream(platformOptionsFile), true, platformOptionsFile.getName());
                        ArrayList<String> linkerOptions = desc.linkerOptions();
                        this.getIPAStream().addExtensionPlatformOptions(ane.id(), linkerOptions);
                    }
                } else {
                    this.getIPAStream().setLinkAllFrameworks(true);
                }
                zipFile.close();
            }
            catch (IOException e2) {
                throw new InvalidInputException(ane.getFile().getAbsoluteFile() + " is not a valid native extension file.");
            }
        }
        this.getIPAStream().setExtLibDir(tempDir.getPath());
    }

    @Override
    protected void addExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        File tempDir = Utils.createTempDirectory();
        for (ANEFile ane : this.getExtensions()) {
            String platform = ane.supportsPlatform(this.m_targetPlatform, true, false) ? this.m_targetPlatform : ANEFile.DEFAULT_PLATFORM;
            String platformOptionsPath = ane.getPlatformPath(platform) + "/" + "platform.xml";
            String pathPrefix = "META-INF/ANE/" + platform + "/";
            ZipFile zipFile = new ZipFile(ane.getFile());
            ANEFile.ZipEntryIterator entries = ane.getFilesForPlatform(platform);
            for (ZipEntry entry : entries) {
                String entryName = entry.getName();
                if (entryName.equals(ane.getNativeLibraryPath(platform)) || entryName.equals("library.swf")) continue;
                if (entryName.equals(ane.getExtensionSwfPath(platform))) {
                    if (!this.getIPAStream().getUseInterpreter()) {
                        InputStream swfStream = zipFile.getInputStream(entry);
                        SWFUtils util = null;
                        try {
                            util = new SWFUtils(swfStream, ((IPAOutputStream)this.getADTStream()).getCompressSWF(), true);
                        }
                        catch (NoSuchAlgorithmException e2) {
                            throw new InvalidInputException("Invalid swf " + entry.getName() + " in extension " + ane.id());
                        }
                        int index = 0;
                        for (byte[] abcData : util.getABCs()) {
                            File temp = new File(tempDir, ane.id() + "-" + index + ".abc");
                            ((IPAOutputStream)this.getADTStream()).addExtensionAbc(ane.id(), temp);
                            FileOutputStream fop = new FileOutputStream(temp);
                            fop.write(abcData);
                            fop.flush();
                            fop.close();
                            ++index;
                        }
                        File strippedSwfFile = new File(tempDir, ane.id() + "-stripped.swf");
                        util.exportToFile(strippedSwfFile);
                        this.getADTStream().addFile(strippedSwfFile, "META-INF/AIR/extensions/" + ane.id() + "/" + entryName, true);
                        continue;
                    }
                    this.getADTStream().addFileFromZipEntry(entry, entries.getZipFile(), "META-INF/AIR/extensions/" + ane.id() + "/" + entryName);
                    continue;
                }
                if (!entryName.startsWith(pathPrefix) || ane.getDescriptor().namespaceCompare("http://ns.adobe.com/air/extension/3.1") >= 0 && entryName.equals(platformOptionsPath)) {
                    this.getADTStream().addFileFromZipEntry(entry, entries.getZipFile(), "META-INF/AIR/extensions/" + ane.id() + "/" + entryName);
                    continue;
                }
                if (!this.validateAssetFile(this.getApplicationDescriptor(), entryName.substring(pathPrefix.length()))) continue;
                this.getADTStream().addFileFromZipEntry(entry, entries.getZipFile(), entryName.substring(pathPrefix.length()));
            }
        }
    }

    private IPAOutputStream getIPAStream() {
        return (IPAOutputStream)this.getStream();
    }

    public List<String> getSupportedLanguagesList(ApplicationDescriptor appDescriptor) {
        List<String> supportedLanguages = appDescriptor.supportedLanguages();
        if (supportedLanguages == null) {
            this.getApplicationDescriptor();
            supportedLanguages = new ArrayList<String>(ApplicationDescriptor.ALL_SUPPORTED_LANGUAGES);
        }
        ListIterator<String> langListIter = supportedLanguages.listIterator();
        while (langListIter.hasNext()) {
            if (!langListIter.next().equals("zh")) continue;
            langListIter.remove();
            supportedLanguages.add("zh_Hans");
            supportedLanguages.add("zh_Hant");
            break;
        }
        return supportedLanguages;
    }

    @Override
    protected boolean validateAssetFile(ApplicationDescriptor appDescriptor, String filePath) {
        return Utils.validateMacResourceAgainstSupportedLanguages(filePath, this.getSupportedLanguagesList(appDescriptor));
    }
}

