/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResponseFileParser {
    private static Map<Character, Character> escapeMap = ResponseFileParser.generateEscapeMap();
    private static Set<Character> tokenSeparatorSet = ResponseFileParser.generateTokenSeparatorSet();

    public static String[] parse(BufferedReader r2) throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuffer currToken = new StringBuffer();
        boolean escape = false;
        int currCharCode = r2.read();
        while (currCharCode != -1) {
            if (!escape) {
                if (tokenSeparatorSet.contains(Character.valueOf((char)currCharCode))) {
                    tokens.add(currToken.toString());
                    currToken.setLength(0);
                    while (tokenSeparatorSet.contains(Character.valueOf((char)(currCharCode = r2.read())))) {
                    }
                    continue;
                }
                if (currCharCode == 92) {
                    escape = true;
                } else {
                    currToken.append((char)currCharCode);
                }
            } else {
                escape = false;
                Character mappedChar = escapeMap.get(Character.valueOf((char)currCharCode));
                if (mappedChar == null) {
                    if (currCharCode <= 255 && Character.isLetterOrDigit(currCharCode)) {
                        throw new Error("Illegal escape sequence");
                    }
                    if (currCharCode == 13) {
                        currCharCode = r2.read();
                        if (currCharCode != 10) {
                            continue;
                        }
                    } else if (currCharCode != 10) {
                        currToken.append((char)currCharCode);
                    }
                } else {
                    currToken.append(mappedChar);
                }
            }
            currCharCode = r2.read();
        }
        return tokens.toArray(new String[0]);
    }

    private static Map<Character, Character> generateEscapeMap() {
        HashMap<Character, Character> result = new HashMap<Character, Character>();
        result.put(Character.valueOf('\\'), Character.valueOf('\\'));
        result.put(Character.valueOf('#'), Character.valueOf('#'));
        result.put(Character.valueOf('\"'), Character.valueOf('\"'));
        result.put(Character.valueOf('\''), Character.valueOf('\''));
        result.put(Character.valueOf('|'), Character.valueOf('|'));
        result.put(Character.valueOf('&'), Character.valueOf('&'));
        result.put(Character.valueOf(';'), Character.valueOf(';'));
        result.put(Character.valueOf('('), Character.valueOf('('));
        result.put(Character.valueOf(')'), Character.valueOf(')'));
        result.put(Character.valueOf('<'), Character.valueOf('<'));
        result.put(Character.valueOf('$'), Character.valueOf('$'));
        result.put(Character.valueOf('`'), Character.valueOf('`'));
        result.put(Character.valueOf('!'), Character.valueOf('!'));
        result.put(Character.valueOf(' '), Character.valueOf(' '));
        result.put(Character.valueOf('n'), Character.valueOf('\n'));
        result.put(Character.valueOf('r'), Character.valueOf('\r'));
        result.put(Character.valueOf('t'), Character.valueOf('\t'));
        return result;
    }

    private static Set<Character> generateTokenSeparatorSet() {
        HashSet<Character> result = new HashSet<Character>();
        result.add(Character.valueOf('\n'));
        result.add(Character.valueOf(' '));
        result.add(Character.valueOf('\r'));
        return result;
    }
}

