/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWFUtils {
    private static final byte[] emptyABC = new byte[]{16, 0, 46, 0, 0, 0, 0, 2, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 2, 3, -48, 48, 71, 0, 0};
    protected Vector<byte[]> m_abcs = new Vector();
    protected MessageDigest m_sha1hasher = MessageDigest.getInstance("SHA-1");
    protected InputStream m_stream;
    protected int m_version;
    protected long m_length;
    protected boolean m_compress;
    protected SWFBuffStream m_swfStream = new SWFBuffStream();
    protected OutputStream m_outStream = null;
    protected int m_dataLen = 0;

    public SWFUtils(InputStream swfStream, boolean compressSWF, boolean insertEmptyAbcIfNecessary) throws IOException, NoSuchAlgorithmException {
        byte[] recordheader;
        byte[] header = new byte[8];
        swfStream.read(header);
        this.m_stream = header[0] == 67 ? new InflaterInputStream(swfStream) : swfStream;
        this.m_outStream = this.m_swfStream;
        header[0] = compressSWF ? 67 : 70;
        this.m_version = header[3];
        this.write(header, 0, header.length);
        if (compressSWF) {
            this.m_outStream = new DeflaterOutputStream((OutputStream)this.m_swfStream, new Deflater(9));
        }
        byte[] rect = this.inspect(1);
        byte rbits = (byte)((rect[0] & 0xFF) >> 3);
        int rrbytes = (7 + rbits * 4 - 3) / 8;
        this.inspect(rrbytes);
        this.inspect(2);
        this.inspect(2);
        int tag = -1;
        while (tag != 0 && (recordheader = this.read(2)).length >= 2) {
            int code = (recordheader[1] & 0xFF) << 8 | recordheader[0] & 0xFF;
            tag = code >> 6;
            int length = code & 0x3F;
            int bhead = 2;
            byte[] longlength = null;
            if (length == 63) {
                longlength = this.read(4);
                length = (longlength[3] & 0xFF) << 24 | (longlength[2] & 0xFF) << 16 | (longlength[1] & 0xFF) << 8 | longlength[0] & 0xFF;
                bhead += 4;
            }
            if (tag == 82 || tag == 72) {
                byte[] data = this.read(length);
                int n2 = 0;
                if (tag == 82) {
                    n2 = 4;
                    while (data[n2] != 0) {
                        ++n2;
                    }
                    ++n2;
                }
                byte[] abc = data;
                if (n2 > 0) {
                    byte[] temp = new byte[data.length - n2];
                    System.arraycopy(data, n2, temp, 0, temp.length);
                    abc = temp;
                }
                this.m_abcs.add(abc);
                byte[] digest = this.m_sha1hasher.digest(abc);
                int newlen = n2 + 24;
                if (newlen < 63) {
                    this.writeShort(tag << 6 | newlen);
                } else {
                    this.writeShort(tag << 6 | 0x3F);
                    this.writeInt32(newlen);
                }
                if (tag == 82) {
                    this.write(data, 0, n2);
                }
                this.writeInt32(0);
                this.write(digest, 0, digest.length);
                continue;
            }
            this.write(recordheader, 0, recordheader.length);
            if (bhead > 2) {
                this.write(longlength, 0, longlength.length);
            }
            this.inspect(length);
        }
        if (this.m_outStream instanceof DeflaterOutputStream) {
            DeflaterOutputStream s2 = (DeflaterOutputStream)this.m_outStream;
            s2.finish();
        }
        this.m_swfStream.writeIntAtOffset(this.m_dataLen, 4);
        if (insertEmptyAbcIfNecessary && this.m_abcs.isEmpty()) {
            this.m_abcs.add(emptyABC);
        }
    }

    protected byte[] read(int numBytes) throws IOException {
        byte[] bytes = new byte[numBytes];
        int offset = 0;
        int numBytesRead = 1;
        while (numBytes > 0 && numBytesRead > 0) {
            numBytesRead = this.m_stream.read(bytes, offset, numBytes);
            offset += numBytesRead;
            numBytes -= numBytesRead;
        }
        if (numBytes > 0) {
            offset = offset > 0 ? offset : 0;
            byte[] newArray = new byte[offset];
            System.arraycopy(bytes, 0, newArray, 0, offset);
            bytes = newArray;
        }
        return bytes;
    }

    protected void writeShort(int value) throws IOException {
        this.m_outStream.write(value & 0xFF);
        this.m_outStream.write(value >> 8);
        this.m_dataLen += 2;
    }

    protected void writeInt32(int value) throws IOException {
        this.m_outStream.write(value);
        this.m_outStream.write(value >> 8);
        this.m_outStream.write(value >> 16);
        this.m_outStream.write(value >> 24);
        this.m_dataLen += 4;
    }

    protected void write(byte[] bytes, int off, int len) throws IOException {
        this.m_outStream.write(bytes, off, len);
        this.m_dataLen += len;
    }

    protected byte[] inspect(int numBytes) throws IOException {
        byte[] bytes = this.read(numBytes);
        this.write(bytes, 0, bytes.length);
        return bytes;
    }

    public Vector<byte[]> getABCs() {
        return this.m_abcs;
    }

    public void exportToFile(File file) throws IOException {
        FileOutputStream fop = new FileOutputStream(file);
        this.m_swfStream.writeTo(fop);
        fop.flush();
        fop.close();
    }

    public int getVersion() {
        return this.m_version;
    }

    private class SWFBuffStream
    extends ByteArrayOutputStream {
        private SWFBuffStream() {
        }

        public void writeIntAtOffset(int value, int offset) throws IOException {
            this.buf[offset + 3] = (byte)(value >> 24);
            this.buf[offset + 2] = (byte)(value >> 16);
            this.buf[offset + 1] = (byte)(value >> 8);
            this.buf[offset] = (byte)value;
        }
    }
}

