/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.pki.Base64;
import com.adobe.ucf.UCF;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.MessageFormat;

public abstract class CodeSigner {
    public static int FLAG_TIMESTAMP_URI_SIGNATURE_VALUE = 1;
    public static int FLAG_TIMESTAMP_URI_PACKAGE_VALUE = 2;
    protected StringBuffer m_packageManifest = new StringBuffer();
    protected MessageFormat m_fileInfoFormat;
    protected MessageDigest m_sharedDigest;
    private int m_timestampUriFlags = FLAG_TIMESTAMP_URI_PACKAGE_VALUE;

    public abstract void setPrivateKey(PrivateKey var1);

    public abstract void setCertificateChain(Certificate[] var1) throws CertificateException;

    public abstract void setSignerCertificate(Certificate var1) throws CertificateException;

    public abstract byte[] sign() throws InvalidKeyException, NoSuchAlgorithmException;

    public abstract void setTimestampURL(String var1);

    public void setTimestampUriFlags(int uriFlags) {
        this.m_timestampUriFlags = uriFlags;
    }

    protected int getTimestampUriFlags() {
        return this.m_timestampUriFlags;
    }

    public abstract String getSignatureXML() throws GeneralSecurityException, IOException;

    public void updateFileDigest(byte[] bytes, int offset, int length) {
        this.m_sharedDigest.update(bytes, offset, length);
    }

    public byte[] finalizeFileDigest() {
        return this.m_sharedDigest.digest();
    }

    public void addFileDigestToManifest(byte[] digest, String path) {
        String currentFileRef = this.m_fileInfoFormat.format(new Object[]{path.replaceAll("&", "&amp;"), Base64.encodeBytes(digest)});
        this.m_packageManifest.append(currentFileRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readStringFromResource(String resource) {
        String resourceString = new String();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                is = CodeSigner.class.getResourceAsStream(resource);
            }
            resourceString = UCF.stringFromInputStream(is);
        }
        catch (IOException e2) {
            assert (false);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e3) {}
            }
        }
        return resourceString;
    }
}

