/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Utils {
    public static void copyTo(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            dest.mkdirs();
            for (File sourceChild : source.listFiles()) {
                File destChild = new File(dest, sourceChild.getName());
                Utils.copyTo(sourceChild, destChild);
            }
        } else {
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(dest);
            Utils.writeThrough(in, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void consumeOutput(Process process) {
        new OutputEater(process.getInputStream()).run();
        new OutputEater(process.getErrorStream()).run();
    }

    public static void writeThrough(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) != -1) {
            if (out == null) continue;
            out.write(buffer, 0, len);
        }
    }

    public static boolean isFileExecutable(File file) {
        if (!file.exists()) {
            return false;
        }
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            return false;
        }
        try {
            Process test = new ProcessBuilder("test", "-x", file.getAbsolutePath()).start();
            test.waitFor();
            return test.exitValue() == 0;
        }
        catch (IOException e2) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFileSymLink(File file) {
        if (!file.exists()) {
            return false;
        }
        if (!System.getProperty("os.name").startsWith("Mac OS X")) {
            return false;
        }
        try {
            Process test = new ProcessBuilder("test", "-L", file.getAbsolutePath()).start();
            test.waitFor();
            return test.exitValue() == 0;
        }
        catch (IOException e2) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static String getSymlinkPointsTo(File file) {
        if (!file.exists()) {
            return "";
        }
        if (!System.getProperty("os.name").startsWith("Mac OS X")) {
            return "";
        }
        try {
            Process getSymlink = new ProcessBuilder("readlink", file.getAbsolutePath()).start();
            ByteArrayOutputStream processStdout = new ByteArrayOutputStream();
            new OutputEater(getSymlink.getInputStream(), processStdout).run();
            getSymlink.waitFor();
            String procStdout = processStdout.toString("UTF-8");
            procStdout = procStdout.replace(System.getProperty("line.separator"), "");
            return procStdout;
        }
        catch (IOException e2) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "";
    }

    public static class OutputEater
    extends Thread {
        private InputStream _in;
        private OutputStream _out;

        public OutputEater(InputStream in, OutputStream out) {
            this._in = in;
            this._out = out;
        }

        public OutputEater(InputStream in) {
            this(in, null);
        }

        public void run() {
            try {
                Utils.writeThrough(this._in, this._out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

