/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.IssuerAltName;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

public class CertJUtils {
    public static void mergeLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            Object e2 = vector2.elementAt(i2);
            if (vector.contains(e2)) continue;
            vector.addElement(e2);
        }
    }

    public static void subtractLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            Object e2 = vector2.elementAt(i2);
            if (!vector.contains(e2)) continue;
            vector.removeElement(e2);
        }
    }

    public static void intersectLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        int n2 = vector.size();
        while (n2 > 0) {
            if (vector2.contains(vector.elementAt(--n2))) continue;
            vector.removeElementAt(n2);
        }
    }

    public static void uniteLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            Object e2 = vector2.elementAt(i2);
            if (vector.contains(e2)) continue;
            vector.addElement(e2);
        }
    }

    public static boolean byteArraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean byteArraysEqual(byte[] byArray, int n2, int n3, byte[] byArray2) {
        return CertJUtils.byteArraysEqual(byArray, n2, n3, byArray2, 0, byArray2.length);
    }

    public static boolean byteArraysEqual(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (n3 != n5) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[n2 + i2] == byArray2[n4 + i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean containsByteArray(Vector vector, byte[] byArray) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (!CertJUtils.byteArraysEqual((byte[])vector.elementAt(i2), byArray)) continue;
            return true;
        }
        return false;
    }

    public static void intersectByteArrayLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        int n2 = vector.size();
        while (n2 > 0) {
            if (CertJUtils.containsByteArray(vector2, (byte[])vector.elementAt(--n2))) continue;
            vector.removeElementAt(n2);
        }
    }

    public static void uniteByteArrayLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            byte[] byArray = (byte[])vector2.elementAt(i2);
            if (CertJUtils.containsByteArray(vector, byArray)) continue;
            vector.addElement(byArray);
        }
    }

    public static boolean sequencesEqual(Vector vector, Vector vector2) {
        int n2;
        int n3 = vector.size();
        if (n3 != (n2 = vector2.size())) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (vector.elementAt(i2).equals(vector2.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean setsEqual(Vector vector, Vector vector2) {
        int n2;
        int n3 = vector.size();
        if (n3 != (n2 = vector2.size())) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (vector.contains(vector2.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsExtension(X509V3Extension x509V3Extension, X509V3Extensions x509V3Extensions) {
        int n2 = x509V3Extension.getExtensionType();
        X509V3Extension x509V3Extension2 = null;
        try {
            x509V3Extension2 = x509V3Extensions.getExtensionByType(n2);
        }
        catch (CertificateException certificateException) {
            return false;
        }
        if (x509V3Extension2 == null) {
            return false;
        }
        switch (n2) {
            case 18: {
                GeneralNames generalNames = ((IssuerAltName)x509V3Extension).getGeneralNames();
                GeneralNames generalNames2 = ((IssuerAltName)x509V3Extension2).getGeneralNames();
                try {
                    for (int i2 = 0; i2 < generalNames.getNameCount(); ++i2) {
                        if (!generalNames2.contains(generalNames.getGeneralName(i2))) continue;
                        return true;
                    }
                }
                catch (NameException nameException) {
                    return false;
                }
                return false;
            }
        }
        byte[] byArray = new byte[x509V3Extension.getDERLen(0)];
        byte[] byArray2 = new byte[x509V3Extension2.getDERLen(0)];
        if (byArray.length != byArray2.length) {
            return false;
        }
        x509V3Extension.getDEREncoding(byArray, 0, 0);
        x509V3Extension2.getDEREncoding(byArray2, 0, 0);
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            if (byArray[i3] == byArray2[i3]) continue;
            return false;
        }
        return true;
    }

    public static boolean compareExtensions(X509V3Extensions x509V3Extensions, X509V3Extensions x509V3Extensions2) {
        if (x509V3Extensions == null) {
            return true;
        }
        if (x509V3Extensions2 == null) {
            return false;
        }
        try {
            for (int i2 = 0; i2 < x509V3Extensions.getExtensionCount(); ++i2) {
                if (CertJUtils.containsExtension(x509V3Extensions.getExtensionByIndex(i2), x509V3Extensions2)) continue;
                return false;
            }
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }
}

