/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.OIDList;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.CertificateException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class CertRequest
implements Cloneable,
Serializable {
    public static final int RSA_WITH_SHA1_PKCS = 0;
    public static final int RSA_WITH_SHA1_ISO_OIW = 1;
    public static final int DSA_WITH_SHA1_X930 = 2;
    public static final int DSA_WITH_SHA1_X957 = 3;
    protected byte[] subjectPublicKeyInfo;
    protected byte[] signatureAlgorithmBER;
    protected int signatureAlgorithmFormat = -1;
    protected byte[] signature;
    protected boolean signedByUs;
    protected String theDevice;
    protected String[] theDeviceList;
    private CertJ a = null;

    public final void setCertJ(CertJ certJ) {
        this.a = certJ;
    }

    public final CertJ getCertJ() {
        return this.a;
    }

    public String getSignatureAlgorithm() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return OIDList.getTrans(this.signatureAlgorithmBER, 0, this.signatureAlgorithmBER.length, 1);
    }

    public byte[] getSignatureAlgorithmDER() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return (byte[])this.signatureAlgorithmBER.clone();
    }

    public abstract byte[] getSignature() throws CertificateException;

    public String getDevice() throws CertificateException {
        if (this.theDevice == null) {
            throw new CertificateException("Object not set with a device.");
        }
        return this.theDevice;
    }

    public String[] getDeviceList() throws CertificateException {
        if (this.theDeviceList == null) {
            throw new CertificateException("Object not set with a device.");
        }
        String[] stringArray = new String[this.theDeviceList.length];
        for (int i2 = 0; i2 < this.theDeviceList.length; ++i2) {
            stringArray[i2] = this.theDeviceList[i2];
        }
        return stringArray;
    }

    public void setSignatureStandard(int n2) {
        this.signatureAlgorithmFormat = n2;
    }

    public int getSignatureStandard() {
        return this.signatureAlgorithmFormat;
    }

    public String getSignatureFormat() {
        switch (this.signatureAlgorithmFormat) {
            case 0: {
                return "RSAWithSHA1PKCS";
            }
            case 1: {
                return "RSAWithSHA1ISO_OIW";
            }
            case 2: {
                return "DSAWithSHA1X930";
            }
            case 3: {
                return "DSAWithSHA1X957";
            }
        }
        return null;
    }

    public void setSubjectPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws CertificateException {
        this.clearSignature();
        if (jSAFE_PublicKey == null) {
            throw new CertificateException("Public key is null.");
        }
        try {
            String string = null;
            string = this.signatureAlgorithmFormat == 3 && jSAFE_PublicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : jSAFE_PublicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] byArray = jSAFE_PublicKey.getKeyData(string);
            this.subjectPublicKeyInfo = byArray[0];
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Could not read the public key.");
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey(String string) throws CertificateException {
        if (this.subjectPublicKeyInfo == null) {
            throw new CertificateException("Object not set with public key.");
        }
        if (string == null) {
            throw new CertificateException("Device is null.");
        }
        try {
            return JSAFE_PublicKey.getInstance(this.subjectPublicKeyInfo, 0, string);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Cannot retrieve the public key: " + jSAFE_Exception.getMessage());
        }
    }

    public void setSubjectPublicKey(byte[] byArray, int n2) throws CertificateException {
        this.clearSignature();
        if (byArray == null) {
            throw new CertificateException("Public key encoding is null.");
        }
        JSAFE_PublicKey jSAFE_PublicKey = null;
        try {
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance(byArray, n2, "Java");
            this.setSubjectPublicKey(jSAFE_PublicKey);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Could not read the public key.");
        }
        finally {
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
        }
    }

    public abstract void signCertRequest(String var1, String var2, JSAFE_PrivateKey var3, SecureRandom var4) throws CertificateException;

    public abstract boolean verifyCertRequestSignature(String var1, SecureRandom var2) throws CertificateException;

    protected byte[] performSignature(String string, String string2, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom, byte[] byArray, int n2, int n3) throws CertificateException {
        if (string == null || string2 == null || jSAFE_PrivateKey == null || secureRandom == null || byArray == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature jSAFE_Signature = null;
        try {
            this.signedByUs = true;
            jSAFE_Signature = JSAFE_Signature.getInstance(string, string2);
            if (this.a == null) {
                jSAFE_Signature.signInit(jSAFE_PrivateKey, null, secureRandom, null);
            } else {
                jSAFE_Signature.signInit(jSAFE_PrivateKey, null, secureRandom, this.a.getPKCS11Sessions());
            }
            this.signatureAlgorithmBER = jSAFE_Signature.getDERAlgorithmID(this.getSignatureFormat(), false);
            jSAFE_Signature.signUpdate(byArray, n2, n3);
            byte[] byArray2 = jSAFE_Signature.signFinal();
            return byArray2;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            this.signedByUs = false;
            throw new CertificateException("Could not sign the request: " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_Signature != null) {
                jSAFE_Signature.clearSensitiveData();
            }
        }
    }

    protected boolean performSignatureVerification(String string, SecureRandom secureRandom, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws CertificateException {
        if (string == null || secureRandom == null || byArray == null || byArray2 == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_PublicKey jSAFE_PublicKey = null;
        JSAFE_Signature jSAFE_Signature = null;
        try {
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance(this.subjectPublicKeyInfo, 0, string);
            jSAFE_Signature = JSAFE_Signature.getInstance(this.signatureAlgorithmBER, 0, string);
            if (this.a == null) {
                jSAFE_Signature.verifyInit(jSAFE_PublicKey, null, secureRandom, null);
            } else {
                jSAFE_Signature.verifyInit(jSAFE_PublicKey, null, secureRandom, this.a.getPKCS11Sessions());
            }
            jSAFE_Signature.verifyUpdate(byArray, n2, n3);
            boolean bl2 = jSAFE_Signature.verifyFinal(byArray2, n4, n5);
            Object var13_13 = null;
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
            if (jSAFE_Signature != null) {
                jSAFE_Signature.clearSensitiveData();
            }
            return bl2;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            try {
                throw new CertificateException("Could not verify the request: " + jSAFE_Exception.getMessage());
            }
            catch (Throwable throwable) {
                block10: {
                    Object var13_14 = null;
                    if (jSAFE_PublicKey != null) {
                        jSAFE_PublicKey.clearSensitiveData();
                    }
                    if (jSAFE_Signature == null) break block10;
                    jSAFE_Signature.clearSensitiveData();
                }
                throw throwable;
            }
        }
    }

    protected void clearSignature() {
        this.signature = null;
        this.signatureAlgorithmBER = null;
        this.signedByUs = false;
        this.theDevice = null;
        this.theDeviceList = null;
    }

    protected void clearComponents() {
        this.clearSignature();
        this.subjectPublicKeyInfo = null;
    }
}

