/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Vector;

public class RDN
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;

    public RDN(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        this.special = n3;
        try {
            OfContainer ofContainer = new OfContainer(n3, 12544, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n4 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                EncodedContainer encodedContainer = new EncodedContainer(65280);
                EndContainer endContainer = new EndContainer();
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
                ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray2);
                int n5 = RDN.a(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen);
                byte[] byArray2 = null;
                if (n5 == -1 && oIDContainer.data != null && oIDContainer.dataLen > 0) {
                    byArray2 = new byte[oIDContainer.dataLen];
                    System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, byArray2, 0, oIDContainer.dataLen);
                }
                AttributeValueAssertion attributeValueAssertion = new AttributeValueAssertion(n5, byArray2, encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
                this.addNameAVA(attributeValueAssertion);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the RDN.");
        }
    }

    public RDN() {
    }

    public Object clone() throws CloneNotSupportedException {
        RDN rDN = new RDN();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)this.a.elementAt(i2);
            rDN.a.addElement(attributeValueAssertion.clone());
        }
        rDN.special = this.special;
        if (this.asn1Template != null) {
            rDN.a();
        }
        return rDN;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.size() == 0) {
            return "";
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)this.a.elementAt(i2);
            String string = attributeValueAssertion.toString(bl2);
            stringBuffer.append(string);
            if (i2 >= this.a.size() - 1) continue;
            stringBuffer.append("+");
        }
        return stringBuffer.toString();
    }

    public int getAttributeCount() {
        return this.a.size();
    }

    public AttributeValueAssertion getAttributeByIndex(int n2) throws NameException {
        int n3 = this.a.size();
        if (n2 >= 0 && n3 > n2) {
            return (AttributeValueAssertion)this.a.elementAt(n2);
        }
        throw new NameException("Invalid Index.");
    }

    public void removeAVA(int n2) throws NameException {
        if (n2 >= this.a.size()) {
            throw new NameException("Invalid Iidex.");
        }
        this.a.removeElementAt(n2);
    }

    public void setAVA(AttributeValueAssertion attributeValueAssertion, int n2) throws NameException {
        if (attributeValueAssertion == null) {
            throw new NameException("Specified AVA is null.");
        }
        if (n2 >= this.a.size()) {
            throw new NameException("Invalid index.");
        }
        this.a.setElementAt(attributeValueAssertion, n2);
    }

    public AttributeValueAssertion getAttribute(int n2) {
        int n3 = this.a.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)this.a.elementAt(i2);
            if (attributeValueAssertion.getAttributeType() != n2) continue;
            return attributeValueAssertion;
        }
        return null;
    }

    private static int a(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return -1;
        }
        for (int i2 = 0; i2 < AttributeValueAssertion.allNameAttributeIDs.length; ++i2) {
            int n4;
            if (n3 != AttributeValueAssertion.allNameAttributeIDs[i2].a.length) continue;
            for (n4 = 0; n4 < n3 && (byArray[n4 + n2] & 0xFF) == (AttributeValueAssertion.allNameAttributeIDs[i2].a[n4] & 0xFF); ++n4) {
            }
            if (n4 < n3) continue;
            return i2;
        }
        return -1;
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n2) {
        this.special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n3 != this.special) {
                this.getDERLen(n3);
                if (this.asn1Template == null) {
                    throw new NameException("Unable to encode RDN.");
                }
            }
            return this.asn1Template.derEncode(byArray, n2);
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode RDN.");
        }
    }

    private int a() {
        try {
            int n2 = this.a.size();
            OfContainer ofContainer = new OfContainer(this.special, true, 0, 12544, new EncodedContainer(12288));
            for (int i2 = 0; i2 < n2; ++i2) {
                AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)this.a.elementAt(i2);
                int n3 = attributeValueAssertion.getDERLen();
                byte[] byArray = new byte[n3];
                n3 = attributeValueAssertion.getDEREncoding(byArray, 0);
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n3);
                ofContainer.addContainer(encodedContainer);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public void addNameAVA(AttributeValueAssertion attributeValueAssertion) {
        if (attributeValueAssertion != null) {
            this.a.addElement(attributeValueAssertion);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        if (this.a.size() != rDN.a.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            if (this.a((AttributeValueAssertion)this.a.elementAt(i2), rDN.a)) continue;
            return false;
        }
        return true;
    }

    private boolean a(AttributeValueAssertion attributeValueAssertion, Vector vector) {
        if (attributeValueAssertion == null || vector == null) {
            return false;
        }
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (!attributeValueAssertion.equals((AttributeValueAssertion)vector.elementAt(i2))) continue;
            return true;
        }
        return false;
    }
}

