/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.Constant;
import llvm.Module;
import llvm.PointerType;
import llvm.SWIGTYPE_p_std__string;
import llvm.StringRef;
import llvm.Value;
import llvm.llvmJNI;

public class GlobalValue
extends Constant {
    private long swigCPtr;

    protected GlobalValue(long l2, boolean bl2) {
        super(llvmJNI.SWIGGlobalValueUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(GlobalValue globalValue) {
        return globalValue == null ? 0L : globalValue.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_GlobalValue(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public long getAlignment() {
        return llvmJNI.GlobalValue_getAlignment(this.swigCPtr, this);
    }

    public void setAlignment(long l2) {
        llvmJNI.GlobalValue_setAlignment(this.swigCPtr, this, l2);
    }

    public VisibilityTypes getVisibility() {
        return VisibilityTypes.swigToEnum(llvmJNI.GlobalValue_getVisibility(this.swigCPtr, this));
    }

    public boolean hasDefaultVisibility() {
        return llvmJNI.GlobalValue_hasDefaultVisibility(this.swigCPtr, this);
    }

    public boolean hasHiddenVisibility() {
        return llvmJNI.GlobalValue_hasHiddenVisibility(this.swigCPtr, this);
    }

    public boolean hasProtectedVisibility() {
        return llvmJNI.GlobalValue_hasProtectedVisibility(this.swigCPtr, this);
    }

    public void setVisibility(VisibilityTypes visibilityTypes) {
        llvmJNI.GlobalValue_setVisibility(this.swigCPtr, this, visibilityTypes.swigValue());
    }

    public boolean hasSection() {
        return llvmJNI.GlobalValue_hasSection(this.swigCPtr, this);
    }

    public String getSection() {
        return llvmJNI.GlobalValue_getSection(this.swigCPtr, this);
    }

    public void setSection(StringRef stringRef) {
        llvmJNI.GlobalValue_setSection(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef);
    }

    public PointerType getType() {
        long l2 = llvmJNI.GlobalValue_getType(this.swigCPtr, this);
        return l2 == 0L ? null : new PointerType(l2, false);
    }

    public static LinkageTypes getLinkOnceLinkage(boolean bl2) {
        return LinkageTypes.swigToEnum(llvmJNI.GlobalValue_getLinkOnceLinkage(bl2));
    }

    public static LinkageTypes getWeakLinkage(boolean bl2) {
        return LinkageTypes.swigToEnum(llvmJNI.GlobalValue_getWeakLinkage(bl2));
    }

    public static boolean isExternalLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isExternalLinkage(linkageTypes.swigValue());
    }

    public static boolean isAvailableExternallyLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isAvailableExternallyLinkage(linkageTypes.swigValue());
    }

    public static boolean isLinkOnceLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isLinkOnceLinkage(linkageTypes.swigValue());
    }

    public static boolean isWeakLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isWeakLinkage(linkageTypes.swigValue());
    }

    public static boolean isAppendingLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isAppendingLinkage(linkageTypes.swigValue());
    }

    public static boolean isInternalLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isInternalLinkage(linkageTypes.swigValue());
    }

    public static boolean isPrivateLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isPrivateLinkage(linkageTypes.swigValue());
    }

    public static boolean isLinkerPrivateLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isLinkerPrivateLinkage(linkageTypes.swigValue());
    }

    public static boolean isLocalLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isLocalLinkage(linkageTypes.swigValue());
    }

    public static boolean isDLLImportLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isDLLImportLinkage(linkageTypes.swigValue());
    }

    public static boolean isDLLExportLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isDLLExportLinkage(linkageTypes.swigValue());
    }

    public static boolean isExternalWeakLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isExternalWeakLinkage(linkageTypes.swigValue());
    }

    public static boolean isCommonLinkage(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isCommonLinkage(linkageTypes.swigValue());
    }

    public static boolean mayBeOverridden(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_mayBeOverridden__SWIG_0(linkageTypes.swigValue());
    }

    public static boolean isWeakForLinker(LinkageTypes linkageTypes) {
        return llvmJNI.GlobalValue_isWeakForLinker__SWIG_0(linkageTypes.swigValue());
    }

    public boolean hasExternalLinkage() {
        return llvmJNI.GlobalValue_hasExternalLinkage(this.swigCPtr, this);
    }

    public boolean hasAvailableExternallyLinkage() {
        return llvmJNI.GlobalValue_hasAvailableExternallyLinkage(this.swigCPtr, this);
    }

    public boolean hasLinkOnceLinkage() {
        return llvmJNI.GlobalValue_hasLinkOnceLinkage(this.swigCPtr, this);
    }

    public boolean hasWeakLinkage() {
        return llvmJNI.GlobalValue_hasWeakLinkage(this.swigCPtr, this);
    }

    public boolean hasAppendingLinkage() {
        return llvmJNI.GlobalValue_hasAppendingLinkage(this.swigCPtr, this);
    }

    public boolean hasInternalLinkage() {
        return llvmJNI.GlobalValue_hasInternalLinkage(this.swigCPtr, this);
    }

    public boolean hasPrivateLinkage() {
        return llvmJNI.GlobalValue_hasPrivateLinkage(this.swigCPtr, this);
    }

    public boolean hasLinkerPrivateLinkage() {
        return llvmJNI.GlobalValue_hasLinkerPrivateLinkage(this.swigCPtr, this);
    }

    public boolean hasLocalLinkage() {
        return llvmJNI.GlobalValue_hasLocalLinkage(this.swigCPtr, this);
    }

    public boolean hasDLLImportLinkage() {
        return llvmJNI.GlobalValue_hasDLLImportLinkage(this.swigCPtr, this);
    }

    public boolean hasDLLExportLinkage() {
        return llvmJNI.GlobalValue_hasDLLExportLinkage(this.swigCPtr, this);
    }

    public boolean hasExternalWeakLinkage() {
        return llvmJNI.GlobalValue_hasExternalWeakLinkage(this.swigCPtr, this);
    }

    public boolean hasCommonLinkage() {
        return llvmJNI.GlobalValue_hasCommonLinkage(this.swigCPtr, this);
    }

    public void setLinkage(LinkageTypes linkageTypes) {
        llvmJNI.GlobalValue_setLinkage(this.swigCPtr, this, linkageTypes.swigValue());
    }

    public LinkageTypes getLinkage() {
        return LinkageTypes.swigToEnum(llvmJNI.GlobalValue_getLinkage(this.swigCPtr, this));
    }

    public boolean mayBeOverridden() {
        return llvmJNI.GlobalValue_mayBeOverridden__SWIG_1(this.swigCPtr, this);
    }

    public boolean isWeakForLinker() {
        return llvmJNI.GlobalValue_isWeakForLinker__SWIG_1(this.swigCPtr, this);
    }

    public void copyAttributesFrom(GlobalValue globalValue) {
        llvmJNI.GlobalValue_copyAttributesFrom(this.swigCPtr, this, GlobalValue.getCPtr(globalValue), globalValue);
    }

    public boolean isMaterializable() {
        return llvmJNI.GlobalValue_isMaterializable(this.swigCPtr, this);
    }

    public boolean isDematerializable() {
        return llvmJNI.GlobalValue_isDematerializable(this.swigCPtr, this);
    }

    public boolean Materialize(SWIGTYPE_p_std__string sWIGTYPE_p_std__string) {
        return llvmJNI.GlobalValue_Materialize__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_std__string.getCPtr(sWIGTYPE_p_std__string));
    }

    public boolean Materialize() {
        return llvmJNI.GlobalValue_Materialize__SWIG_1(this.swigCPtr, this);
    }

    public void Dematerialize() {
        llvmJNI.GlobalValue_Dematerialize(this.swigCPtr, this);
    }

    public boolean isNullValue() {
        return llvmJNI.GlobalValue_isNullValue(this.swigCPtr, this);
    }

    public void destroyConstant() {
        llvmJNI.GlobalValue_destroyConstant(this.swigCPtr, this);
    }

    public boolean isDeclaration() {
        return llvmJNI.GlobalValue_isDeclaration(this.swigCPtr, this);
    }

    public void removeFromParent() {
        llvmJNI.GlobalValue_removeFromParent(this.swigCPtr, this);
    }

    public void eraseFromParent() {
        llvmJNI.GlobalValue_eraseFromParent(this.swigCPtr, this);
    }

    public Module getParent() {
        long l2 = llvmJNI.GlobalValue_getParent__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Module(l2, false);
    }

    public void removeDeadConstantUsers() {
        llvmJNI.GlobalValue_removeDeadConstantUsers(this.swigCPtr, this);
    }

    public static boolean classof(GlobalValue globalValue) {
        return llvmJNI.GlobalValue_classof__SWIG_0(GlobalValue.getCPtr(globalValue), globalValue);
    }

    public static boolean classof(Value value) {
        return llvmJNI.GlobalValue_classof__SWIG_1(Value.getCPtr(value), value);
    }

    public static GlobalValue dyn_cast(Constant constant) {
        long l2 = llvmJNI.GlobalValue_dyn_cast(Constant.getCPtr(constant), constant);
        return l2 == 0L ? null : new GlobalValue(l2, false);
    }

    public static final class VisibilityTypes {
        public static final VisibilityTypes DefaultVisibility = new VisibilityTypes("DefaultVisibility", llvmJNI.GlobalValue_DefaultVisibility_get());
        public static final VisibilityTypes HiddenVisibility = new VisibilityTypes("HiddenVisibility");
        public static final VisibilityTypes ProtectedVisibility = new VisibilityTypes("ProtectedVisibility");
        private static VisibilityTypes[] swigValues = new VisibilityTypes[]{DefaultVisibility, HiddenVisibility, ProtectedVisibility};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static VisibilityTypes swigToEnum(int n2) {
            if (n2 < swigValues.length && n2 >= 0 && VisibilityTypes.swigValues[n2].swigValue == n2) {
                return swigValues[n2];
            }
            for (int i2 = 0; i2 < swigValues.length; ++i2) {
                if (VisibilityTypes.swigValues[i2].swigValue != n2) continue;
                return swigValues[i2];
            }
            throw new IllegalArgumentException("No enum " + VisibilityTypes.class + " with value " + n2);
        }

        private VisibilityTypes(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private VisibilityTypes(String string, int n2) {
            this.swigName = string;
            this.swigValue = n2;
            swigNext = n2 + 1;
        }

        private VisibilityTypes(String string, VisibilityTypes visibilityTypes) {
            this.swigName = string;
            this.swigValue = visibilityTypes.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class LinkageTypes {
        public static final LinkageTypes ExternalLinkage = new LinkageTypes("ExternalLinkage", llvmJNI.GlobalValue_ExternalLinkage_get());
        public static final LinkageTypes AvailableExternallyLinkage = new LinkageTypes("AvailableExternallyLinkage");
        public static final LinkageTypes LinkOnceAnyLinkage = new LinkageTypes("LinkOnceAnyLinkage");
        public static final LinkageTypes LinkOnceODRLinkage = new LinkageTypes("LinkOnceODRLinkage");
        public static final LinkageTypes WeakAnyLinkage = new LinkageTypes("WeakAnyLinkage");
        public static final LinkageTypes WeakODRLinkage = new LinkageTypes("WeakODRLinkage");
        public static final LinkageTypes AppendingLinkage = new LinkageTypes("AppendingLinkage");
        public static final LinkageTypes InternalLinkage = new LinkageTypes("InternalLinkage");
        public static final LinkageTypes PrivateLinkage = new LinkageTypes("PrivateLinkage");
        public static final LinkageTypes LinkerPrivateLinkage = new LinkageTypes("LinkerPrivateLinkage");
        public static final LinkageTypes DLLImportLinkage = new LinkageTypes("DLLImportLinkage");
        public static final LinkageTypes DLLExportLinkage = new LinkageTypes("DLLExportLinkage");
        public static final LinkageTypes ExternalWeakLinkage = new LinkageTypes("ExternalWeakLinkage");
        public static final LinkageTypes CommonLinkage = new LinkageTypes("CommonLinkage");
        private static LinkageTypes[] swigValues = new LinkageTypes[]{ExternalLinkage, AvailableExternallyLinkage, LinkOnceAnyLinkage, LinkOnceODRLinkage, WeakAnyLinkage, WeakODRLinkage, AppendingLinkage, InternalLinkage, PrivateLinkage, LinkerPrivateLinkage, DLLImportLinkage, DLLExportLinkage, ExternalWeakLinkage, CommonLinkage};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static LinkageTypes swigToEnum(int n2) {
            if (n2 < swigValues.length && n2 >= 0 && LinkageTypes.swigValues[n2].swigValue == n2) {
                return swigValues[n2];
            }
            for (int i2 = 0; i2 < swigValues.length; ++i2) {
                if (LinkageTypes.swigValues[i2].swigValue != n2) continue;
                return swigValues[i2];
            }
            throw new IllegalArgumentException("No enum " + LinkageTypes.class + " with value " + n2);
        }

        private LinkageTypes(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private LinkageTypes(String string, int n2) {
            this.swigName = string;
            this.swigValue = n2;
            swigNext = n2 + 1;
        }

        private LinkageTypes(String string, LinkageTypes linkageTypes) {
            this.swigName = string;
            this.swigValue = linkageTypes.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

