/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.GlobalVariable;
import llvm.ImmutablePass;
import llvm.IntegerType;
import llvm.LLVMContext;
import llvm.Module;
import llvm.SWIGTYPE_p_p_llvm__Value;
import llvm.StringRef;
import llvm.StructLayout;
import llvm.StructType;
import llvm.Type;
import llvm.llvmJNI;

public class TargetData
extends ImmutablePass {
    private long swigCPtr;

    protected TargetData(long l2, boolean bl2) {
        super(llvmJNI.SWIGTargetDataUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(TargetData targetData) {
        return targetData == null ? 0L : targetData.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_TargetData(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public TargetData() {
        this(llvmJNI.new_TargetData__SWIG_0(), true);
    }

    public TargetData(StringRef stringRef) {
        this(llvmJNI.new_TargetData__SWIG_1(StringRef.getCPtr(stringRef), stringRef), true);
    }

    public TargetData(Module module) {
        this(llvmJNI.new_TargetData__SWIG_2(Module.getCPtr(module), module), true);
    }

    public TargetData(TargetData targetData) {
        this(llvmJNI.new_TargetData__SWIG_3(TargetData.getCPtr(targetData), targetData), true);
    }

    public void init(StringRef stringRef) {
        llvmJNI.TargetData_init(this.swigCPtr, this, StringRef.getCPtr(stringRef), stringRef);
    }

    public boolean isLittleEndian() {
        return llvmJNI.TargetData_isLittleEndian(this.swigCPtr, this);
    }

    public boolean isBigEndian() {
        return llvmJNI.TargetData_isBigEndian(this.swigCPtr, this);
    }

    public String getStringRepresentation() {
        return llvmJNI.TargetData_getStringRepresentation(this.swigCPtr, this);
    }

    public boolean isLegalInteger(long l2) {
        return llvmJNI.TargetData_isLegalInteger(this.swigCPtr, this, l2);
    }

    public boolean isIllegalInteger(long l2) {
        return llvmJNI.TargetData_isIllegalInteger(this.swigCPtr, this, l2);
    }

    public short getPointerABIAlignment() {
        return llvmJNI.TargetData_getPointerABIAlignment(this.swigCPtr, this);
    }

    public short getPointerPrefAlignment() {
        return llvmJNI.TargetData_getPointerPrefAlignment(this.swigCPtr, this);
    }

    public short getPointerSize() {
        return llvmJNI.TargetData_getPointerSize(this.swigCPtr, this);
    }

    public short getPointerSizeInBits() {
        return llvmJNI.TargetData_getPointerSizeInBits(this.swigCPtr, this);
    }

    public BigInteger getTypeSizeInBits(Type type) {
        return llvmJNI.TargetData_getTypeSizeInBits(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public BigInteger getTypeStoreSize(Type type) {
        return llvmJNI.TargetData_getTypeStoreSize(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public BigInteger getTypeStoreSizeInBits(Type type) {
        return llvmJNI.TargetData_getTypeStoreSizeInBits(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public BigInteger getTypeAllocSize(Type type) {
        return llvmJNI.TargetData_getTypeAllocSize(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public BigInteger getTypeAllocSizeInBits(Type type) {
        return llvmJNI.TargetData_getTypeAllocSizeInBits(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public short getABITypeAlignment(Type type) {
        return llvmJNI.TargetData_getABITypeAlignment(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public short getABIIntegerTypeAlignment(long l2) {
        return llvmJNI.TargetData_getABIIntegerTypeAlignment(this.swigCPtr, this, l2);
    }

    public short getCallFrameTypeAlignment(Type type) {
        return llvmJNI.TargetData_getCallFrameTypeAlignment(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public short getPrefTypeAlignment(Type type) {
        return llvmJNI.TargetData_getPrefTypeAlignment(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public short getPreferredTypeAlignmentShift(Type type) {
        return llvmJNI.TargetData_getPreferredTypeAlignmentShift(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public IntegerType getIntPtrType(LLVMContext lLVMContext) {
        long l2 = llvmJNI.TargetData_getIntPtrType(this.swigCPtr, this, LLVMContext.getCPtr(lLVMContext), lLVMContext);
        return l2 == 0L ? null : new IntegerType(l2, false);
    }

    public BigInteger getIndexedOffset(Type type, SWIGTYPE_p_p_llvm__Value sWIGTYPE_p_p_llvm__Value, long l2) {
        return llvmJNI.TargetData_getIndexedOffset(this.swigCPtr, this, Type.getCPtr(type), type, SWIGTYPE_p_p_llvm__Value.getCPtr(sWIGTYPE_p_p_llvm__Value), l2);
    }

    public StructLayout getStructLayout(StructType structType) {
        long l2 = llvmJNI.TargetData_getStructLayout(this.swigCPtr, this, StructType.getCPtr(structType), structType);
        return l2 == 0L ? null : new StructLayout(l2, false);
    }

    public void InvalidateStructLayoutInfo(StructType structType) {
        llvmJNI.TargetData_InvalidateStructLayoutInfo(this.swigCPtr, this, StructType.getCPtr(structType), structType);
    }

    public long getPreferredAlignment(GlobalVariable globalVariable) {
        return llvmJNI.TargetData_getPreferredAlignment(this.swigCPtr, this, GlobalVariable.getCPtr(globalVariable), globalVariable);
    }

    public long getPreferredAlignmentLog(GlobalVariable globalVariable) {
        return llvmJNI.TargetData_getPreferredAlignmentLog(this.swigCPtr, this, GlobalVariable.getCPtr(globalVariable), globalVariable);
    }

    public static void setID(char c2) {
        llvmJNI.TargetData_ID_set(c2);
    }

    public static char getID() {
        return llvmJNI.TargetData_ID_get();
    }
}

