/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Unknown
extends Attribute {
    private byte[] bytes;
    private String name;
    private static Map unknown_attributes = new HashMap();

    static Unknown[] getUnknownAttributes() {
        Unknown[] unknowns = new Unknown[unknown_attributes.size()];
        Iterator entries = unknown_attributes.values().iterator();
        int i2 = 0;
        while (entries.hasNext()) {
            unknowns[i2] = (Unknown)entries.next();
            ++i2;
        }
        unknown_attributes.clear();
        return unknowns;
    }

    public Unknown(Unknown c2) {
        this(c2.getNameIndex(), c2.getLength(), c2.getBytes(), c2.getConstantPool());
    }

    public Unknown(int name_index, int length, byte[] bytes, ConstantPool constant_pool) {
        super((byte)-1, name_index, length, constant_pool);
        this.bytes = bytes;
        this.name = ((ConstantUtf8)constant_pool.getConstant(name_index, (byte)1)).getBytes();
        unknown_attributes.put(this.name, this);
    }

    Unknown(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (byte[])null, constant_pool);
        if (length > 0) {
            this.bytes = new byte[length];
            file.readFully(this.bytes);
        }
    }

    public void accept(Visitor v2) {
        v2.visitUnknown(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (this.length > 0) {
            file.write(this.bytes, 0, this.length);
        }
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final String getName() {
        return this.name;
    }

    public final void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public final String toString() {
        String hex;
        if (this.length == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (this.length > 10) {
            byte[] tmp = new byte[10];
            System.arraycopy(this.bytes, 0, tmp, 0, 10);
            hex = Utility.toHexString(tmp) + "... (truncated)";
        } else {
            hex = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + hex + ")";
    }

    public Attribute copy(ConstantPool _constant_pool) {
        Unknown c2 = (Unknown)this.clone();
        if (this.bytes != null) {
            c2.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, c2.bytes, 0, this.bytes.length);
        }
        c2.constant_pool = _constant_pool;
        return c2;
    }
}

