/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.Visitor;

public class DCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private double value;

    DCONST() {
    }

    public DCONST(double f2) {
        super((short)14, (short)1);
        if (f2 == 0.0) {
            this.opcode = (short)14;
        } else if (f2 == 1.0) {
            this.opcode = (short)15;
        } else {
            throw new ClassGenException("DCONST can be used only for 0.0 and 1.0: " + f2);
        }
        this.value = f2;
    }

    public Number getValue() {
        return new Double(this.value);
    }

    public Type getType(ConstantPoolGen cp) {
        return Type.DOUBLE;
    }

    public void accept(Visitor v2) {
        v2.visitPushInstruction(this);
        v2.visitStackProducer(this);
        v2.visitTypedInstruction(this);
        v2.visitConstantPushInstruction(this);
        v2.visitDCONST(this);
    }
}

