/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class SIPUSH
extends Instruction
implements ConstantPushInstruction {
    private short b;

    SIPUSH() {
    }

    public SIPUSH(short b3) {
        super((short)17, (short)3);
        this.b = b3;
    }

    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        out.writeShort(this.b);
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.b;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.length = (short)3;
        this.b = bytes.readShort();
    }

    public Number getValue() {
        return new Integer(this.b);
    }

    public Type getType(ConstantPoolGen cp) {
        return Type.SHORT;
    }

    public void accept(Visitor v2) {
        v2.visitPushInstruction(this);
        v2.visitStackProducer(this);
        v2.visitTypedInstruction(this);
        v2.visitConstantPushInstruction(this);
        v2.visitSIPUSH(this);
    }
}

