/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.AllocationInstruction;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELifier;

class BCELFactory
extends EmptyVisitor {
    private MethodGen _mg;
    private PrintWriter _out;
    private ConstantPoolGen _cp;
    private Map branch_map = new HashMap();
    private List branches = new ArrayList();

    BCELFactory(MethodGen mg, PrintWriter out) {
        this._mg = mg;
        this._cp = mg.getConstantPool();
        this._out = out;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            for (InstructionHandle ih = this._mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i2 = ih.getInstruction();
                if (i2 instanceof BranchInstruction) {
                    this.branch_map.put(i2, ih);
                }
                if (ih.hasTargeters()) {
                    if (i2 instanceof BranchInstruction) {
                        this._out.println("    InstructionHandle ih_" + ih.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + ih.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (this.visitInstruction(i2)) continue;
                i2.accept(this);
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction i2) {
        short opcode = i2.getOpcode();
        if (InstructionConstants.INSTRUCTIONS[opcode] != null && !(i2 instanceof ConstantPushInstruction) && !(i2 instanceof ReturnInstruction)) {
            this._out.println("il.append(InstructionConstants." + i2.getName().toUpperCase(Locale.ENGLISH) + ");");
            return true;
        }
        return false;
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction i2) {
        short opcode = i2.getOpcode();
        Type type = i2.getType(this._cp);
        if (opcode == 132) {
            this._out.println("il.append(new IINC(" + i2.getIndex() + ", " + ((IINC)i2).getIncrement() + "));");
        } else {
            String kind = opcode < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + kind + "(" + BCELifier.printType(type) + ", " + i2.getIndex() + "));");
        }
    }

    public void visitArrayInstruction(ArrayInstruction i2) {
        short opcode = i2.getOpcode();
        Type type = i2.getType(this._cp);
        String kind = opcode < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + kind + "(" + BCELifier.printType(type) + "));");
    }

    public void visitFieldInstruction(FieldInstruction i2) {
        short opcode = i2.getOpcode();
        String class_name = i2.getClassName(this._cp);
        String field_name = i2.getFieldName(this._cp);
        Type type = i2.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + class_name + "\", \"" + field_name + "\", " + BCELifier.printType(type) + ", " + "Constants." + Constants.OPCODE_NAMES[opcode].toUpperCase(Locale.ENGLISH) + "));");
    }

    public void visitInvokeInstruction(InvokeInstruction i2) {
        short opcode = i2.getOpcode();
        String class_name = i2.getClassName(this._cp);
        String method_name = i2.getMethodName(this._cp);
        Type type = i2.getReturnType(this._cp);
        Type[] arg_types = i2.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + class_name + "\", \"" + method_name + "\", " + BCELifier.printType(type) + ", " + BCELifier.printArgumentTypes(arg_types) + ", " + "Constants." + Constants.OPCODE_NAMES[opcode].toUpperCase(Locale.ENGLISH) + "));");
    }

    public void visitAllocationInstruction(AllocationInstruction i2) {
        Type type = i2 instanceof CPInstruction ? ((CPInstruction)((Object)i2)).getType(this._cp) : ((NEWARRAY)i2).getType();
        short opcode = ((Instruction)((Object)i2)).getOpcode();
        short dim = 1;
        switch (opcode) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type).getClassName() + "\"));");
                break;
            }
            case 197: {
                dim = ((MULTIANEWARRAY)i2).getDimensions();
            }
            case 188: 
            case 189: {
                if (type instanceof ArrayType) {
                    type = ((ArrayType)type).getBasicType();
                }
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type) + ", (short) " + dim + "));");
                break;
            }
            default: {
                throw new RuntimeException("Oops: " + opcode);
            }
        }
    }

    private void createConstant(Object value) {
        String embed = value.toString();
        if (value instanceof String) {
            embed = '\"' + Utility.convertString(value.toString()) + '\"';
        } else if (value instanceof Character) {
            embed = "(char)0x" + Integer.toHexString(((Character)value).charValue());
        }
        this._out.println("il.append(new PUSH(_cp, " + embed + "));");
    }

    public void visitLDC(LDC i2) {
        this.createConstant(i2.getValue(this._cp));
    }

    public void visitLDC2_W(LDC2_W i2) {
        this.createConstant(i2.getValue(this._cp));
    }

    public void visitConstantPushInstruction(ConstantPushInstruction i2) {
        this.createConstant(i2.getValue());
    }

    public void visitINSTANCEOF(INSTANCEOF i2) {
        Type type = i2.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type) + ")));");
    }

    public void visitCHECKCAST(CHECKCAST i2) {
        Type type = i2.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type) + "));");
    }

    public void visitReturnInstruction(ReturnInstruction i2) {
        Type type = i2.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type) + "));");
    }

    public void visitBranchInstruction(BranchInstruction bi2) {
        BranchHandle bh2 = (BranchHandle)this.branch_map.get(bi2);
        int pos = bh2.getPosition();
        String name = bi2.getName() + "_" + pos;
        if (bi2 instanceof Select) {
            int i2;
            Select s2 = (Select)bi2;
            this.branches.add(bi2);
            StringBuffer args = new StringBuffer("new int[] { ");
            int[] matchs = s2.getMatchs();
            for (i2 = 0; i2 < matchs.length; ++i2) {
                args.append(matchs[i2]);
                if (i2 >= matchs.length - 1) continue;
                args.append(", ");
            }
            args.append(" }");
            this._out.print("Select " + name + " = new " + bi2.getName().toUpperCase(Locale.ENGLISH) + "(" + args + ", new InstructionHandle[] { ");
            for (i2 = 0; i2 < matchs.length; ++i2) {
                this._out.print("null");
                if (i2 >= matchs.length - 1) continue;
                this._out.print(", ");
            }
            this._out.println(" }, null);");
        } else {
            String target;
            int t_pos = bh2.getTarget().getPosition();
            if (pos > t_pos) {
                target = "ih_" + t_pos;
            } else {
                this.branches.add(bi2);
                target = "null";
            }
            this._out.println("    BranchInstruction " + name + " = _factory.createBranchInstruction(" + "Constants." + bi2.getName().toUpperCase(Locale.ENGLISH) + ", " + target + ");");
        }
        if (bh2.hasTargeters()) {
            this._out.println("    ih_" + pos + " = il.append(" + name + ");");
        } else {
            this._out.println("    il.append(" + name + ");");
        }
    }

    public void visitRET(RET i2) {
        this._out.println("il.append(new RET(" + i2.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        Iterator i2 = this.branches.iterator();
        while (i2.hasNext()) {
            BranchInstruction bi2 = (BranchInstruction)i2.next();
            BranchHandle bh2 = (BranchHandle)this.branch_map.get(bi2);
            int pos = bh2.getPosition();
            String name = bi2.getName() + "_" + pos;
            int t_pos = bh2.getTarget().getPosition();
            this._out.println("    " + name + ".setTarget(ih_" + t_pos + ");");
            if (!(bi2 instanceof Select)) continue;
            InstructionHandle[] ihs = ((Select)bi2).getTargets();
            for (int j2 = 0; j2 < ihs.length; ++j2) {
                t_pos = ihs[j2].getPosition();
                this._out.println("    " + name + ".setTarget(" + j2 + ", ih_" + t_pos + ");");
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] handlers = this._mg.getExceptionHandlers();
        for (int i2 = 0; i2 < handlers.length; ++i2) {
            CodeExceptionGen h2 = handlers[i2];
            String type = h2.getCatchType() == null ? "null" : BCELifier.printType(h2.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + h2.getStartPC().getPosition() + ", " + "ih_" + h2.getEndPC().getPosition() + ", " + "ih_" + h2.getHandlerPC().getPosition() + ", " + type + ");");
        }
    }
}

