/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BASTORE;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DASTORE;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.DUP2_X1;
import org.apache.bcel.generic.DUP2_X2;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FASTORE;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LASTORE;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SASTORE;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class ExecutionVisitor
extends EmptyVisitor
implements Visitor {
    private Frame frame = null;
    private ConstantPoolGen cpg = null;

    private OperandStack stack() {
        return this.frame.getStack();
    }

    private LocalVariables locals() {
        return this.frame.getLocals();
    }

    public void setConstantPoolGen(ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void setFrame(Frame f2) {
        this.frame = f2;
    }

    public void visitAALOAD(AALOAD o2) {
        this.stack().pop();
        Type t2 = this.stack().pop();
        if (t2 == Type.NULL) {
            this.stack().push(Type.NULL);
        } else {
            ArrayType at2 = (ArrayType)t2;
            this.stack().push(at2.getElementType());
        }
    }

    public void visitAASTORE(AASTORE o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitACONST_NULL(ACONST_NULL o2) {
        this.stack().push(Type.NULL);
    }

    public void visitALOAD(ALOAD o2) {
        this.stack().push(this.locals().get(o2.getIndex()));
    }

    public void visitANEWARRAY(ANEWARRAY o2) {
        this.stack().pop();
        this.stack().push(new ArrayType(o2.getType(this.cpg), 1));
    }

    public void visitARETURN(ARETURN o2) {
        this.stack().pop();
    }

    public void visitARRAYLENGTH(ARRAYLENGTH o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitASTORE(ASTORE o2) {
        this.locals().set(o2.getIndex(), this.stack().pop());
    }

    public void visitATHROW(ATHROW o2) {
        Type t2 = this.stack().pop();
        this.stack().clear();
        if (t2.equals(Type.NULL)) {
            this.stack().push(Type.getType("Ljava/lang/NullPointerException;"));
        } else {
            this.stack().push(t2);
        }
    }

    public void visitBALOAD(BALOAD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitBASTORE(BASTORE o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitBIPUSH(BIPUSH o2) {
        this.stack().push(Type.INT);
    }

    public void visitCALOAD(CALOAD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitCASTORE(CASTORE o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitCHECKCAST(CHECKCAST o2) {
        this.stack().pop();
        this.stack().push(o2.getType(this.cpg));
    }

    public void visitD2F(D2F o2) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitD2I(D2I o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitD2L(D2L o2) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitDADD(DADD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDALOAD(DALOAD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDASTORE(DASTORE o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitDCMPG(DCMPG o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitDCMPL(DCMPL o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitDCONST(DCONST o2) {
        this.stack().push(Type.DOUBLE);
    }

    public void visitDDIV(DDIV o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDLOAD(DLOAD o2) {
        this.stack().push(Type.DOUBLE);
    }

    public void visitDMUL(DMUL o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDNEG(DNEG o2) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDREM(DREM o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDRETURN(DRETURN o2) {
        this.stack().pop();
    }

    public void visitDSTORE(DSTORE o2) {
        this.locals().set(o2.getIndex(), this.stack().pop());
        this.locals().set(o2.getIndex() + 1, Type.UNKNOWN);
    }

    public void visitDSUB(DSUB o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDUP(DUP o2) {
        Type t2 = this.stack().pop();
        this.stack().push(t2);
        this.stack().push(t2);
    }

    public void visitDUP_X1(DUP_X1 o2) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        this.stack().push(w1);
        this.stack().push(w2);
        this.stack().push(w1);
    }

    public void visitDUP_X2(DUP_X2 o2) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        if (w2.getSize() == 2) {
            this.stack().push(w1);
            this.stack().push(w2);
            this.stack().push(w1);
        } else {
            Type w3 = this.stack().pop();
            this.stack().push(w1);
            this.stack().push(w3);
            this.stack().push(w2);
            this.stack().push(w1);
        }
    }

    public void visitDUP2(DUP2 o2) {
        Type t2 = this.stack().pop();
        if (t2.getSize() == 2) {
            this.stack().push(t2);
            this.stack().push(t2);
        } else {
            Type u2 = this.stack().pop();
            this.stack().push(u2);
            this.stack().push(t2);
            this.stack().push(u2);
            this.stack().push(t2);
        }
    }

    public void visitDUP2_X1(DUP2_X1 o2) {
        Type t2 = this.stack().pop();
        if (t2.getSize() == 2) {
            Type u2 = this.stack().pop();
            this.stack().push(t2);
            this.stack().push(u2);
            this.stack().push(t2);
        } else {
            Type u3 = this.stack().pop();
            Type v2 = this.stack().pop();
            this.stack().push(u3);
            this.stack().push(t2);
            this.stack().push(v2);
            this.stack().push(u3);
            this.stack().push(t2);
        }
    }

    public void visitDUP2_X2(DUP2_X2 o2) {
        Type t2 = this.stack().pop();
        if (t2.getSize() == 2) {
            Type u2 = this.stack().pop();
            if (u2.getSize() == 2) {
                this.stack().push(t2);
                this.stack().push(u2);
                this.stack().push(t2);
            } else {
                Type v2 = this.stack().pop();
                this.stack().push(t2);
                this.stack().push(v2);
                this.stack().push(u2);
                this.stack().push(t2);
            }
        } else {
            Type u3 = this.stack().pop();
            Type v3 = this.stack().pop();
            if (v3.getSize() == 2) {
                this.stack().push(u3);
                this.stack().push(t2);
                this.stack().push(v3);
                this.stack().push(u3);
                this.stack().push(t2);
            } else {
                Type w2 = this.stack().pop();
                this.stack().push(u3);
                this.stack().push(t2);
                this.stack().push(w2);
                this.stack().push(v3);
                this.stack().push(u3);
                this.stack().push(t2);
            }
        }
    }

    public void visitF2D(F2D o2) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitF2I(F2I o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitF2L(F2L o2) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitFADD(FADD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFALOAD(FALOAD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFASTORE(FASTORE o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitFCMPG(FCMPG o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitFCMPL(FCMPL o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitFCONST(FCONST o2) {
        this.stack().push(Type.FLOAT);
    }

    public void visitFDIV(FDIV o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFLOAD(FLOAD o2) {
        this.stack().push(Type.FLOAT);
    }

    public void visitFMUL(FMUL o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFNEG(FNEG o2) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFREM(FREM o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFRETURN(FRETURN o2) {
        this.stack().pop();
    }

    public void visitFSTORE(FSTORE o2) {
        this.locals().set(o2.getIndex(), this.stack().pop());
    }

    public void visitFSUB(FSUB o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitGETFIELD(GETFIELD o2) {
        this.stack().pop();
        Type t2 = o2.getFieldType(this.cpg);
        if (t2.equals(Type.BOOLEAN) || t2.equals(Type.CHAR) || t2.equals(Type.BYTE) || t2.equals(Type.SHORT)) {
            t2 = Type.INT;
        }
        this.stack().push(t2);
    }

    public void visitGETSTATIC(GETSTATIC o2) {
        Type t2 = o2.getFieldType(this.cpg);
        if (t2.equals(Type.BOOLEAN) || t2.equals(Type.CHAR) || t2.equals(Type.BYTE) || t2.equals(Type.SHORT)) {
            t2 = Type.INT;
        }
        this.stack().push(t2);
    }

    public void visitGOTO(GOTO o2) {
    }

    public void visitGOTO_W(GOTO_W o2) {
    }

    public void visitI2B(I2B o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitI2C(I2C o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitI2D(I2D o2) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitI2F(I2F o2) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitI2L(I2L o2) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitI2S(I2S o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIADD(IADD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIALOAD(IALOAD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIAND(IAND o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIASTORE(IASTORE o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitICONST(ICONST o2) {
        this.stack().push(Type.INT);
    }

    public void visitIDIV(IDIV o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIF_ACMPEQ(IF_ACMPEQ o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ACMPNE(IF_ACMPNE o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPEQ(IF_ICMPEQ o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPGE(IF_ICMPGE o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPGT(IF_ICMPGT o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPLE(IF_ICMPLE o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPLT(IF_ICMPLT o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPNE(IF_ICMPNE o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIFEQ(IFEQ o2) {
        this.stack().pop();
    }

    public void visitIFGE(IFGE o2) {
        this.stack().pop();
    }

    public void visitIFGT(IFGT o2) {
        this.stack().pop();
    }

    public void visitIFLE(IFLE o2) {
        this.stack().pop();
    }

    public void visitIFLT(IFLT o2) {
        this.stack().pop();
    }

    public void visitIFNE(IFNE o2) {
        this.stack().pop();
    }

    public void visitIFNONNULL(IFNONNULL o2) {
        this.stack().pop();
    }

    public void visitIFNULL(IFNULL o2) {
        this.stack().pop();
    }

    public void visitIINC(IINC o2) {
    }

    public void visitILOAD(ILOAD o2) {
        this.stack().push(Type.INT);
    }

    public void visitIMUL(IMUL o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitINEG(INEG o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitINSTANCEOF(INSTANCEOF o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE o2) {
        this.stack().pop();
        for (int i2 = 0; i2 < o2.getArgumentTypes(this.cpg).length; ++i2) {
            this.stack().pop();
        }
        if (o2.getReturnType(this.cpg) != Type.VOID) {
            Type t2 = o2.getReturnType(this.cpg);
            if (t2.equals(Type.BOOLEAN) || t2.equals(Type.CHAR) || t2.equals(Type.BYTE) || t2.equals(Type.SHORT)) {
                t2 = Type.INT;
            }
            this.stack().push(t2);
        }
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL o2) {
        if (o2.getMethodName(this.cpg).equals("<init>")) {
            UninitializedObjectType t2 = (UninitializedObjectType)this.stack().peek(o2.getArgumentTypes(this.cpg).length);
            if (t2 == Frame._this) {
                Frame._this = null;
            }
            this.stack().initializeObject(t2);
            this.locals().initializeObject(t2);
        }
        this.stack().pop();
        for (int i2 = 0; i2 < o2.getArgumentTypes(this.cpg).length; ++i2) {
            this.stack().pop();
        }
        if (o2.getReturnType(this.cpg) != Type.VOID) {
            Type t3 = o2.getReturnType(this.cpg);
            if (t3.equals(Type.BOOLEAN) || t3.equals(Type.CHAR) || t3.equals(Type.BYTE) || t3.equals(Type.SHORT)) {
                t3 = Type.INT;
            }
            this.stack().push(t3);
        }
    }

    public void visitINVOKESTATIC(INVOKESTATIC o2) {
        for (int i2 = 0; i2 < o2.getArgumentTypes(this.cpg).length; ++i2) {
            this.stack().pop();
        }
        if (o2.getReturnType(this.cpg) != Type.VOID) {
            Type t2 = o2.getReturnType(this.cpg);
            if (t2.equals(Type.BOOLEAN) || t2.equals(Type.CHAR) || t2.equals(Type.BYTE) || t2.equals(Type.SHORT)) {
                t2 = Type.INT;
            }
            this.stack().push(t2);
        }
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL o2) {
        this.stack().pop();
        for (int i2 = 0; i2 < o2.getArgumentTypes(this.cpg).length; ++i2) {
            this.stack().pop();
        }
        if (o2.getReturnType(this.cpg) != Type.VOID) {
            Type t2 = o2.getReturnType(this.cpg);
            if (t2.equals(Type.BOOLEAN) || t2.equals(Type.CHAR) || t2.equals(Type.BYTE) || t2.equals(Type.SHORT)) {
                t2 = Type.INT;
            }
            this.stack().push(t2);
        }
    }

    public void visitIOR(IOR o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIREM(IREM o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIRETURN(IRETURN o2) {
        this.stack().pop();
    }

    public void visitISHL(ISHL o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitISHR(ISHR o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitISTORE(ISTORE o2) {
        this.locals().set(o2.getIndex(), this.stack().pop());
    }

    public void visitISUB(ISUB o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIUSHR(IUSHR o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIXOR(IXOR o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitJSR(JSR o2) {
        this.stack().push(new ReturnaddressType(o2.physicalSuccessor()));
    }

    public void visitJSR_W(JSR_W o2) {
        this.stack().push(new ReturnaddressType(o2.physicalSuccessor()));
    }

    public void visitL2D(L2D o2) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitL2F(L2F o2) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitL2I(L2I o2) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitLADD(LADD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLALOAD(LALOAD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLAND(LAND o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLASTORE(LASTORE o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitLCMP(LCMP o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitLCONST(LCONST o2) {
        this.stack().push(Type.LONG);
    }

    public void visitLDC(LDC o2) {
        Constant c2 = this.cpg.getConstant(o2.getIndex());
        if (c2 instanceof ConstantInteger) {
            this.stack().push(Type.INT);
        }
        if (c2 instanceof ConstantFloat) {
            this.stack().push(Type.FLOAT);
        }
        if (c2 instanceof ConstantString) {
            this.stack().push(Type.STRING);
        }
    }

    public void visitLDC_W(LDC_W o2) {
        Constant c2 = this.cpg.getConstant(o2.getIndex());
        if (c2 instanceof ConstantInteger) {
            this.stack().push(Type.INT);
        }
        if (c2 instanceof ConstantFloat) {
            this.stack().push(Type.FLOAT);
        }
        if (c2 instanceof ConstantString) {
            this.stack().push(Type.STRING);
        }
    }

    public void visitLDC2_W(LDC2_W o2) {
        Constant c2 = this.cpg.getConstant(o2.getIndex());
        if (c2 instanceof ConstantLong) {
            this.stack().push(Type.LONG);
        }
        if (c2 instanceof ConstantDouble) {
            this.stack().push(Type.DOUBLE);
        }
    }

    public void visitLDIV(LDIV o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLLOAD(LLOAD o2) {
        this.stack().push(this.locals().get(o2.getIndex()));
    }

    public void visitLMUL(LMUL o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLNEG(LNEG o2) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLOOKUPSWITCH(LOOKUPSWITCH o2) {
        this.stack().pop();
    }

    public void visitLOR(LOR o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLREM(LREM o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLRETURN(LRETURN o2) {
        this.stack().pop();
    }

    public void visitLSHL(LSHL o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLSHR(LSHR o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLSTORE(LSTORE o2) {
        this.locals().set(o2.getIndex(), this.stack().pop());
        this.locals().set(o2.getIndex() + 1, Type.UNKNOWN);
    }

    public void visitLSUB(LSUB o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLUSHR(LUSHR o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLXOR(LXOR o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitMONITORENTER(MONITORENTER o2) {
        this.stack().pop();
    }

    public void visitMONITOREXIT(MONITOREXIT o2) {
        this.stack().pop();
    }

    public void visitMULTIANEWARRAY(MULTIANEWARRAY o2) {
        for (int i2 = 0; i2 < o2.getDimensions(); ++i2) {
            this.stack().pop();
        }
        this.stack().push(o2.getType(this.cpg));
    }

    public void visitNEW(NEW o2) {
        this.stack().push(new UninitializedObjectType((ObjectType)o2.getType(this.cpg)));
    }

    public void visitNEWARRAY(NEWARRAY o2) {
        this.stack().pop();
        this.stack().push(o2.getType());
    }

    public void visitNOP(NOP o2) {
    }

    public void visitPOP(POP o2) {
        this.stack().pop();
    }

    public void visitPOP2(POP2 o2) {
        Type t2 = this.stack().pop();
        if (t2.getSize() == 1) {
            this.stack().pop();
        }
    }

    public void visitPUTFIELD(PUTFIELD o2) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitPUTSTATIC(PUTSTATIC o2) {
        this.stack().pop();
    }

    public void visitRET(RET o2) {
    }

    public void visitRETURN(RETURN o2) {
    }

    public void visitSALOAD(SALOAD o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitSASTORE(SASTORE o2) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitSIPUSH(SIPUSH o2) {
        this.stack().push(Type.INT);
    }

    public void visitSWAP(SWAP o2) {
        Type t2 = this.stack().pop();
        Type u2 = this.stack().pop();
        this.stack().push(t2);
        this.stack().push(u2);
    }

    public void visitTABLESWITCH(TABLESWITCH o2) {
        this.stack().pop();
    }
}

