/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.dex.code.Dop;
import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.InsnFormat;
import com.android.dx.dex.code.LocalSnapshot;
import com.android.dx.dex.code.LocalStart;
import com.android.dx.dex.code.TargetInsn;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.RegisterSpecSet;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstMemberRef;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.CstUtf8;
import com.android.dx.rop.type.Type;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutputFinisher {
    private final int unreservedRegCount;
    private ArrayList<DalvInsn> insns;
    private boolean hasAnyPositionInfo;
    private boolean hasAnyLocalInfo;
    private int reservedCount;

    public OutputFinisher(int initialCapacity, int regCount) {
        this.unreservedRegCount = regCount;
        this.insns = new ArrayList(initialCapacity);
        this.reservedCount = -1;
        this.hasAnyPositionInfo = false;
        this.hasAnyLocalInfo = false;
    }

    public boolean hasAnyPositionInfo() {
        return this.hasAnyPositionInfo;
    }

    public boolean hasAnyLocalInfo() {
        return this.hasAnyLocalInfo;
    }

    private static boolean hasLocalInfo(DalvInsn insn) {
        RegisterSpec spec;
        if (insn instanceof LocalSnapshot) {
            RegisterSpecSet specs = ((LocalSnapshot)insn).getLocals();
            int size = specs.size();
            for (int i = 0; i < size; ++i) {
                if (!OutputFinisher.hasLocalInfo(specs.get(i))) continue;
                return true;
            }
        } else if (insn instanceof LocalStart && OutputFinisher.hasLocalInfo(spec = ((LocalStart)insn).getLocal())) {
            return true;
        }
        return false;
    }

    private static boolean hasLocalInfo(RegisterSpec spec) {
        return spec != null && spec.getLocalItem().getName() != null;
    }

    public HashSet<Constant> getAllConstants() {
        HashSet<Constant> result = new HashSet<Constant>(20);
        for (DalvInsn insn : this.insns) {
            OutputFinisher.addConstants(result, insn);
        }
        return result;
    }

    private static void addConstants(HashSet<Constant> result, DalvInsn insn) {
        if (insn instanceof CstInsn) {
            Constant cst = ((CstInsn)insn).getConstant();
            result.add(cst);
        } else if (insn instanceof LocalSnapshot) {
            RegisterSpecSet specs = ((LocalSnapshot)insn).getLocals();
            int size = specs.size();
            for (int i = 0; i < size; ++i) {
                OutputFinisher.addConstants(result, specs.get(i));
            }
        } else if (insn instanceof LocalStart) {
            RegisterSpec spec = ((LocalStart)insn).getLocal();
            OutputFinisher.addConstants(result, spec);
        }
    }

    private static void addConstants(HashSet<Constant> result, RegisterSpec spec) {
        if (spec == null) {
            return;
        }
        LocalItem local = spec.getLocalItem();
        CstUtf8 name = local.getName();
        CstUtf8 signature = local.getSignature();
        Type type = spec.getType();
        if (type != Type.KNOWN_NULL) {
            result.add(CstType.intern(type));
        }
        if (name != null) {
            result.add(name);
        }
        if (signature != null) {
            result.add(signature);
        }
    }

    public void add(DalvInsn insn) {
        this.insns.add(insn);
        this.updateInfo(insn);
    }

    public void insert(int at, DalvInsn insn) {
        this.insns.add(at, insn);
        this.updateInfo(insn);
    }

    private void updateInfo(DalvInsn insn) {
        SourcePosition pos;
        if (!this.hasAnyPositionInfo && (pos = insn.getPosition()).getLine() >= 0) {
            this.hasAnyPositionInfo = true;
        }
        if (!this.hasAnyLocalInfo && OutputFinisher.hasLocalInfo(insn)) {
            this.hasAnyLocalInfo = true;
        }
    }

    public void reverseBranch(int which, CodeAddress newTarget) {
        TargetInsn targetInsn;
        int size = this.insns.size();
        int index = size - which - 1;
        try {
            targetInsn = (TargetInsn)this.insns.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("too few instructions");
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("non-reversible instruction");
        }
        this.insns.set(index, targetInsn.withNewTargetAndReversed(newTarget));
    }

    public void assignIndices(DalvCode.AssignIndicesCallback callback) {
        for (DalvInsn insn : this.insns) {
            if (!(insn instanceof CstInsn)) continue;
            OutputFinisher.assignIndices((CstInsn)insn, callback);
        }
    }

    private static void assignIndices(CstInsn insn, DalvCode.AssignIndicesCallback callback) {
        CstMemberRef member;
        CstType definer;
        Constant cst = insn.getConstant();
        int index = callback.getIndex(cst);
        if (index >= 0) {
            insn.setIndex(index);
        }
        if (cst instanceof CstMemberRef && (index = callback.getIndex(definer = (member = (CstMemberRef)cst).getDefiningClass())) >= 0) {
            insn.setClassIndex(index);
        }
    }

    public DalvInsnList finishProcessingAndGetList() {
        if (this.reservedCount >= 0) {
            throw new UnsupportedOperationException("already processed");
        }
        InsnFormat[] formats = this.makeFormatsArray();
        this.reserveRegisters(formats);
        this.massageInstructions(formats);
        this.assignAddressesAndFixBranches();
        return DalvInsnList.makeImmutable(this.insns, this.reservedCount + this.unreservedRegCount);
    }

    private InsnFormat[] makeFormatsArray() {
        int size = this.insns.size();
        InsnFormat[] result = new InsnFormat[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.insns.get(i).getOpcode().getFormat();
        }
        return result;
    }

    private void reserveRegisters(InsnFormat[] formats) {
        int newReservedCount;
        int oldReservedCount;
        int n = oldReservedCount = this.reservedCount < 0 ? 0 : this.reservedCount;
        while (oldReservedCount < (newReservedCount = this.calculateReservedCount(formats))) {
            int reservedDifference = newReservedCount - oldReservedCount;
            int size = this.insns.size();
            for (int i = 0; i < size; ++i) {
                DalvInsn insn = this.insns.get(i);
                if (insn instanceof CodeAddress) continue;
                this.insns.set(i, insn.withRegisterOffset(reservedDifference));
            }
            oldReservedCount = newReservedCount;
        }
        this.reservedCount = oldReservedCount;
    }

    private int calculateReservedCount(InsnFormat[] formats) {
        int size = this.insns.size();
        int newReservedCount = this.reservedCount;
        for (int i = 0; i < size; ++i) {
            int reserve;
            InsnFormat originalFormat = formats[i];
            DalvInsn insn = this.insns.get(i);
            InsnFormat newFormat = this.findFormatForInsn(insn, originalFormat);
            if (originalFormat == newFormat) continue;
            if (newFormat == null && (reserve = insn.getMinimumRegisterRequirement()) > newReservedCount) {
                newReservedCount = reserve;
            }
            formats[i] = newFormat;
        }
        return newReservedCount;
    }

    private InsnFormat findFormatForInsn(DalvInsn insn, InsnFormat format) {
        if (format == null) {
            return format;
        }
        if (format.isCompatible(insn)) {
            return format;
        }
        Dop dop = insn.getOpcode();
        int family = dop.getFamily();
        while (!((format = format.nextUp()) == null || format.isCompatible(insn) && Dops.getOrNull(family, format) != null)) {
        }
        return format;
    }

    private void massageInstructions(InsnFormat[] formats) {
        if (this.reservedCount == 0) {
            int size = this.insns.size();
            for (int i = 0; i < size; ++i) {
                InsnFormat format = formats[i];
                DalvInsn insn = this.insns.get(i);
                Dop dop = insn.getOpcode();
                if (format == dop.getFormat()) continue;
                dop = Dops.getOrNull(dop.getFamily(), format);
                this.insns.set(i, insn.withOpcode(dop));
            }
        } else {
            this.insns = this.performExpansion(formats);
        }
    }

    private ArrayList<DalvInsn> performExpansion(InsnFormat[] formats) {
        int size = this.insns.size();
        ArrayList<DalvInsn> result = new ArrayList<DalvInsn>(size * 2);
        for (int i = 0; i < size; ++i) {
            DalvInsn suffix;
            DalvInsn prefix;
            DalvInsn insn = this.insns.get(i);
            Dop dop = insn.getOpcode();
            InsnFormat originalFormat = dop.getFormat();
            InsnFormat currentFormat = formats[i];
            if (currentFormat != null) {
                prefix = null;
                suffix = null;
            } else {
                prefix = insn.hrPrefix();
                suffix = insn.hrSuffix();
                insn = insn.hrVersion();
                originalFormat = insn.getOpcode().getFormat();
                currentFormat = this.findFormatForInsn(insn, originalFormat);
            }
            if (prefix != null) {
                result.add(prefix);
            }
            if (currentFormat != originalFormat) {
                dop = Dops.getOrNull(dop.getFamily(), currentFormat);
                insn = insn.withOpcode(dop);
            }
            result.add(insn);
            if (suffix == null) continue;
            result.add(suffix);
        }
        return result;
    }

    private void assignAddressesAndFixBranches() {
        do {
            this.assignAddresses();
        } while (this.fixBranches());
    }

    private void assignAddresses() {
        int address = 0;
        int size = this.insns.size();
        for (int i = 0; i < size; ++i) {
            DalvInsn insn = this.insns.get(i);
            insn.setAddress(address);
            address += insn.codeSize();
        }
    }

    private boolean fixBranches() {
        int size = this.insns.size();
        boolean anyFixed = false;
        for (int i = 0; i < size; ++i) {
            TargetInsn target;
            Dop dop;
            InsnFormat format;
            DalvInsn insn = this.insns.get(i);
            if (!(insn instanceof TargetInsn) || (format = (dop = insn.getOpcode()).getFormat()).branchFits(target = (TargetInsn)insn)) continue;
            if (dop.getFamily() == 40) {
                InsnFormat newFormat = this.findFormatForInsn(insn, format);
                if (newFormat == null) {
                    throw new UnsupportedOperationException("method too long");
                }
                dop = Dops.getOrNull(dop.getFamily(), newFormat);
                insn = insn.withOpcode(dop);
                this.insns.set(i, insn);
            } else {
                CodeAddress newTarget;
                try {
                    newTarget = (CodeAddress)this.insns.get(i + 1);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new IllegalStateException("unpaired TargetInsn (dangling)");
                }
                catch (ClassCastException ex) {
                    throw new IllegalStateException("unpaired TargetInsn");
                }
                TargetInsn gotoInsn = new TargetInsn(Dops.GOTO, target.getPosition(), RegisterSpecList.EMPTY, target.getTarget());
                this.insns.set(i, gotoInsn);
                this.insns.add(i, target.withNewTargetAndReversed(newTarget));
                ++size;
                ++i;
            }
            anyFixed = true;
        }
        return anyFixed;
    }
}

