/*
 * Decompiled with CFR 0.152.
 */
package jpen.internal;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakChain<E> {
    private Cell<E> headCell;
    private Cell<E> tailCell;

    public synchronized boolean add(E element) {
        Cell<E> newCell = new Cell<E>(element, null);
        if (this.tailCell == null) {
            if (this.headCell != null) {
                throw new AssertionError();
            }
            this.tailCell = newCell;
            this.headCell = this.tailCell;
        } else {
            this.tailCell.nextCell = newCell;
            this.tailCell = newCell;
        }
        return true;
    }

    public synchronized void clear() {
        this.tailCell = null;
        this.headCell = null;
    }

    public synchronized boolean remove(E element) {
        Cell<E> prevCell = null;
        Cell<E> cell = this.headCell;
        if (cell == null) {
            return false;
        }
        do {
            Object cellElement;
            if ((cellElement = cell.get()) == null) {
                this.removeCell(cell, prevCell);
                continue;
            }
            if (cellElement == element) {
                this.removeCell(cell, prevCell);
                return true;
            }
            prevCell = cell;
        } while ((cell = cell.nextCell) != null);
        return false;
    }

    private void removeCell(Cell<E> cell, Cell<E> prevCell) {
        if (prevCell != null) {
            prevCell.nextCell = cell.nextCell;
        } else {
            if (cell != this.headCell) {
                throw new AssertionError();
            }
            this.headCell = cell.nextCell;
        }
        if (cell == this.tailCell) {
            this.tailCell = prevCell;
            if (this.tailCell != null) {
                this.tailCell.nextCell = null;
            }
        }
    }

    public Collection<E> snapshot() {
        return this.snapshot(null);
    }

    public synchronized Collection<E> snapshot(Collection<E> elements) {
        Cell<E> cell = this.headCell;
        if (cell == null) {
            return elements == null ? Collections.emptyList() : elements;
        }
        if (elements == null) {
            if (cell == this.tailCell) {
                Object cellElement = cell.get();
                if (cellElement != null) {
                    return Collections.singletonList(cellElement);
                }
                this.removeCell(cell, null);
                return Collections.emptyList();
            }
            elements = new LinkedList();
        }
        Cell<E> prevCell = null;
        do {
            Object cellElement;
            if ((cellElement = cell.get()) == null) {
                this.removeCell(cell, prevCell);
                continue;
            }
            elements.add(cellElement);
            prevCell = cell;
        } while ((cell = cell.nextCell) != null);
        return elements;
    }

    public void purge() {
        this.remove(null);
    }

    public synchronized boolean isEmpty() {
        return this.headCell == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cell<E>
    extends WeakReference<E> {
        Cell<E> nextCell;

        Cell(E element, Cell<E> nextCell) {
            super(element);
            if (element == null) {
                throw new IllegalArgumentException();
            }
            this.nextCell = nextCell;
        }
    }
}

