/*
 * Decompiled with CFR 0.152.
 */
package jpen.internal.filter;

import java.awt.geom.Point2D;
import jpen.internal.filter.RelativeLocationFilter;

class RelativeOnSlopesRule
implements RelativeLocationFilter.Rule {
    private static final int THRESHOLD = 3;
    private int missedPoints;
    private int positiveSlopes;
    private final Point2D.Float previousAbsDeviation = new Point2D.Float();

    RelativeOnSlopesRule() {
    }

    public void reset() {
        this.missedPoints = -1;
        this.positiveSlopes = -1;
    }

    public RelativeLocationFilter.State evalFilterNextState(RelativeLocationFilter filter) {
        ++this.missedPoints;
        if (!filter.samplePoint.isComplete) {
            return null;
        }
        if (this.positiveSlopes == -1) {
            this.previousAbsDeviation.setLocation(filter.absDeviation);
            this.positiveSlopes = 0;
        } else if (filter.absDeviation.x <= 7.0f && filter.absDeviation.y <= 7.0f) {
            this.positiveSlopes = 0;
        } else if (filter.absDeviation.x >= this.previousAbsDeviation.x || filter.absDeviation.y >= this.previousAbsDeviation.y) {
            ++this.positiveSlopes;
        }
        if (this.positiveSlopes >= 3) {
            return RelativeLocationFilter.State.RELATIVE;
        }
        this.previousAbsDeviation.setLocation(filter.absDeviation);
        return null;
    }
}

