/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import processing.app.Editor;
import processing.app.EditorConsole;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Settings;
import processing.app.Sketch;
import processing.app.SketchReference;
import processing.app.UpdateCheck;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.mode.android.AndroidMode;
import processing.mode.java.JavaMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base {
    public static final int REVISION = 197;
    public static String VERSION_NAME = "0197";
    public static boolean RELEASE = false;
    public static boolean DEBUG = false;
    static HashMap<Integer, String> platformNames = new HashMap();
    static HashMap<String, Integer> platformIndices;
    static Platform platform;
    private static boolean commandLine;
    Preferences preferencesFrame;
    boolean builtOnce;
    static File untitledFolder;
    List<Editor> editors = Collections.synchronizedList(new ArrayList());
    protected Editor activeEditor;
    public static JMenu defaultFileMenu;
    private Mode defaultMode;
    private Mode[] modeList;
    private JMenu sketchbookMenu;
    protected File sketchbookFolder;
    protected File toolsFolder;
    static final int SHORTCUT_KEY_MASK;
    static final KeyStroke WINDOW_CLOSE_KEYSTROKE;
    static final int SHORTCUT_ALT_KEY_MASK;
    boolean breakTime = false;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    static {
        platformNames.put(1, "windows");
        platformNames.put(2, "macosx");
        platformNames.put(3, "linux");
        platformIndices = new HashMap();
        platformIndices.put("windows", 1);
        platformIndices.put("macosx", 2);
        platformIndices.put("linux", 3);
        SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
        SHORTCUT_ALT_KEY_MASK = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Base.createAndShowGUI(args);
            }
        });
    }

    private static void createAndShowGUI(String[] args) {
        block7: {
            try {
                String version;
                File versionFile = Base.getContentFile("lib/version.txt");
                if (versionFile.exists() && !(version = PApplet.loadStrings((File)versionFile)[0]).equals(VERSION_NAME)) {
                    VERSION_NAME = version;
                    RELEASE = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Base.initPlatform();
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            Base.initRequirements();
            Preferences.init(null);
            try {
                platform.setLookAndFeel();
            }
            catch (Exception e) {
                String mess = e.getMessage();
                if (mess.indexOf("ch.randelshofer.quaqua.QuaquaLookAndFeel") != -1) break block7;
                System.err.println("Non-fatal error while setting the Look & Feel.");
                System.err.println("The error message follows, however Processing should run fine.");
                System.err.println(mess);
            }
        }
        try {
            untitledFolder = Base.createTempFolder("untitled", "sketches");
            untitledFolder.deleteOnExit();
        }
        catch (IOException e) {
            Base.showError("Trouble without a name", "Could not create a place to store untitled sketches.\nThat's gonna prevent us from continuing.", e);
        }
        new Base(args);
    }

    public static void setCommandLine() {
        commandLine = true;
    }

    protected static boolean isCommandLine() {
        return commandLine;
    }

    public static void initPlatform() {
        try {
            Class<?> platformClass = Class.forName("processing.app.Platform");
            if (Base.isMacOS()) {
                platformClass = Class.forName("processing.app.macosx.Platform");
            } else if (Base.isWindows()) {
                platformClass = Class.forName("processing.app.windows.Platform");
            } else if (Base.isLinux()) {
                platformClass = Class.forName("processing.app.linux.Platform");
            }
            platform = (Platform)platformClass.newInstance();
        }
        catch (Exception e) {
            Base.showError("Problem Setting the Platform", "An unknown error occurred while trying to load\nplatform-specific code for your machine.", e);
        }
    }

    public static void initRequirements() {
        try {
            Class.forName("com.sun.jdi.VirtualMachine");
        }
        catch (ClassNotFoundException cnfe) {
            Base.openURL("http://wiki.processing.org/w/Supported_Platforms");
            Base.showError("Please install JDK 1.5 or later", "Processing requires a full JDK (not just a JRE)\nto run. Please install JDK 1.5 or later.\nMore information can be found in the reference.", cnfe);
        }
    }

    public Base(String[] args) {
        this.defaultMode = new JavaMode(this, Base.getContentFile("modes/java"));
        AndroidMode androidMode = new AndroidMode(this, Base.getContentFile("modes/android"));
        this.modeList = new Mode[]{this.defaultMode, androidMode};
        this.determineSketchbookFolder();
        this.defaultMode.rebuildLibraryList();
        platform.init(this);
        this.toolsFolder = Base.getContentFile("tools");
        boolean opened = this.restoreSketches();
        int i = 0;
        while (i < args.length) {
            String path = args[i];
            if (Base.isWindows()) {
                try {
                    File file = new File(args[i]);
                    path = file.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.handleOpen(path) != null) {
                opened = true;
            }
            ++i;
        }
        if (!opened) {
            this.handleNew();
        }
        if (Preferences.getBoolean("update.check")) {
            new UpdateCheck(this);
        }
    }

    protected boolean restoreSketches() {
        String lastMode = Preferences.get("last.sketch.mode");
        if (DEBUG) {
            System.out.println("setting mode to " + lastMode);
        }
        if (lastMode != null) {
            Mode[] modeArray = this.modeList;
            int n = this.modeList.length;
            int n2 = 0;
            while (n2 < n) {
                Mode m = modeArray[n2];
                if (m.getClass().getName().equals(lastMode)) {
                    this.defaultMode = m;
                }
                ++n2;
            }
        }
        if (DEBUG) {
            System.out.println("default mode set to " + this.defaultMode.getClass().getName());
        }
        if (!Preferences.getBoolean("last.sketch.restore")) {
            return false;
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        boolean windowPositionValid = true;
        if (Preferences.get("last.screen.height") != null) {
            int screenW = Preferences.getInteger("last.screen.width");
            int screenH = Preferences.getInteger("last.screen.height");
            if (screen.width != screenW || screen.height != screenH) {
                windowPositionValid = false;
            }
        } else {
            windowPositionValid = false;
        }
        int count = Preferences.getInteger("last.sketch.count");
        int opened = 0;
        int i = 0;
        while (i < count) {
            int[] location;
            String path = Preferences.get("last.sketch" + i + ".path");
            if (windowPositionValid) {
                String locationStr = Preferences.get("last.sketch" + i + ".location");
                location = PApplet.parseInt((String[])PApplet.split((String)locationStr, (char)','));
            } else {
                location = this.nextEditorLocation();
            }
            if (this.handleOpen(path, location) != null) {
                ++opened;
            }
            ++i;
        }
        return opened > 0;
    }

    protected void storeSketches() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Preferences.setInteger("last.screen.width", screen.width);
        Preferences.setInteger("last.screen.height", screen.height);
        String untitledPath = untitledFolder.getAbsolutePath();
        int index = 0;
        for (Editor editor : this.editors) {
            String path = editor.getSketch().getMainFilePath();
            if (path.startsWith(untitledPath) && !editor.getSketch().isModified()) continue;
            Preferences.set("last.sketch" + index + ".path", path);
            int[] location = editor.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            Preferences.set("last.sketch" + index + ".location", locationStr);
            ++index;
        }
        Preferences.setInteger("last.sketch.count", index);
        Preferences.set("last.sketch.mode", this.defaultMode.getClass().getName());
    }

    protected void storeSketchPath(Editor editor, int index) {
        String untitledPath;
        String path = editor.getSketch().getMainFilePath();
        if (path.startsWith(untitledPath = untitledFolder.getAbsolutePath())) {
            path = "";
        }
        Preferences.set("last.sketch" + index + ".path", path);
    }

    public static JMenuItem newJMenuItem(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers |= 1));
        return menuItem;
    }

    public static JMenuItem newJMenuItemAlt(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_ALT_KEY_MASK));
        return menuItem;
    }

    public static JCheckBoxMenuItem newJCheckBoxMenuItem(String title, int what) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(title);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public static void addDisabledItem(JMenu menu, String title) {
        JMenuItem item = new JMenuItem(title);
        item.setEnabled(false);
        menu.add(item);
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    protected void changeMode(Mode mode) {
        if (this.activeEditor.getMode() != mode) {
            Sketch sketch = this.activeEditor.getSketch();
            if (sketch.isModified()) {
                Base.showWarning("Save", "Please save the sketch before changing the mode.", null);
            } else {
                boolean untitled = this.activeEditor.untitled;
                String mainPath = sketch.getMainFilePath();
                File sketchProps = new File(sketch.getFolder(), "sketch.properties");
                PrintWriter writer = PApplet.createWriter((File)sketchProps);
                writer.println("mode=" + mode.getTitle());
                writer.flush();
                writer.close();
                int[] where = this.activeEditor.getPlacement();
                this.handleClose(this.activeEditor, true);
                Editor editor = this.handleOpen(mainPath, where);
                if (editor != null) {
                    editor.untitled = untitled;
                }
            }
        }
    }

    public Mode[] getModeList() {
        return this.modeList;
    }

    protected void handleActivated(Editor whichEditor) {
        this.activeEditor = whichEditor;
        EditorConsole.setEditor(this.activeEditor);
        this.defaultMode = whichEditor.getMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] nextEditorLocation() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int defaultWidth = Preferences.getInteger("editor.window.width.default");
        int defaultHeight = Preferences.getInteger("editor.window.height.default");
        if (this.editors.size() == 0) {
            int[] nArray = new int[5];
            nArray[0] = (screen.width - defaultWidth) / 2;
            nArray[1] = (screen.height - defaultHeight) / 2;
            nArray[2] = defaultWidth;
            nArray[3] = defaultHeight;
            return nArray;
        }
        List<Editor> list = this.editors;
        synchronized (list) {
            int OVER = 50;
            Editor lastOpened = this.editors.get(this.editors.size() - 1);
            int[] location = lastOpened.getPlacement();
            location[0] = location[0] + 50;
            location[1] = location[1] + 50;
            if (location[0] == 50 || location[2] == 50 || location[0] + location[2] > screen.width || location[1] + location[3] > screen.height) {
                int[] nArray = new int[5];
                nArray[0] = (int)(Math.random() * (double)(screen.width - defaultWidth));
                nArray[1] = (int)(Math.random() * (double)(screen.height - defaultHeight));
                nArray[2] = defaultWidth;
                nArray[3] = defaultHeight;
                return nArray;
            }
            return location;
        }
    }

    public Mode nextEditorMode() {
        return this.activeEditor == null ? this.defaultMode : this.activeEditor.getMode();
    }

    protected String createNewUntitled() throws IOException {
        File newbieDir = null;
        String newbieName = null;
        File newbieParentDir = untitledFolder;
        String prefix = Preferences.get("editor.untitled.prefix");
        int index = 0;
        String format = Preferences.get("editor.untitled.suffix");
        String suffix = null;
        if (format == null) {
            Calendar cal = Calendar.getInstance();
            int day = cal.get(5);
            int month = cal.get(2);
            suffix = String.valueOf(this.months[month]) + PApplet.nf((int)day, (int)2);
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            suffix = formatter.format(new Date());
        }
        do {
            if (index == 26) {
                if (!this.breakTime) {
                    Base.showWarning("Time for a Break", "You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?", null);
                    this.breakTime = true;
                } else {
                    Base.showWarning("Sunshine", "No really, time for some fresh air for you.", null);
                }
                return null;
            }
            newbieName = String.valueOf(prefix) + suffix + (char)(97 + index);
            newbieName = Sketch.sanitizeName(newbieName);
            newbieDir = new File(newbieParentDir, newbieName);
            ++index;
        } while (newbieDir.exists() || new File(this.sketchbookFolder, newbieName).exists());
        newbieDir.mkdirs();
        File newbieFile = new File(newbieDir, String.valueOf(newbieName) + "." + this.defaultMode.getDefaultExtension());
        new FileOutputStream(newbieFile);
        return newbieFile.getAbsolutePath();
    }

    public void handleNew() {
        try {
            String path = this.createNewUntitled();
            if (path != null) {
                Editor editor = this.handleOpen(path);
                editor.untitled = true;
            }
        }
        catch (IOException e) {
            if (this.activeEditor != null) {
                this.activeEditor.statusError(e);
            }
            e.printStackTrace();
        }
    }

    public void handleNewReplace() {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        this.handleNewReplaceImpl();
    }

    protected void handleNewReplaceImpl() {
        try {
            String path = this.createNewUntitled();
            if (path != null) {
                this.activeEditor.handleOpenInternal(path);
                this.activeEditor.untitled = true;
            }
        }
        catch (IOException e) {
            this.activeEditor.statusError(e);
        }
    }

    public void handleOpenReplace(String path) {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        boolean loaded = this.activeEditor.handleOpenInternal(path);
        if (!loaded) {
            this.handleNewReplaceImpl();
        }
    }

    public void handleOpenPrompt() {
        FileDialog fd = new FileDialog((Frame)this.activeEditor, "Open a Processing sketch...", 0);
        final ArrayList<String> extensions = new ArrayList<String>();
        Mode[] modeArray = this.modeList;
        int n = this.modeList.length;
        int n2 = 0;
        while (n2 < n) {
            Mode mode = modeArray[n2];
            extensions.add(mode.getDefaultExtension());
            ++n2;
        }
        fd.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                for (String ext : extensions) {
                    if (!name.toLowerCase().endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            }
        });
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File inputFile = new File(directory, filename);
        this.handleOpen(inputFile.getAbsolutePath());
    }

    public Editor handleOpen(String path) {
        return this.handleOpen(path, this.nextEditorLocation());
    }

    protected Editor handleOpen(String path, int[] location) {
        Editor editor;
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        if (!Sketch.isSanitaryName(file.getName())) {
            Base.showWarning("You're tricky, but not tricky enough", String.valueOf(file.getName()) + " is not a valid name for a sketch.\n" + "Better to stick to ASCII, no spaces, and make sure\n" + "it doesn't start with a number.", null);
            return null;
        }
        for (Editor editor2 : this.editors) {
            if (!editor2.getSketch().getMainFilePath().equals(path)) continue;
            editor2.toFront();
            return editor2;
        }
        Mode nextMode = this.nextEditorMode();
        try {
            Settings props;
            String modeTitle;
            File sketchFolder = new File(path).getParentFile();
            File sketchProps = new File(sketchFolder, "sketch.properties");
            if (sketchProps.exists() && (modeTitle = (props = new Settings(sketchProps)).get("mode")) != null && (nextMode = this.findMode(modeTitle)) == null) {
                String msg = "This sketch was last used in \u201c" + modeTitle + "\u201d mode,\n" + "which does not appear to be installed. The sketch will\n" + "be opened in \u201c" + this.defaultMode.getTitle() + "\u201d mode instead.";
                Base.showWarning("Depeche Mode", msg, null);
                nextMode = this.defaultMode;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((editor = nextMode.createEditor(this, path, location)) == null) {
            if (nextMode == this.modeList[0]) {
                Base.showError("Editor Problems", "An error occurred while trying to change modes.\nWe'll have to quit for now because it's an\nunfortunate bit of indigestion.", null);
            } else {
                editor = this.modeList[0].createEditor(this, path, location);
            }
        }
        if (editor.getSketch() == null) {
            return null;
        }
        this.editors.add(editor);
        editor.setVisible(true);
        return editor;
    }

    protected Mode findMode(String title) {
        Mode[] modeArray = this.modeList;
        int n = this.modeList.length;
        int n2 = 0;
        while (n2 < n) {
            Mode mode = modeArray[n2];
            if (mode.getTitle().equals(title)) {
                return mode;
            }
            ++n2;
        }
        return null;
    }

    public boolean handleClose(Editor editor, boolean modeSwitch) {
        if (!editor.checkModified()) {
            return false;
        }
        editor.internalCloseRunner();
        if (this.editors.size() == 1) {
            Object[] options;
            String prompt;
            int result;
            if (Base.isMacOS() && defaultFileMenu == null && ((result = JOptionPane.showOptionDialog(editor, prompt = "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Are you sure you want to Quit?</b><p>Closing the last open sketch will quit Processing.", "Quit", 0, 3, null, options = new Object[]{"OK", "Cancel"}, options[0])) == 1 || result == -1)) {
                return false;
            }
            this.editors.remove(editor);
            this.storeSketches();
            Preferences.save();
            if (defaultFileMenu == null) {
                if (modeSwitch) {
                    editor.setVisible(false);
                    editor.dispose();
                    this.activeEditor = null;
                    this.editors.remove(editor);
                } else {
                    System.exit(0);
                }
            } else {
                editor.setVisible(false);
                editor.dispose();
                defaultFileMenu.insert(this.sketchbookMenu, 2);
                this.activeEditor = null;
                this.editors.remove(editor);
            }
        } else {
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        this.storeSketches();
        if (this.handleQuitEach()) {
            for (Editor editor : this.editors) {
                editor.internalCloseRunner();
            }
            Preferences.save();
            if (!Base.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        int index = 0;
        for (Editor editor : this.editors) {
            if (editor.checkModified()) {
                this.storeSketchPath(editor, index);
                ++index;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void rebuildSketchbookMenusAsync() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Base.this.rebuildSketchbookMenus();
            }
        });
    }

    protected void rebuildSketchbookMenus() {
        this.rebuildSketchbookMenu();
        Mode[] modeArray = this.modeList;
        int n = this.modeList.length;
        int n2 = 0;
        while (n2 < n) {
            Mode mode = modeArray[n2];
            mode.rebuildImportMenu();
            mode.rebuildToolbarMenu();
            mode.resetExamples();
            ++n2;
        }
    }

    protected void rebuildSketchbookMenu() {
        try {
            this.sketchbookMenu.removeAll();
            this.addSketches(this.sketchbookMenu, this.sketchbookFolder, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JMenu getSketchbookMenu() {
        if (this.sketchbookMenu == null) {
            this.sketchbookMenu = new JMenu("Sketchbook");
            this.rebuildSketchbookMenu();
        }
        return this.sketchbookMenu;
    }

    protected boolean addSketches(JMenu menu, File folder, final boolean replaceExisting) throws IOException {
        if (!folder.isDirectory()) {
            return false;
        }
        if (folder.getName().equals("libraries")) {
            return false;
        }
        String[] list = folder.list();
        if (list == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = e.getActionCommand();
                if (new File(path).exists()) {
                    boolean replace = replaceExisting;
                    if ((e.getModifiers() & 1) != 0) {
                        boolean bl = replace = !replace;
                    }
                    if (replace) {
                        Base.this.handleOpenReplace(path);
                    } else {
                        Base.this.handleOpen(path);
                    }
                } else {
                    Base.showWarning("Sketch Disappeared", "The selected sketch no longer exists.\nYou may need to restart Processing to update\nthe sketchbook menu.", null);
                }
            }
        };
        boolean found = false;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File subfolder;
            String name = stringArray[n2];
            if (name.charAt(0) != '.' && (subfolder = new File(folder, name)).isDirectory()) {
                File entry = this.checkSketchFolder(subfolder, name);
                if (entry != null) {
                    JMenuItem item = new JMenuItem(name);
                    item.addActionListener(listener);
                    item.setActionCommand(entry.getAbsolutePath());
                    menu.add(item);
                    found = true;
                } else {
                    JMenu submenu = new JMenu(name);
                    boolean anything = this.addSketches(submenu, subfolder, replaceExisting);
                    if (anything) {
                        menu.add(submenu);
                        found = true;
                    }
                }
            }
            ++n2;
        }
        return found;
    }

    protected boolean addSketches(DefaultMutableTreeNode node, File folder) throws IOException {
        if (!folder.isDirectory()) {
            return false;
        }
        if (folder.getName().equals("libraries")) {
            return false;
        }
        String[] list = folder.list();
        if (list == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        boolean found = false;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File subfolder;
            String name = stringArray[n2];
            if (name.charAt(0) != '.' && (subfolder = new File(folder, name)).isDirectory()) {
                File entry = this.checkSketchFolder(subfolder, name);
                if (entry != null) {
                    DefaultMutableTreeNode item = new DefaultMutableTreeNode(new SketchReference(name, entry));
                    node.add(item);
                    found = true;
                } else {
                    DefaultMutableTreeNode subnode = new DefaultMutableTreeNode(name);
                    boolean anything = this.addSketches(subnode, subfolder);
                    if (anything) {
                        node.add(subnode);
                        found = true;
                    }
                }
            }
            ++n2;
        }
        return found;
    }

    File checkSketchFolder(File subfolder, String item) {
        Mode[] modeArray = this.modeList;
        int n = this.modeList.length;
        int n2 = 0;
        while (n2 < n) {
            Mode mode = modeArray[n2];
            File entry = new File(subfolder, String.valueOf(item) + "." + mode.getDefaultExtension());
            if (entry.exists()) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    public void handleAbout() {
        final Image image = Base.getLibImage("about.jpg", this.activeEditor);
        final Window window = new Window(this.activeEditor){

            public void paint(Graphics g) {
                g.drawImage(image, 0, 0, null);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g.setFont(new Font("SansSerif", 0, 11));
                g.setColor(Color.white);
                g.drawString(VERSION_NAME, 50, 30);
            }
        };
        window.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                window.dispose();
            }
        });
        int w = image.getWidth(this.activeEditor);
        int h = image.getHeight(this.activeEditor);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((screen.width - w) / 2, (screen.height - h) / 2, w, h);
        window.setVisible(true);
    }

    public void handlePrefs() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new Preferences();
        }
        this.preferencesFrame.showFrame(this.activeEditor);
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static String getPlatformName() {
        return PConstants.platformNames[PApplet.platform];
    }

    public static String getPlatformName(int which) {
        return platformNames.get(which);
    }

    public static int getPlatformIndex(String what) {
        Integer entry = platformIndices.get(what);
        return entry == null ? -1 : entry;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    public static File getSettingsFolder() {
        File settingsFolder = null;
        String preferencesPath = Preferences.get("settings.path");
        if (preferencesPath != null) {
            settingsFolder = new File(preferencesPath);
        } else {
            try {
                settingsFolder = platform.getSettingsFolder();
            }
            catch (Exception e) {
                Base.showError("Problem getting data folder", "Error getting the Processing data folder.", e);
            }
        }
        if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
            Base.showError("Settings issues", "Processing cannot run because it could not\ncreate a folder to store your settings.", null);
        }
        return settingsFolder;
    }

    public static File getSettingsFile(String filename) {
        return new File(Base.getSettingsFolder(), filename);
    }

    public static File createTempFolder(String prefix, String suffix) throws IOException {
        File folder = File.createTempFile(prefix, suffix);
        folder.delete();
        folder.mkdirs();
        return folder;
    }

    public File getToolsFolder() {
        return this.toolsFolder;
    }

    protected void determineSketchbookFolder() {
        String sketchbookPath = Preferences.get("sketchbook.path");
        if (sketchbookPath != null) {
            this.sketchbookFolder = new File(sketchbookPath);
            if (!this.sketchbookFolder.exists()) {
                Base.showWarning("Sketchbook folder disappeared", "The sketchbook folder no longer exists.\nProcessing will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Procesing will then stop talking about\nhimself in the third person.", null);
                this.sketchbookFolder = null;
            }
        }
        if (this.sketchbookFolder == null) {
            this.sketchbookFolder = Base.getDefaultSketchbookFolder();
            Preferences.set("sketchbook.path", this.sketchbookFolder.getAbsolutePath());
            if (!this.sketchbookFolder.exists()) {
                this.sketchbookFolder.mkdirs();
            }
        }
    }

    public void setSketchbookFolder(File folder) {
        this.sketchbookFolder = folder;
        Preferences.set("sketchbook.path", folder.getAbsolutePath());
        this.rebuildSketchbookMenus();
    }

    public File getSketchbookFolder() {
        return this.sketchbookFolder;
    }

    public File getSketchbookLibrariesFolder() {
        return new File(this.sketchbookFolder, "libraries");
    }

    protected static File getDefaultSketchbookFolder() {
        File sketchbookFolder = null;
        try {
            sketchbookFolder = platform.getDefaultSketchbookFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sketchbookFolder == null) {
            sketchbookFolder = Base.promptSketchbookLocation();
        }
        boolean result = true;
        if (!sketchbookFolder.exists()) {
            result = sketchbookFolder.mkdirs();
        }
        if (!result) {
            Base.showError("You forgot your sketchbook", "Processing cannot run because it could not\ncreate a folder to store your sketchbook.", null);
        }
        return sketchbookFolder;
    }

    protected static File promptSketchbookLocation() {
        File folder = new File(System.getProperty("user.home"), "sketchbook");
        String prompt = "Select (or create new) folder for sketches...";
        if ((folder = Base.selectFolder(prompt, folder, null)) == null) {
            System.exit(0);
        }
        if (!folder.exists()) {
            folder.mkdirs();
            return folder;
        }
        return folder;
    }

    public static void openURL(String url) {
        try {
            platform.openURL(url);
        }
        catch (Exception e) {
            Base.showWarning("Problem Opening URL", "Could not open the URL\n" + url, e);
        }
    }

    protected static boolean openFolderAvailable() {
        return platform.openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            platform.openFolder(file);
        }
        catch (Exception e) {
            Base.showWarning("Problem Opening Folder", "Could not open the folder\n" + file.getAbsolutePath(), e);
        }
    }

    public static File selectFolder(String prompt, File folder, Frame frame) {
        if (Base.isMacOS()) {
            if (frame == null) {
                frame = new Frame();
            }
            FileDialog fd = new FileDialog(frame, prompt, 0);
            if (folder != null) {
                fd.setDirectory(folder.getParent());
            }
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fd.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (fd.getFile() == null) {
                return null;
            }
            return new File(fd.getDirectory(), fd.getFile());
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(prompt);
        if (folder != null) {
            fc.setSelectedFile(folder);
        }
        fc.setFileSelectionMode(1);
        int returned = fc.showOpenDialog(new JDialog());
        if (returned == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static void setIcon(Frame frame) {
        Image image = Toolkit.getDefaultToolkit().createImage(PApplet.ICON_IMAGE);
        frame.setIconImage(image);
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        stroke = KeyStroke.getKeyStroke(87, modifiers);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void showMessage(String title, String message) {
        if (title == null) {
            title = "Message";
        }
        if (commandLine) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 1);
        }
    }

    public static void showWarning(String title, String message, Exception e) {
        if (title == null) {
            title = "Warning";
        }
        if (commandLine) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 2);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void showWarningTiered(String title, String primary, String secondary, Exception e) {
        if (title == null) {
            title = "Warning";
        }
        String message = String.valueOf(primary) + "\n" + secondary;
        if (commandLine) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else if (!Base.isMacOS()) {
            JOptionPane.showMessageDialog(new JFrame(), "<html><body><b>" + primary + "</b>" + "<br>" + secondary, title, 2);
        } else {
            JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>" + primary + "</b>" + "<p>" + secondary + "</p>", 2);
            JDialog dialog = pane.createDialog(new JFrame(), null);
            dialog.setVisible(true);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void showError(String title, String message, Throwable e) {
        if (title == null) {
            title = "Error";
        }
        if (commandLine) {
            System.err.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 0);
        }
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public static int showYesNoCancelQuestion(Editor editor, String title, String primary, String secondary) {
        if (!Base.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(null, String.valueOf(primary) + "\n" + secondary, title, 1, 3);
            return result;
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] options = new String[]{"Save", "Cancel", "Don't Save"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 2;
        }
        if (result == options[2]) {
            return 1;
        }
        return -1;
    }

    public static int showYesNoQuestion(Frame editor, String title, String primary, String secondary) {
        if (!Base.isMacOS()) {
            return JOptionPane.showConfirmDialog(editor, "<html><body><b>" + primary + "</b>" + "<br>" + secondary, title, 0, 3);
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>" + primary + "</b>" + "<p>" + secondary + "</p>", 3);
        Object[] options = new String[]{"Yes", "No"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 1;
        }
        return -1;
    }

    public static File getContentFile(String name) {
        String javaroot;
        String path = System.getProperty("user.dir");
        if (Base.isMacOS() && (javaroot = System.getProperty("javaroot")) != null) {
            path = javaroot;
        }
        File working = new File(path);
        return new File(working, name);
    }

    public static Image getThemeImage(String name, Component who) {
        return Base.getLibImage("theme/" + name, who);
    }

    public static Image getLibImage(String name, Component who) {
        Image image = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        File imageLocation = new File(Base.getContentFile("lib"), name);
        image = tk.getImage(imageLocation.getAbsolutePath());
        MediaTracker tracker = new MediaTracker(who);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static InputStream getLibStream(String filename) throws IOException {
        return new FileInputStream(new File(Base.getContentFile("lib"), filename));
    }

    public static int countLines(String what) {
        int count = 1;
        char[] cArray = what.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static byte[] loadBytesRaw(File file) throws IOException {
        int bytesRead;
        int size = (int)file.length();
        FileInputStream input = new FileInputStream(file);
        byte[] buffer = new byte[size];
        int offset = 0;
        while ((bytesRead = input.read(buffer, offset, size - offset)) != -1) {
            offset += bytesRead;
            if (bytesRead == 0) break;
        }
        input.close();
        input = null;
        return buffer;
    }

    public static HashMap<String, String> readSettings(File inputFile) {
        HashMap<String, String> outgoing = new HashMap<String, String>();
        if (inputFile.exists()) {
            String[] lines = PApplet.loadStrings((File)inputFile);
            int i = 0;
            while (i < lines.length) {
                String line;
                int hash = lines[i].indexOf(35);
                String string = line = hash == -1 ? lines[i].trim() : lines[i].substring(0, hash).trim();
                if (line.length() != 0) {
                    int equals = line.indexOf(61);
                    if (equals == -1) {
                        System.err.println("ignoring illegal line in " + inputFile);
                        System.err.println("  " + line);
                    } else {
                        String attr = line.substring(0, equals).trim();
                        String valu = line.substring(equals + 1).trim();
                        outgoing.put(attr, valu);
                    }
                }
                ++i;
            }
        }
        return outgoing;
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int bytesRead;
        BufferedInputStream from = new BufferedInputStream(new FileInputStream(sourceFile));
        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] buffer = new byte[16384];
        while ((bytesRead = ((InputStream)from).read(buffer)) != -1) {
            ((OutputStream)to).write(buffer, 0, bytesRead);
        }
        ((OutputStream)to).flush();
        ((InputStream)from).close();
        from = null;
        ((OutputStream)to).close();
        to = null;
        targetFile.setLastModified(sourceFile.lastModified());
    }

    public static String loadFile(File file) throws IOException {
        String[] contents = PApplet.loadStrings((File)file);
        if (contents == null) {
            return null;
        }
        return PApplet.join((String[])contents, (String)"\n");
    }

    public static void saveFile(String str, File file) throws IOException {
        boolean result;
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        try {
            File canon;
            file = canon = file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IOException("Could not resolve canonical representation of " + file.getAbsolutePath());
        }
        PApplet.saveStrings((File)temp, (String[])new String[]{str});
        if (file.exists() && !(result = file.delete())) {
            throw new IOException("Could not remove old version of " + file.getAbsolutePath());
        }
        result = temp.renameTo(file);
        if (!result) {
            throw new IOException("Could not replace " + file.getAbsolutePath());
        }
    }

    public static void copyDir(File sourceDir, File targetDir) throws IOException {
        if (sourceDir.equals(targetDir)) {
            String urDum = "source and target directories are identical";
            throw new IllegalArgumentException("source and target directories are identical");
        }
        targetDir.mkdirs();
        String[] files = sourceDir.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].charAt(0) != '.') {
                File source = new File(sourceDir, files[i]);
                File target = new File(targetDir, files[i]);
                if (source.isDirectory()) {
                    Base.copyDir(source, target);
                    target.setLastModified(source.lastModified());
                } else {
                    Base.copyFile(source, target);
                }
            }
            ++i;
        }
    }

    public static void removeDir(File dir) {
        if (dir.exists()) {
            Base.removeDescendants(dir);
            if (!dir.delete()) {
                System.err.println("Could not delete " + dir);
            }
        }
    }

    public static void removeDescendants(File dir) {
        if (!dir.exists()) {
            return;
        }
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (!files[i].equals(".") && !files[i].equals("..")) {
                File dead = new File(dir, files[i]);
                if (!dead.isDirectory()) {
                    if (!Preferences.getBoolean("compiler.save_build_files") && !dead.delete()) {
                        System.err.println("Could not delete " + dead);
                    }
                } else {
                    Base.removeDir(dead);
                }
            }
            ++i;
        }
    }

    public static int calcFolderSize(File folder) {
        int size = 0;
        String[] files = folder.list();
        if (files == null) {
            return -1;
        }
        int i = 0;
        while (i < files.length) {
            if (!(files[i].equals(".") || files[i].equals("..") || files[i].equals(".DS_Store"))) {
                File fella = new File(folder, files[i]);
                size = fella.isDirectory() ? (size += Base.calcFolderSize(fella)) : (size += (int)fella.length());
            }
            ++i;
        }
        return size;
    }

    public static String[] listFiles(File folder, boolean relative) {
        String path = folder.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        Base.listFiles(relative ? String.valueOf(path) + File.separator : "", path, null, vector);
        Object[] outgoing = new String[vector.size()];
        vector.copyInto(outgoing);
        return outgoing;
    }

    public static String[] listFiles(File folder, boolean relative, String extension) {
        String path = folder.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        if (extension != null && !extension.startsWith(".")) {
            extension = "." + extension;
        }
        Base.listFiles(relative ? String.valueOf(path) + File.separator : "", path, extension, vector);
        Object[] outgoing = new String[vector.size()];
        vector.copyInto(outgoing);
        return outgoing;
    }

    protected static void listFiles(String basePath, String path, String extension, Vector<String> vector) {
        File folder = new File(path);
        String[] list = folder.list();
        if (list != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.charAt(0) != '.' && (extension == null || item.toLowerCase().endsWith(extension))) {
                    File file = new File(path, item);
                    String newPath = file.getAbsolutePath();
                    if (newPath.startsWith(basePath)) {
                        newPath = newPath.substring(basePath.length());
                    }
                    vector.add(newPath);
                    if (file.isDirectory()) {
                        Base.listFiles(basePath, newPath, extension, vector);
                    }
                }
                ++n2;
            }
        }
    }

    public static String contentsToClassPath(File folder) {
        if (folder == null) {
            return "";
        }
        StringBuffer abuffer = new StringBuffer();
        String sep = System.getProperty("path.separator");
        try {
            String path = folder.getCanonicalPath();
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(path) + File.separator;
            }
            String[] list = folder.list();
            int i = 0;
            while (i < list.length) {
                if (!list[i].startsWith(".") && (list[i].toLowerCase().endsWith(".jar") || list[i].toLowerCase().endsWith(".zip"))) {
                    abuffer.append(sep);
                    abuffer.append(path);
                    abuffer.append(list[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return abuffer.toString();
    }

    public static String[] packageListFromClassPath(String path) {
        Hashtable table = new Hashtable();
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        int i = 0;
        while (i < pieces.length) {
            if (pieces[i].length() != 0) {
                if (pieces[i].toLowerCase().endsWith(".jar") || pieces[i].toLowerCase().endsWith(".zip")) {
                    Base.packageListFromZip(pieces[i], table);
                } else {
                    File dir = new File(pieces[i]);
                    if (dir.exists() && dir.isDirectory()) {
                        Base.packageListFromFolder(dir, null, table);
                    }
                }
            }
            ++i;
        }
        int tableCount = table.size();
        String[] output = new String[tableCount];
        int index = 0;
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            output[index++] = ((String)e.nextElement()).replace('/', '.');
        }
        return output;
    }

    private static void packageListFromZip(String filename, Hashtable table) {
        try {
            ZipFile file = new ZipFile(filename);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                String pname;
                int slash;
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class") || (slash = name.lastIndexOf(47)) == -1 || table.get(pname = name.substring(0, slash)) != null) continue;
                table.put(pname, new Object());
            }
        }
        catch (IOException e) {
            System.err.println("Ignoring " + filename + " (" + e.getMessage() + ")");
        }
    }

    private static void packageListFromFolder(File dir, String sofar, Hashtable table) {
        boolean foundClass = false;
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (!files[i].equals(".") && !files[i].equals("..")) {
                File sub = new File(dir, files[i]);
                if (sub.isDirectory()) {
                    String nowfar = sofar == null ? files[i] : String.valueOf(sofar) + "." + files[i];
                    Base.packageListFromFolder(sub, nowfar, table);
                } else if (!foundClass && files[i].endsWith(".class")) {
                    table.put(sofar, new Object());
                    foundClass = true;
                }
            }
            ++i;
        }
    }
}

