/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import processing.app.Base;
import processing.app.BufferedStyledDocument;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.Preferences;
import processing.core.PApplet;

public class EditorConsole
extends JScrollPane {
    Editor editor;
    JTextPane consoleTextPane;
    BufferedStyledDocument consoleDoc;
    MutableAttributeSet stdStyle;
    MutableAttributeSet errStyle;
    int maxLineCount;
    static PrintStream systemOut = System.out;
    static PrintStream systemErr = System.err;
    static PrintStream consoleOut;
    static PrintStream consoleErr;
    static OutputStream stdoutFile;
    static OutputStream stderrFile;
    static EditorConsole currentConsole;

    static {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd");
            String randy = PApplet.nf((int)((int)(1000.0 * Math.random())), (int)4);
            String stamp = String.valueOf(formatter.format(new Date())) + "_" + randy;
            File consoleDir = Base.getSettingsFile("console");
            consoleDir.mkdirs();
            File outFile = new File(consoleDir, String.valueOf(stamp) + ".out");
            stdoutFile = new FileOutputStream(outFile);
            File errFile = new File(consoleDir, String.valueOf(stamp) + ".err");
            stderrFile = new FileOutputStream(errFile);
            consoleOut = new PrintStream(new EditorConsoleStream(false));
            consoleErr = new PrintStream(new EditorConsoleStream(true));
            System.setOut(consoleOut);
            System.setErr(consoleErr);
        }
        catch (Exception e) {
            stdoutFile = null;
            stderrFile = null;
            consoleOut = null;
            consoleErr = null;
            System.setOut(systemOut);
            System.setErr(systemErr);
            e.printStackTrace(systemErr);
        }
    }

    public EditorConsole(Editor editor) {
        this.editor = editor;
        this.maxLineCount = Preferences.getInteger("console.length");
        this.consoleDoc = new BufferedStyledDocument(10000, this.maxLineCount);
        this.consoleTextPane = new JTextPane(this.consoleDoc);
        this.consoleTextPane.setEditable(false);
        this.updateMode();
        this.setViewportView(this.consoleTextPane);
        if (Base.isMacOS()) {
            this.setBorder(null);
        }
        new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (EditorConsole.this.consoleDoc.hasAppendage) {
                    EditorConsole.this.consoleDoc.insertAll();
                    EditorConsole.this.consoleTextPane.setCaretPosition(EditorConsole.this.consoleDoc.getLength());
                }
            }
        }).start();
    }

    protected void updateMode() {
        Mode mode = this.editor.getMode();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 0);
        this.consoleDoc.setParagraphAttributes(0, 0, standard, true);
        Font font = Preferences.getFont("console.font");
        Color bgColor = mode.getColor("console.color");
        Color fgColorOut = mode.getColor("console.output.color");
        Color fgColorErr = mode.getColor("console.error.color");
        this.stdStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.stdStyle, fgColorOut);
        StyleConstants.setBackground(this.stdStyle, bgColor);
        StyleConstants.setFontSize(this.stdStyle, font.getSize());
        StyleConstants.setFontFamily(this.stdStyle, font.getFamily());
        StyleConstants.setBold(this.stdStyle, font.isBold());
        StyleConstants.setItalic(this.stdStyle, font.isItalic());
        this.errStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errStyle, fgColorErr);
        StyleConstants.setBackground(this.errStyle, bgColor);
        StyleConstants.setFontSize(this.errStyle, font.getSize());
        StyleConstants.setFontFamily(this.errStyle, font.getFamily());
        StyleConstants.setBold(this.errStyle, font.isBold());
        StyleConstants.setItalic(this.errStyle, font.isItalic());
        this.consoleTextPane.setBackground(bgColor);
        FontMetrics metrics = this.getFontMetrics(font);
        int height = metrics.getAscent() + metrics.getDescent();
        int lines = Preferences.getInteger("console.lines");
        int sizeFudge = 6;
        this.setPreferredSize(new Dimension(1024, height * lines + sizeFudge));
        this.setMinimumSize(new Dimension(1024, height * 4 + sizeFudge));
    }

    public static void setEditor(Editor editor) {
        currentConsole = editor.console;
    }

    public void handleQuit() {
        System.setOut(systemOut);
        System.setErr(systemErr);
        try {
            if (consoleOut != null) {
                consoleOut.close();
            }
            if (consoleErr != null) {
                consoleErr.close();
            }
            if (stdoutFile != null) {
                stdoutFile.close();
            }
            if (stderrFile != null) {
                stderrFile.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace(systemErr);
        }
    }

    public synchronized void message(String what, boolean err) {
        if (err) {
            systemErr.print(what);
        } else {
            systemOut.print(what);
        }
        this.consoleDoc.appendString(what, err ? this.errStyle : this.stdStyle);
    }

    public void clear() {
        try {
            this.consoleDoc.remove(0, this.consoleDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static class EditorConsoleStream
    extends OutputStream {
        final boolean err;
        final byte[] single = new byte[1];

        public EditorConsoleStream(boolean err) {
            this.err = err;
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int offset, int length) {
            OutputStream echo;
            if (currentConsole != null) {
                currentConsole.message(new String(b, offset, length), this.err);
            } else {
                try {
                    if (this.err) {
                        systemErr.write(b);
                    } else {
                        systemOut.write(b);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            OutputStream outputStream = echo = this.err ? stderrFile : stdoutFile;
            if (echo != null) {
                try {
                    echo.write(b, offset, length);
                    echo.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    echo = null;
                }
            }
        }

        public void write(int b) {
            this.single[0] = (byte)b;
            this.write(this.single, 0, 1);
        }
    }
}

