/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.Sketch;
import processing.app.SketchCode;

public class EditorHeader
extends JComponent {
    Color backgroundColor;
    Color[] textColor = new Color[2];
    Editor editor;
    Tab[] tabs = new Tab[0];
    Tab[] visitOrder;
    Font font;
    FontMetrics metrics;
    int fontAscent;
    JMenu menu;
    JPopupMenu popup;
    int menuLeft;
    int menuRight;
    static final String[] STATUS = new String[]{"unsel", "sel"};
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    static final String[] WHERE = new String[]{"left", "mid", "right", "menu"};
    static final int LEFT = 0;
    static final int MIDDLE = 1;
    static final int RIGHT = 2;
    static final int MENU = 3;
    static final int PIECE_WIDTH = 4;
    Image[][] pieces;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    String lastNoticeName;

    public EditorHeader(Editor eddie) {
        this.editor = eddie;
        this.updateMode();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (x > EditorHeader.this.menuLeft && x < EditorHeader.this.menuRight) {
                    EditorHeader.this.popup.show(EditorHeader.this, x, y);
                } else {
                    Sketch sketch = EditorHeader.this.editor.getSketch();
                    Tab[] tabArray = EditorHeader.this.tabs;
                    int n = EditorHeader.this.tabs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Tab tab = tabArray[n2];
                        if (tab.contains(x)) {
                            sketch.setCurrentCode(tab.index);
                            EditorHeader.this.repaint();
                        }
                        ++n2;
                    }
                }
            }

            public void mouseExited(MouseEvent e) {
                if (EditorHeader.this.lastNoticeName != null) {
                    EditorHeader.this.editor.clearNotice(EditorHeader.this.lastNoticeName);
                    EditorHeader.this.lastNoticeName = null;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                Tab[] tabArray = EditorHeader.this.tabs;
                int n = EditorHeader.this.tabs.length;
                int n2 = 0;
                while (n2 < n) {
                    Tab tab = tabArray[n2];
                    if (tab.contains(x) && !tab.textVisible) {
                        EditorHeader.this.lastNoticeName = EditorHeader.this.editor.getSketch().getCode(tab.index).getPrettyName();
                        EditorHeader.this.editor.statusNotice(EditorHeader.this.lastNoticeName);
                    }
                    ++n2;
                }
            }
        });
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        this.pieces = new Image[STATUS.length][WHERE.length];
        int i = 0;
        while (i < STATUS.length) {
            int j = 0;
            while (j < WHERE.length) {
                String filename = "theme/tab-" + STATUS[i] + "-" + WHERE[j] + ".gif";
                this.pieces[i][j] = mode.loadImage(filename);
                ++j;
            }
            ++i;
        }
        this.backgroundColor = mode.getColor("header.bgcolor");
        this.textColor[1] = mode.getColor("header.text.selected.color");
        this.textColor[0] = mode.getColor("header.text.unselected.color");
        this.font = mode.getFont("header.text.font");
    }

    public void paintComponent(Graphics screen) {
        if (screen == null) {
            return;
        }
        Sketch sketch = this.editor.getSketch();
        if (sketch == null) {
            return;
        }
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            if (size.width > this.imageW || size.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = size.width;
                this.sizeH = size.height;
            }
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics g = this.offscreen.getGraphics();
        g.setFont(this.font);
        this.metrics = g.getFontMetrics();
        this.fontAscent = this.metrics.getAscent();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.imageW, this.imageH);
        if (this.tabs.length != sketch.getCodeCount()) {
            this.tabs = new Tab[sketch.getCodeCount()];
            int i = 0;
            while (i < this.tabs.length) {
                this.tabs[i] = new Tab(i);
                ++i;
            }
            this.visitOrder = new Tab[sketch.getCodeCount() - 1];
        }
        this.menuRight = this.sizeW - 16;
        this.menuLeft = this.menuRight - this.pieces[0][3].getWidth(this);
        int tabLeft = 6;
        int tabMax = this.menuLeft - tabLeft;
        Tab[] tabArray = this.tabs;
        int n = this.tabs.length;
        int n2 = 0;
        while (n2 < n) {
            Tab tab = tabArray[n2];
            SketchCode code = sketch.getCode(tab.index);
            tab.textVisible = true;
            tab.lastVisited = code.lastVisited();
            boolean hide = this.editor.getMode().hideExtension(code.getExtension());
            String codeName = hide ? code.getPrettyName() : code.getFileName();
            tab.text = "  " + codeName + (code.isModified() ? " \u00a7" : "  ");
            tab.textWidth = (int)this.font.getStringBounds(tab.text, g2.getFontRenderContext()).getWidth();
            ++n2;
        }
        if (!this.placeTabs(tabLeft, tabMax, null)) {
            int index = 0;
            int i = this.tabs.length - 1;
            while (i > 0) {
                this.visitOrder[index++] = this.tabs[i];
                --i;
            }
            Arrays.sort(this.visitOrder);
            i = 0;
            while (i < this.visitOrder.length) {
                this.tabs[this.visitOrder[i].index].textVisible = false;
                if (this.placeTabs(tabLeft, tabMax, null)) break;
                ++i;
            }
        }
        this.placeTabs(tabLeft, tabMax, g);
        g.drawImage(this.pieces[this.popup.isVisible() ? 1 : 0][3], this.menuLeft, 0, null);
        screen.drawImage(this.offscreen, 0, 0, null);
    }

    private boolean placeTabs(int left, int right, Graphics g) {
        Sketch sketch = this.editor.getSketch();
        int x = left;
        int i = 0;
        while (i < sketch.getCodeCount()) {
            int state;
            SketchCode code = sketch.getCode(i);
            Tab tab = this.tabs[i];
            int pieceCount = 2 + tab.textWidth / 4;
            if (!tab.textVisible) {
                pieceCount = 4;
            }
            int pieceWidth = pieceCount * 4;
            int n = state = code == sketch.getCurrentCode() ? 1 : 0;
            if (g != null) {
                g.drawImage(this.pieces[state][0], x, 0, null);
            }
            int contentLeft = x += 4;
            tab.left = x;
            int j = 0;
            while (j < pieceCount) {
                if (g != null) {
                    g.drawImage(this.pieces[state][1], x, 0, null);
                }
                x += 4;
                ++j;
            }
            tab.right = x;
            if (tab.textVisible) {
                int textLeft = contentLeft + (pieceWidth - tab.textWidth) / 2;
                if (g != null) {
                    g.setColor(this.textColor[state]);
                    int baseline = (this.sizeH + this.fontAscent) / 2;
                    g.drawString(tab.text, textLeft, baseline);
                }
            }
            if (g != null) {
                g.drawImage(this.pieces[state][2], x, 0, null);
            }
            x += 3;
            ++i;
        }
        return x <= right;
    }

    public void rebuild() {
        this.rebuildMenu();
        this.repaint();
        Toolkit.getDefaultToolkit().sync();
    }

    public void rebuildMenu() {
        if (this.menu != null) {
            this.menu.removeAll();
        } else {
            this.menu = new JMenu();
            this.popup = this.menu.getPopupMenu();
            this.add(this.popup);
            this.popup.setLightWeightPopupEnabled(true);
        }
        JMenuItem item = Base.newJMenuItemShift("New Tab", 78);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleNewCode();
            }
        });
        this.menu.add(item);
        item = new JMenuItem("Rename");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleRenameCode();
            }
        });
        this.menu.add(item);
        item = new JMenuItem("Delete");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleDeleteCode();
            }
        });
        this.menu.add(item);
        this.menu.addSeparator();
        item = new JMenuItem("Previous Tab");
        KeyStroke ctrlAltLeft = KeyStroke.getKeyStroke(37, Base.SHORTCUT_ALT_KEY_MASK);
        item.setAccelerator(ctrlAltLeft);
        this.menu.add(item);
        item = new JMenuItem("Next Tab");
        KeyStroke ctrlAltRight = KeyStroke.getKeyStroke(39, Base.SHORTCUT_ALT_KEY_MASK);
        item.setAccelerator(ctrlAltRight);
        this.menu.add(item);
        Sketch sketch = this.editor.getSketch();
        if (sketch != null) {
            this.menu.addSeparator();
            ActionListener jumpListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditorHeader.this.editor.getSketch().setCurrentCode(e.getActionCommand());
                }
            };
            SketchCode[] sketchCodeArray = sketch.getCode();
            int n = sketchCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode code = sketchCodeArray[n2];
                item = new JMenuItem(code.getPrettyName());
                item.addActionListener(jumpListener);
                this.menu.add(item);
                ++n2;
            }
        }
    }

    public void deselectMenu() {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (Base.isMacOS()) {
            return new Dimension(300, 33);
        }
        return new Dimension(300, 32);
    }

    public Dimension getMaximumSize() {
        if (Base.isMacOS()) {
            return new Dimension(3000, 33);
        }
        return new Dimension(3000, 32);
    }

    class Tab
    implements Comparable {
        int index;
        int left;
        int right;
        String text;
        int textWidth;
        boolean textVisible;
        long lastVisited;

        Tab(int index) {
            this.index = index;
        }

        boolean contains(int x) {
            return x >= this.left && x <= this.right;
        }

        public int compareTo(Object o) {
            Tab other = (Tab)o;
            if (this.lastVisited == other.lastVisited) {
                return 0;
            }
            if (this.lastVisited == 0L) {
                return -1;
            }
            if (other.lastVisited == 0L) {
                return 1;
            }
            return (int)(this.lastVisited - other.lastVisited);
        }
    }
}

