/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;

public class EditorLineStatus
extends JComponent {
    Editor editor;
    int start = -1;
    int stop;
    Image resize;
    Color foreground;
    Color background;
    Font font;
    int high;
    String text = "";

    public EditorLineStatus(Editor editor) {
        this.editor = editor;
        editor.getTextArea().editorLineStatus = this;
        this.updateMode();
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        this.background = mode.getColor("linestatus.bgcolor");
        this.font = mode.getFont("linestatus.font");
        this.foreground = mode.getColor("linestatus.color");
        this.high = mode.getInteger("linestatus.height");
        if (Base.isMacOS()) {
            this.resize = mode.loadImage("theme/resize.gif");
        }
    }

    public void set(int newStart, int newStop) {
        if (newStart == this.start && newStop == this.stop) {
            return;
        }
        this.start = newStart;
        this.stop = newStop;
        this.text = this.start == this.stop ? String.valueOf(this.start + 1) : String.valueOf(this.start + 1) + " - " + (this.stop + 1);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.background);
        Dimension size = this.getSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setFont(this.font);
        g.setColor(this.foreground);
        int baseline = (this.high + g.getFontMetrics().getAscent()) / 2;
        g.drawString(this.text, 6, baseline);
        if (Base.isMacOS()) {
            g.drawImage(this.resize, size.width - 20, 0, this);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, this.high);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(3000, this.high);
    }
}

