/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import processing.app.Base;
import processing.app.Sketch;
import processing.core.PApplet;
import processing.core.PConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    static final String[] platformNames = PConstants.platformNames;
    protected File folder;
    protected File libraryFolder;
    protected File examplesFolder;
    protected File referenceFile;
    protected String name;
    protected String author;
    protected String authorURL;
    protected String sentence;
    protected String paragraph;
    protected int version;
    protected String prettyVersion;
    protected String group;
    String[] packageList;
    HashMap<String, String[]> exportList;
    String[] appletExportList;
    boolean[] multipleArch = new boolean[platformNames.length];
    String nativeLibraryPath;
    static int nativeBits = 32;
    static FilenameFilter standardFilter;
    static FilenameFilter jarFilter;
    protected static HashMap<String, Object> packageWarningMap;

    static {
        String bits = System.getProperty("sun.arch.data.model");
        if (bits != null) {
            if (bits.equals("64")) {
                nativeBits = 64;
            }
        } else if (System.getProperty("java.vm.name").contains("64")) {
            nativeBits = 64;
        }
        standardFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.charAt(0) == '.') {
                    return false;
                }
                if (name.equals("CVS")) {
                    return false;
                }
                if (name.equals("export.txt")) {
                    return false;
                }
                File file = new File(dir, name);
                return !file.isDirectory();
            }
        };
        jarFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.charAt(0) == '.') {
                    return false;
                }
                if (new File(dir, name).isDirectory()) {
                    return false;
                }
                String lc = name.toLowerCase();
                return lc.endsWith(".jar") || lc.endsWith(".zip");
            }
        };
        packageWarningMap = new HashMap();
    }

    public Library(File folder, String subfolder) {
        this.folder = folder;
        this.group = subfolder;
        this.libraryFolder = new File(folder, "library");
        this.examplesFolder = new File(folder, "examples");
        this.referenceFile = new File(folder, "reference/index.html");
        File exportSettings = new File(this.libraryFolder, "export.txt");
        HashMap<String, String> exportTable = Base.readSettings(exportSettings);
        this.name = exportTable.get("name");
        if (this.name == null) {
            this.name = folder.getName();
        }
        this.exportList = new HashMap();
        String[] baseList = this.libraryFolder.list(standardFilter);
        String appletExportStr = exportTable.get("applet");
        this.appletExportList = appletExportStr != null ? PApplet.splitTokens((String)appletExportStr, (String)", ") : baseList;
        File nativeLibraryFolder = this.libraryFolder;
        String hostPlatform = Base.getPlatformName();
        File hostLibrary = new File(this.libraryFolder, hostPlatform);
        if (hostLibrary.exists()) {
            nativeLibraryFolder = hostLibrary;
        }
        if ((hostLibrary = new File(this.libraryFolder, String.valueOf(hostPlatform) + nativeBits)).exists()) {
            nativeLibraryFolder = hostLibrary;
        }
        this.nativeLibraryPath = nativeLibraryFolder.getAbsolutePath();
        int i = 1;
        while (i < platformNames.length) {
            String[] platformList64;
            String platformName = platformNames[i];
            String platformName32 = String.valueOf(platformName) + "32";
            String platformName64 = String.valueOf(platformName) + "64";
            String platformAll = exportTable.get("application." + platformName);
            String[] platformList = platformAll == null ? null : PApplet.splitTokens((String)platformAll, (String)", ");
            String platform32 = exportTable.get("application." + platformName + "32");
            String[] platformList32 = platform32 == null ? null : PApplet.splitTokens((String)platform32, (String)", ");
            String platform64 = exportTable.get("application." + platformName + "64");
            String[] stringArray = platformList64 = platform64 == null ? null : PApplet.splitTokens((String)platform64, (String)", ");
            if (platformAll == null) {
                platformList = Library.listPlatformEntries(this.libraryFolder, platformName, baseList);
            }
            if (platform32 == null) {
                platformList32 = Library.listPlatformEntries(this.libraryFolder, platformName32, baseList);
            }
            if (platform64 == null) {
                platformList64 = Library.listPlatformEntries(this.libraryFolder, platformName64, baseList);
            }
            if (platformList32 != null || platformList64 != null) {
                this.multipleArch[i] = true;
            }
            if (platformList == null && platformList32 == null && platformList64 == null) {
                this.exportList.put(platformName, baseList);
            } else {
                if (platformList != null) {
                    this.exportList.put(platformName, platformList);
                }
                if (platformList32 != null) {
                    this.exportList.put(platformName32, platformList32);
                }
                if (platformList64 != null) {
                    this.exportList.put(platformName64, platformList64);
                }
            }
            ++i;
        }
        this.packageList = Base.packageListFromClassPath(this.getClassPath());
    }

    static String[] listPlatformEntries(File libraryFolder, String folderName, String[] baseList) {
        String[] entries;
        File folder = new File(libraryFolder, folderName);
        if (folder.exists() && (entries = folder.list(standardFilter)) != null) {
            String[] outgoing = new String[entries.length + baseList.length];
            int i = 0;
            while (i < entries.length) {
                outgoing[i] = String.valueOf(folderName) + "/" + entries[i];
                ++i;
            }
            System.arraycopy(baseList, 0, outgoing, entries.length, baseList.length);
            return outgoing;
        }
        return null;
    }

    public void addPackageList(HashMap<String, Library> importToLibraryTable) {
        String[] stringArray = this.packageList;
        int n = this.packageList.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            Library library = importToLibraryTable.get(pkg);
            if (library != null) {
                if (!packageWarningMap.containsKey(pkg)) {
                    packageWarningMap.put(pkg, null);
                    System.err.println("The library found in");
                    System.err.println(this.getPath());
                    System.err.println("conflicts with");
                    System.err.println(library.getPath());
                    System.err.println("which already defines the package " + pkg);
                    System.err.println("If you have a line in your sketch that reads");
                    System.err.println("import " + pkg + ".*;");
                    System.err.println("Then you'll need to first remove one of those libraries.");
                    System.err.println();
                }
            } else {
                importToLibraryTable.put(pkg, this);
            }
            ++n2;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasExamples() {
        return this.examplesFolder.exists();
    }

    public File getExamplesFolder() {
        return this.examplesFolder;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPath() {
        return this.folder.getAbsolutePath();
    }

    public String getLibraryPath() {
        return this.libraryFolder.getAbsolutePath();
    }

    public String getJarPath() {
        return new File(this.libraryFolder, String.valueOf(this.folder.getName()) + ".jar").getAbsolutePath();
    }

    public String getClassPath() {
        String jar;
        String[] jarHeads;
        StringBuilder cp = new StringBuilder();
        String[] stringArray = jarHeads = this.libraryFolder.list(jarFilter);
        int n = jarHeads.length;
        int n2 = 0;
        while (n2 < n) {
            jar = stringArray[n2];
            cp.append(File.pathSeparatorChar);
            cp.append(new File(this.libraryFolder, jar).getAbsolutePath());
            ++n2;
        }
        stringArray = jarHeads = new File(this.nativeLibraryPath).list(jarFilter);
        n = jarHeads.length;
        n2 = 0;
        while (n2 < n) {
            jar = stringArray[n2];
            cp.append(File.pathSeparatorChar);
            cp.append(new File(this.nativeLibraryPath, jar).getAbsolutePath());
            ++n2;
        }
        return cp.toString();
    }

    public String getNativePath() {
        return this.nativeLibraryPath;
    }

    protected File[] wrapFiles(String[] list) {
        File[] outgoing = new File[list.length];
        int i = 0;
        while (i < list.length) {
            outgoing[i] = new File(this.libraryFolder, list[i]);
            ++i;
        }
        return outgoing;
    }

    public File[] getAppletExports() {
        return this.wrapFiles(this.appletExportList);
    }

    public File[] getApplicationExports(int platform, int bits) {
        String[] list = this.getApplicationExportList(platform, bits);
        return this.wrapFiles(list);
    }

    public String[] getApplicationExportList(int platform, int bits) {
        String[] pieces;
        String platformName = PApplet.platformNames[platform];
        if (bits == 32) {
            String[] pieces2 = this.exportList.get(String.valueOf(platformName) + "32");
            if (pieces2 != null) {
                return pieces2;
            }
        } else if (bits == 64 && (pieces = this.exportList.get(String.valueOf(platformName) + "64")) != null) {
            return pieces;
        }
        return this.exportList.get(platformName);
    }

    public boolean hasMultipleArch(int platform) {
        return this.multipleArch[platform];
    }

    public static boolean hasMultipleArch(int platform, ArrayList<Library> libraries) {
        for (Library library : libraries) {
            if (!library.hasMultipleArch(platform)) continue;
            return true;
        }
        return false;
    }

    protected static ArrayList<Library> list(File folder) throws IOException {
        ArrayList<Library> libraries = new ArrayList<Library>();
        Library.list(folder, libraries);
        return libraries;
    }

    protected static void list(File folder, ArrayList<Library> libraries) throws IOException {
        Library.list(folder, libraries, null);
    }

    protected static void list(File folder, ArrayList<Library> libraries, String subfolder) throws IOException {
        String[] list;
        if (folder.isDirectory() && (list = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.charAt(0) == '.') {
                    return false;
                }
                if (name.equals("CVS")) {
                    return false;
                }
                return new File(dir, name).isDirectory();
            }
        })) != null) {
            Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String potentialName = stringArray[n2];
                File baseFolder = new File(folder, potentialName);
                File libraryFolder = new File(baseFolder, "library");
                File libraryJar = new File(libraryFolder, String.valueOf(potentialName) + ".jar");
                if (libraryJar.exists()) {
                    String sanityCheck = Sketch.sanitizeName(potentialName);
                    if (sanityCheck.equals(potentialName)) {
                        libraries.add(new Library(baseFolder, subfolder));
                    } else {
                        String mess = "The library \"" + potentialName + "\" cannot be used.\n" + "Library names must contain only basic letters and numbers.\n" + "(ASCII only and no spaces, and it cannot start with a number)";
                        Base.showMessage("Ignoring bad library name", mess);
                    }
                } else if (subfolder == null) {
                    Library.list(new File(folder, potentialName), libraries, potentialName);
                }
                ++n2;
            }
        }
    }
}

