/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Preferences;
import processing.core.PApplet;

public class UpdateCheck {
    Base base;
    String downloadURL = "http://processing.org/download/latest.txt";
    static final long ONE_DAY = 86400000L;

    public UpdateCheck(Base base) {
        this.base = base;
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(30000L);
                    UpdateCheck.this.updateCheck();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void updateCheck() throws Exception {
        Object[] options;
        int result;
        long when;
        Random r = new Random();
        long id = r.nextLong();
        String idString = Preferences.get("update.id");
        if (idString != null) {
            id = Long.parseLong(idString);
        } else {
            Preferences.set("update.id", String.valueOf(id));
        }
        String info = URLEncoder.encode(String.valueOf(id) + "\t" + PApplet.nf((int)197, (int)4) + "\t" + System.getProperty("java.version") + "\t" + System.getProperty("java.vendor") + "\t" + System.getProperty("os.name") + "\t" + System.getProperty("os.version") + "\t" + System.getProperty("os.arch"), "UTF-8");
        int latest = this.readInt(String.valueOf(this.downloadURL) + "?" + info);
        String lastString = Preferences.get("update.last");
        long now = System.currentTimeMillis();
        if (lastString != null && now - (when = Long.parseLong(lastString)) < 86400000L) {
            return;
        }
        Preferences.set("update.last", String.valueOf(now));
        String prompt = "A new version of Processing is available,\nwould you like to visit the Processing download page?";
        if (this.base.activeEditor != null && latest > 197 && (result = JOptionPane.showOptionDialog(this.base.activeEditor, prompt, "Update", 0, 3, null, options = new Object[]{"Yes", "No"}, options[0])) == 0) {
            Base.openURL("http://processing.org/download/");
        }
    }

    protected int readInt(String filename) throws Exception {
        URL url = new URL(filename);
        InputStream stream = url.openStream();
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(isr);
        return Integer.parseInt(reader.readLine());
    }
}

