/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.HttpConstants;
import processing.app.WebServer;

class WebServerWorker
implements HttpConstants,
Runnable {
    ZipFile zip;
    HashMap<String, ZipEntry> entries;
    static final int BUF_SIZE = 2048;
    static final byte[] EOL = new byte[]{13, 10};
    byte[] buf;
    private Socket s;
    static Hashtable map = new Hashtable();

    static {
        WebServerWorker.fillMap();
    }

    WebServerWorker(ZipFile zip, HashMap entries) {
        this.entries = entries;
        this.zip = zip;
        this.buf = new byte[2048];
        this.s = null;
    }

    synchronized void setSocket(Socket s) {
        this.s = s;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            Vector pool;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    continue;
                }
            }
            try {
                this.handleClient();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.s = null;
            Vector vector = pool = WebServer.threads;
            synchronized (vector) {
                if (pool.size() >= WebServer.workers) {
                    return;
                }
                pool.addElement(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleClient() throws IOException {
        BufferedInputStream is = new BufferedInputStream(this.s.getInputStream());
        PrintStream ps = new PrintStream(this.s.getOutputStream());
        this.s.setSoTimeout(WebServer.timeout);
        this.s.setTcpNoDelay(true);
        int i = 0;
        while (i < 2048) {
            this.buf[i] = 0;
            ++i;
        }
        try {
            int index;
            boolean doingGet;
            int nread = 0;
            int r = 0;
            block5: while (nread < 2048) {
                r = ((InputStream)is).read(this.buf, nread, 2048 - nread);
                if (r == -1) {
                    return;
                }
                int i2 = nread;
                nread += r;
                while (i2 < nread) {
                    if (this.buf[i2] == 10 || this.buf[i2] == 13) break block5;
                    ++i2;
                }
            }
            if (this.buf[0] == 71 && this.buf[1] == 69 && this.buf[2] == 84 && this.buf[3] == 32) {
                doingGet = true;
                index = 4;
            } else if (this.buf[0] == 72 && this.buf[1] == 69 && this.buf[2] == 65 && this.buf[3] == 68 && this.buf[4] == 32) {
                doingGet = false;
                index = 5;
            } else {
                ps.print("HTTP/1.0 405 unsupported method type: ");
                ps.write(this.buf, 0, 5);
                ps.write(EOL);
                ps.flush();
                this.s.close();
                return;
            }
            int i3 = 0;
            i3 = index;
            while (i3 < nread) {
                if (this.buf[i3] == 32) break;
                ++i3;
            }
            String fname = new String(this.buf, index, i3 - index);
            ZipEntry entry = this.entries.get(fname.substring(1));
            boolean ok = this.printHeaders(entry, ps);
            if (entry != null) {
                InputStream stream = this.zip.getInputStream(entry);
                if (!doingGet || !ok) return;
                this.sendFile(stream, ps);
                return;
            } else {
                this.send404(ps);
            }
            return;
        }
        finally {
            this.s.close();
        }
    }

    boolean printHeaders(ZipEntry targ, PrintStream ps) throws IOException {
        boolean ret = false;
        int rCode = 0;
        if (targ == null) {
            rCode = 404;
            ps.print("HTTP/1.0 404 Not Found");
            ps.write(EOL);
            ret = false;
        } else {
            rCode = 200;
            ps.print("HTTP/1.0 200 OK");
            ps.write(EOL);
            ret = true;
        }
        if (targ != null) {
            WebServer.log("From " + this.s.getInetAddress().getHostAddress() + ": GET " + targ.getName() + " --> " + rCode);
        }
        ps.print("Server: Processing Documentation Server");
        ps.write(EOL);
        ps.print("Date: " + new Date());
        ps.write(EOL);
        if (ret) {
            if (!targ.isDirectory()) {
                ps.print("Content-length: " + targ.getSize());
                ps.write(EOL);
                ps.print("Last Modified: " + new Date(targ.getTime()));
                ps.write(EOL);
                String name = targ.getName();
                int ind = name.lastIndexOf(46);
                String ct = null;
                if (ind > 0) {
                    ct = (String)map.get(name.substring(ind));
                }
                if (ct == null) {
                    ct = "application/x-unknown-content-type";
                }
                ps.print("Content-type: " + ct);
                ps.write(EOL);
            } else {
                ps.print("Content-type: text/html");
                ps.write(EOL);
            }
        }
        ps.write(EOL);
        return ret;
    }

    boolean printHeaders(File targ, PrintStream ps) throws IOException {
        boolean ret = false;
        int rCode = 0;
        if (!targ.exists()) {
            rCode = 404;
            ps.print("HTTP/1.0 404 Not Found");
            ps.write(EOL);
            ret = false;
        } else {
            rCode = 200;
            ps.print("HTTP/1.0 200 OK");
            ps.write(EOL);
            ret = true;
        }
        WebServer.log("From " + this.s.getInetAddress().getHostAddress() + ": GET " + targ.getAbsolutePath() + "-->" + rCode);
        ps.print("Server: Simple java");
        ps.write(EOL);
        ps.print("Date: " + new Date());
        ps.write(EOL);
        if (ret) {
            if (!targ.isDirectory()) {
                ps.print("Content-length: " + targ.length());
                ps.write(EOL);
                ps.print("Last Modified: " + new Date(targ.lastModified()));
                ps.write(EOL);
                String name = targ.getName();
                int ind = name.lastIndexOf(46);
                String ct = null;
                if (ind > 0) {
                    ct = (String)map.get(name.substring(ind));
                }
                if (ct == null) {
                    ct = "unknown/unknown";
                }
                ps.print("Content-type: " + ct);
                ps.write(EOL);
            } else {
                ps.print("Content-type: text/html");
                ps.write(EOL);
            }
        }
        return ret;
    }

    void send404(PrintStream ps) throws IOException {
        ps.write(EOL);
        ps.write(EOL);
        ps.print("<html><body><h1>404 Not Found</h1>The requested resource was not found.</body></html>");
        ps.write(EOL);
        ps.write(EOL);
    }

    void sendFile(File targ, PrintStream ps) throws IOException {
        FileInputStream is = null;
        ps.write(EOL);
        if (targ.isDirectory()) {
            this.listDirectory(targ, ps);
            return;
        }
        is = new FileInputStream(targ.getAbsolutePath());
        this.sendFile(is, ps);
    }

    void sendFile(InputStream is, PrintStream ps) throws IOException {
        try {
            int n;
            while ((n = is.read(this.buf)) > 0) {
                ps.write(this.buf, 0, n);
            }
        }
        finally {
            is.close();
        }
    }

    static void setSuffix(String k, String v) {
        map.put(k, v);
    }

    static void fillMap() {
        WebServerWorker.setSuffix("", "content/unknown");
        WebServerWorker.setSuffix(".uu", "application/octet-stream");
        WebServerWorker.setSuffix(".exe", "application/octet-stream");
        WebServerWorker.setSuffix(".ps", "application/postscript");
        WebServerWorker.setSuffix(".zip", "application/zip");
        WebServerWorker.setSuffix(".sh", "application/x-shar");
        WebServerWorker.setSuffix(".tar", "application/x-tar");
        WebServerWorker.setSuffix(".snd", "audio/basic");
        WebServerWorker.setSuffix(".au", "audio/basic");
        WebServerWorker.setSuffix(".wav", "audio/x-wav");
        WebServerWorker.setSuffix(".gif", "image/gif");
        WebServerWorker.setSuffix(".jpg", "image/jpeg");
        WebServerWorker.setSuffix(".jpeg", "image/jpeg");
        WebServerWorker.setSuffix(".htm", "text/html");
        WebServerWorker.setSuffix(".html", "text/html");
        WebServerWorker.setSuffix(".css", "text/css");
        WebServerWorker.setSuffix(".java", "text/javascript");
        WebServerWorker.setSuffix(".txt", "text/plain");
        WebServerWorker.setSuffix(".java", "text/plain");
        WebServerWorker.setSuffix(".c", "text/plain");
        WebServerWorker.setSuffix(".cc", "text/plain");
        WebServerWorker.setSuffix(".c++", "text/plain");
        WebServerWorker.setSuffix(".h", "text/plain");
        WebServerWorker.setSuffix(".pl", "text/plain");
    }

    void listDirectory(File dir, PrintStream ps) throws IOException {
        ps.println("<TITLE>Directory listing</TITLE><P>\n");
        ps.println("<A HREF=\"..\">Parent Directory</A><BR>\n");
        String[] list = dir.list();
        int i = 0;
        while (list != null && i < list.length) {
            File f = new File(dir, list[i]);
            if (f.isDirectory()) {
                ps.println("<A HREF=\"" + list[i] + "/\">" + list[i] + "/</A><BR>");
            } else {
                ps.println("<A HREF=\"" + list[i] + "\">" + list[i] + "</A><BR");
            }
            ++i;
        }
        ps.println("<P><HR><BR><I>" + new Date() + "</I>");
    }
}

