/*
 * Decompiled with CFR 0.152.
 */
package processing.app.exec;

import java.io.IOException;
import java.io.StringWriter;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.ProcessResult;
import processing.app.exec.StreamPump;
import processing.core.PApplet;

public class ProcessHelper {
    private final String[] cmd;

    public ProcessHelper(String ... cmd) {
        this.cmd = cmd;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.cmd.length) {
            if (i != 0) {
                buffer.append(' ');
            }
            buffer.append(this.cmd[i]);
            ++i;
        }
        return buffer.toString();
    }

    public ProcessResult execute() throws InterruptedException, IOException {
        StringWriter outWriter = new StringWriter();
        StringWriter errWriter = new StringWriter();
        long startTime = System.currentTimeMillis();
        String prettyCommand = this.toString();
        Process process = Runtime.getRuntime().exec(this.cmd);
        ProcessRegistry.watch(process);
        try {
            String title = PApplet.join((String[])this.cmd, (char)' ');
            new StreamPump(process.getInputStream(), "out: " + title).addTarget(outWriter).start();
            new StreamPump(process.getErrorStream(), "err: " + title).addTarget(errWriter).start();
            try {
                int result = process.waitFor();
                long time = System.currentTimeMillis() - startTime;
                ProcessResult processResult = new ProcessResult(prettyCommand, result, outWriter.toString(), errWriter.toString(), time);
                return processResult;
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted: " + prettyCommand);
                throw e;
            }
        }
        finally {
            process.destroy();
            ProcessRegistry.unwatch(process);
        }
    }
}

