/*
 * Decompiled with CFR 0.152.
 */
package processing.app.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import processing.app.Base;
import processing.app.exec.LineProcessor;

public class StreamPump
implements Runnable {
    private static final ExecutorService threads = Executors.newCachedThreadPool(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("StreamPump " + t.getId());
            return t;
        }
    });
    private final BufferedReader reader;
    private final List<LineProcessor> outs = new CopyOnWriteArrayList<LineProcessor>();
    private final String name;

    public StreamPump(InputStream in, String name) {
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.name = name;
    }

    public StreamPump addTarget(OutputStream out) {
        this.outs.add(new WriterLineProcessor(out));
        return this;
    }

    public StreamPump addTarget(Writer out) {
        this.outs.add(new WriterLineProcessor(out));
        return this;
    }

    public StreamPump addTarget(LineProcessor out) {
        this.outs.add(out);
        return this;
    }

    public void start() {
        threads.execute(this);
    }

    public void run() {
        block6: {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    for (LineProcessor out : this.outs) {
                        try {
                            out.processLine(line);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (IOException e) {
                if (!Base.DEBUG) break block6;
                System.err.println("StreamPump: " + this.name);
                e.printStackTrace(System.err);
                throw new RuntimeException("Inside " + this + " for " + this.name, e);
            }
        }
    }

    private static class WriterLineProcessor
    implements LineProcessor {
        private final PrintWriter writer;

        private WriterLineProcessor(OutputStream out) {
            this.writer = new PrintWriter(out, true);
        }

        private WriterLineProcessor(Writer writer) {
            this.writer = new PrintWriter(writer, true);
        }

        public void processLine(String line) {
            this.writer.println(line);
        }
    }
}

