/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import processing.app.Base;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.syntax.DefaultInputHandler;
import processing.app.syntax.InputHandler;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaDefaults;

public class PdeTextAreaDefaults
extends TextAreaDefaults {
    public PdeTextAreaDefaults(Mode theme) {
        this.inputHandler = new DefaultInputHandler();
        String mod = Base.isMacOS() ? "A" : "C";
        this.inputHandler.addKeyBinding("BACK_SPACE", InputHandler.BACKSPACE);
        if (Preferences.getBoolean("editor.keys.shift_backspace_is_delete")) {
            this.inputHandler.addKeyBinding("S+BACK_SPACE", InputHandler.DELETE);
        } else {
            this.inputHandler.addKeyBinding("S+BACK_SPACE", InputHandler.BACKSPACE);
        }
        this.inputHandler.addKeyBinding("DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding("S+DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+BACK_SPACE", InputHandler.BACKSPACE_WORD);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+DELETE", InputHandler.DELETE_WORD);
        this.inputHandler.addKeyBinding("INSERT", InputHandler.OVERWRITE);
        if (Preferences.getBoolean("editor.keys.alternative_cut_copy_paste")) {
            this.inputHandler.addKeyBinding("C+INSERT", InputHandler.CLIPBOARD_COPY);
            this.inputHandler.addKeyBinding("S+INSERT", InputHandler.CLIPBOARD_PASTE);
            this.inputHandler.addKeyBinding("S+DELETE", InputHandler.CLIPBOARD_CUT);
        }
        if (Preferences.getBoolean("editor.keys.home_and_end_travel_far")) {
            this.inputHandler.addKeyBinding("HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_DOC_END);
        } else {
            this.inputHandler.addKeyBinding("HOME", InputHandler.HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_END);
            this.inputHandler.addKeyBinding("C+HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("C+END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_DOC_END);
        }
        if (Base.isMacOS()) {
            this.inputHandler.addKeyBinding("M+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("M+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("MS+LEFT", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("MS+RIGHT", InputHandler.SELECT_END);
        } else {
            this.inputHandler.addKeyBinding("C+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("C+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_END);
        }
        this.inputHandler.addKeyBinding("PAGE_UP", InputHandler.PREV_PAGE);
        this.inputHandler.addKeyBinding("PAGE_DOWN", InputHandler.NEXT_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_UP", InputHandler.SELECT_PREV_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_DOWN", InputHandler.SELECT_NEXT_PAGE);
        this.inputHandler.addKeyBinding("LEFT", InputHandler.PREV_CHAR);
        this.inputHandler.addKeyBinding("S+LEFT", InputHandler.SELECT_PREV_CHAR);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+LEFT", InputHandler.PREV_WORD);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "S+LEFT", InputHandler.SELECT_PREV_WORD);
        this.inputHandler.addKeyBinding("RIGHT", InputHandler.NEXT_CHAR);
        this.inputHandler.addKeyBinding("S+RIGHT", InputHandler.SELECT_NEXT_CHAR);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+RIGHT", InputHandler.NEXT_WORD);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "S+RIGHT", InputHandler.SELECT_NEXT_WORD);
        this.inputHandler.addKeyBinding("UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding("S+UP", InputHandler.SELECT_PREV_LINE);
        this.inputHandler.addKeyBinding("DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding("S+DOWN", InputHandler.SELECT_NEXT_LINE);
        this.inputHandler.addKeyBinding("MS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("CS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("MS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding("CS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding(String.valueOf(mod) + "+ENTER", InputHandler.REPEAT);
        this.document = new SyntaxDocument();
        this.editable = true;
        this.electricScroll = 3;
        this.caretVisible = true;
        this.caretBlinks = true;
        this.cols = 80;
        this.rows = 15;
        this.font = Preferences.getFont("editor.font");
        this.antialias = Preferences.getBoolean("editor.antialias");
        this.styles = new SyntaxStyle[11];
        this.styles[1] = theme.getStyle("comment1");
        this.styles[2] = theme.getStyle("comment2");
        this.styles[6] = theme.getStyle("keyword1");
        this.styles[7] = theme.getStyle("keyword2");
        this.styles[8] = theme.getStyle("keyword3");
        this.styles[3] = theme.getStyle("literal1");
        this.styles[4] = theme.getStyle("literal2");
        this.styles[5] = theme.getStyle("label");
        this.styles[9] = theme.getStyle("operator");
        this.styles[10] = theme.getStyle("invalid");
        this.fgcolor = theme.getColor("editor.fgcolor");
        this.bgcolor = theme.getColor("editor.bgcolor");
        this.caretColor = theme.getColor("editor.caret.color");
        this.selectionColor = theme.getColor("editor.selection.color");
        this.lineHighlight = theme.getBoolean("editor.linehighlight");
        this.lineHighlightColor = theme.getColor("editor.linehighlight.color");
        this.bracketHighlight = theme.getBoolean("editor.brackethighlight");
        this.bracketHighlightColor = theme.getColor("editor.brackethighlight.color");
        this.eolMarkers = theme.getBoolean("editor.eolmarkers");
        this.eolMarkerColor = theme.getColor("editor.eolmarkers.color");
    }
}

