/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.File;
import java.io.IOException;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.tools.Tool;
import processing.mode.java.JavaBuild;

public class ExportExamples
implements Tool {
    static final String DELETE_TARGET = "export.delete_target_folder";
    static final String SEPARATE_JAR = "export.applet.separate_jar_files";
    Editor orig;
    Base base;
    File[] folders;
    File outputFolder;
    String examplesPath;

    public void init(Editor editor) {
        this.orig = editor;
        this.base = editor.getBase();
        Mode mode = editor.getMode();
        this.folders = mode.getExampleCategoryFolders();
        this.examplesPath = mode.getExamplesFolder().getAbsolutePath();
        File desktop = new File(System.getProperty("user.home"), "Desktop");
        this.outputFolder = new File(desktop, "examples");
    }

    public void run() {
        new Thread(new Runnable(){

            public void run() {
                if (ExportExamples.this.outputFolder.exists()) {
                    Base.showWarning("Try Again", "Please remove the examples folder from the desktop,\nbecause that's where I wanna put things.", null);
                    return;
                }
                boolean delete2 = Preferences.getBoolean(ExportExamples.DELETE_TARGET);
                Preferences.setBoolean(ExportExamples.DELETE_TARGET, false);
                boolean separate = Preferences.getBoolean(ExportExamples.SEPARATE_JAR);
                Preferences.setBoolean(ExportExamples.SEPARATE_JAR, true);
                File[] fileArray = ExportExamples.this.folders;
                int n = ExportExamples.this.folders.length;
                int n2 = 0;
                while (n2 < n) {
                    File folder = fileArray[n2];
                    if (!folder.getName().equals("Books")) {
                        ExportExamples.this.handleFolder(folder);
                    }
                    ++n2;
                }
                Preferences.setBoolean(ExportExamples.DELETE_TARGET, delete2);
                Preferences.setBoolean(ExportExamples.SEPARATE_JAR, separate);
                ExportExamples.this.orig.statusNotice("Finished exporting examples.");
            }
        }).start();
    }

    public void handleFolder(File folder) {
        block9: {
            File pdeFile = new File(folder, String.valueOf(folder.getName()) + ".pde");
            if (pdeFile.exists()) {
                String pdePath = pdeFile.getAbsolutePath();
                Editor editor = this.base.handleOpen(pdePath);
                if (editor != null) {
                    try {
                        if (!this.handle(editor)) break block9;
                        this.base.handleClose(editor, false);
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                File[] sub;
                File[] fileArray = sub = folder.listFiles();
                int n = sub.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        this.handleFolder(f);
                    }
                    ++n2;
                }
            }
        }
    }

    public boolean handle(Editor editor) throws SketchException, IOException {
        Sketch sketch = editor.getSketch();
        File sketchFolder = sketch.getFolder();
        String sketchPath = sketchFolder.getAbsolutePath();
        String uniquePath = sketchPath.substring(this.examplesPath.length());
        File sketchTarget = new File(this.outputFolder, uniquePath);
        File appletFolder = new File(sketchTarget, "applet");
        JavaBuild build = new JavaBuild(sketch);
        boolean result = build.exportApplet(appletFolder);
        File coreTarget = new File(this.outputFolder, "core.jar");
        File sketchCore = new File(appletFolder, "core.jar");
        if (!coreTarget.exists()) {
            Base.copyFile(sketchCore, coreTarget);
        }
        sketchCore.delete();
        File loadingTarget = new File(this.outputFolder, "loading.gif");
        if (!loadingTarget.exists()) {
            Base.copyFile(new File(appletFolder, "loading.gif"), loadingTarget);
        }
        new File(appletFolder, "index.html").delete();
        new File(appletFolder, "loading.gif").delete();
        new File(appletFolder, String.valueOf(sketch.getName()) + ".java").delete();
        return result;
    }

    public String getMenuTitle() {
        return "Export Examples";
    }
}

