/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.PointerType;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.windows.Registry;
import processing.core.PApplet;

public class Platform
extends processing.app.Platform {
    static final String openCommand = String.valueOf(System.getProperty("user.dir").replace('/', '\\')) + "\\processing.exe \"%1\"";
    static final String DOC = "Processing.Document";
    static WinLibC clib = (WinLibC)Native.loadLibrary((String)"msvcrt", WinLibC.class);
    private static Map<String, Object> OPTIONS = new HashMap<String, Object>();

    static {
        OPTIONS.put("type-mapper", W32APITypeMapper.UNICODE);
        OPTIONS.put("function-mapper", W32APIFunctionMapper.UNICODE);
    }

    public void init(Base base) {
        super.init(base);
        this.checkAssociations();
        this.checkQuickTime();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            String knownCommand = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Processing.Document\\shell\\open\\command", "");
            if (knownCommand == null) {
                if (Preferences.getBoolean("platform.auto_file_type_associations")) {
                    this.setAssociations();
                }
            } else if (!knownCommand.equals(openCommand) && Preferences.getBoolean("platform.auto_file_type_associations")) {
                this.setAssociations();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        if (!(Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "", ".pde") && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, ".pde", "", DOC) && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "", DOC) && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, DOC, "", "Processing Source Code") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, DOC, "shell") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Processing.Document\\shell", "open") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Processing.Document\\shell\\open", "command") && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Processing.Document\\shell\\open\\command", "", openCommand))) {
            Preferences.setBoolean("platform.auto_file_type_associations", false);
        }
    }

    protected void checkQuickTime() {
        try {
            File qtjavaZip;
            String qtsystemPath = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.LOCAL_MACHINE, "Software\\Apple Computer, Inc.\\QuickTime", "QTSysDir");
            if (qtsystemPath != null && (qtjavaZip = new File(qtsystemPath, "QTJava.zip")).exists()) {
                String qtjavaZipPath = qtjavaZip.getAbsolutePath();
                String cp = System.getProperty("java.class.path");
                System.setProperty("java.class.path", String.valueOf(cp) + File.pathSeparator + qtjavaZipPath);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        String[] stringArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            File directory;
            String item = stringArray[n2];
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if ((directory = new File(item)).exists() && item.trim().length() != 0) {
                legit[legitCount++] = item;
            }
            ++n2;
        }
        String newPath = PApplet.join((String[])(legit = PApplet.subset((String[])legit, (int)0, (int)legitCount)), (String)File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    public File getSettingsFolder() throws Exception {
        char[] pszPath = new char[260];
        int hResult = Shell32.INSTANCE.SHGetFolderPath(null, 26, null, 0, pszPath);
        if (hResult != 0) {
            throw new Exception("Problem city, population your computer");
        }
        String appDataPath = new String(pszPath);
        int len = appDataPath.indexOf("\u0000");
        appDataPath = appDataPath.substring(0, len);
        return new File(appDataPath, "Processing");
    }

    public File getDefaultSketchbookFolder() throws Exception {
        char[] pszPath = new char[260];
        int hResult = Shell32.INSTANCE.SHGetFolderPath(null, 5, null, 0, pszPath);
        if (hResult != 0) {
            throw new Exception("Problem city, population your computer");
        }
        String personalPath = new String(pszPath);
        int len = personalPath.indexOf("\u0000");
        personalPath = personalPath.substring(0, len);
        return new File(personalPath, "Processing");
    }

    public void openURL(String url) throws Exception {
        if (url.startsWith("http://")) {
            Runtime.getRuntime().exec("cmd /c start " + url);
        } else {
            Runtime.getRuntime().exec("cmd /c \"" + url + "\"");
        }
    }

    public boolean openFolderAvailable() {
        return true;
    }

    public void openFolder(File file) throws Exception {
        String folder = file.getAbsolutePath();
        Runtime.getRuntime().exec("explorer \"" + folder + "\"");
    }

    public void setenv(String variable, String value) {
        clib._putenv(String.valueOf(variable) + "=" + value);
    }

    public String getenv(String variable) {
        return System.getenv(variable);
    }

    public int unsetenv(String variable) {
        return clib._putenv(String.valueOf(variable) + "=");
    }

    static /* synthetic */ Map access$0() {
        return OPTIONS;
    }

    static class HANDLE
    extends PointerType
    implements NativeMapped {
        HANDLE() {
        }
    }

    static class HWND
    extends HANDLE {
        HWND() {
        }
    }

    public static interface Shell32
    extends Library {
        public static final int MAX_PATH = 260;
        public static final int SHGFP_TYPE_CURRENT = 0;
        public static final int SHGFP_TYPE_DEFAULT = 1;
        public static final int S_OK = 0;
        public static final int CSIDL_APPDATA = 26;
        public static final int CSIDL_PERSONAL = 5;
        public static final Shell32 INSTANCE = (Shell32)Native.loadLibrary((String)"shell32", Shell32.class, (Map)Platform.access$0());

        public int SHGetFolderPath(HWND var1, int var2, HANDLE var3, int var4, char[] var5);
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

