/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import processing.app.Base;
import processing.app.Editor;
import processing.app.EditorToolbar;
import processing.mode.android.AndroidEditor;

public class AndroidToolbar
extends EditorToolbar {
    protected static final int RUN = 0;
    protected static final int STOP = 1;
    protected static final int NEW = 2;
    protected static final int OPEN = 3;
    protected static final int SAVE = 4;
    protected static final int EXPORT = 5;

    public AndroidToolbar(Editor editor, Base base) {
        super(editor, base);
    }

    public void init() {
        Image[][] images = this.loadImages();
        int i = 0;
        while (i < 6) {
            this.addButton(AndroidToolbar.getTitle(i, false), AndroidToolbar.getTitle(i, true), images[i], i == 2);
            ++i;
        }
    }

    public static String getTitle(int index, boolean shift) {
        switch (index) {
            case 0: {
                return !shift ? "Run in Emulator" : "Run on Device";
            }
            case 1: {
                return "Stop";
            }
            case 2: {
                return !shift ? "New" : "New Editor Window";
            }
            case 3: {
                return !shift ? "Open" : "Open in Another Window";
            }
            case 4: {
                return "Save";
            }
            case 5: {
                return !shift ? "Export Android Project" : "Export Signed Package";
            }
        }
        return null;
    }

    public void handlePressed(MouseEvent e, int sel) {
        boolean shift = e.isShiftDown();
        AndroidEditor aeditor = (AndroidEditor)this.editor;
        switch (sel) {
            case 0: {
                if (shift) {
                    aeditor.handleRunDevice();
                    break;
                }
                aeditor.handleRunEmulator();
                break;
            }
            case 1: {
                aeditor.handleStop();
                break;
            }
            case 3: {
                JPopupMenu popup = this.editor.getMode().getToolbarMenu().getPopupMenu();
                popup.show(this, e.getX(), e.getY());
                break;
            }
            case 2: {
                if (shift) {
                    this.base.handleNew();
                    break;
                }
                this.base.handleNewReplace();
                break;
            }
            case 4: {
                aeditor.handleSaveRequest(false);
                break;
            }
            case 5: {
                if (shift) {
                    aeditor.handleExportPackage();
                    break;
                }
                aeditor.handleExportProject();
            }
        }
    }
}

