/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import processing.app.Base;
import processing.app.exec.ProcessResult;
import processing.mode.android.AndroidSDK;
import processing.mode.android.Device;
import processing.mode.android.EmulatorController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Devices {
    private static final String ADB_DEVICES_ERROR = "Received unfamiliar output from \u201cadb devices\u201d.\nThe device list may have errors.";
    private static final Devices INSTANCE = new Devices();
    private final Map<String, Device> devices = new ConcurrentHashMap<String, Device>();
    private final ExecutorService deviceLaunchThread = Executors.newSingleThreadExecutor();

    public static Devices getInstance() {
        return INSTANCE;
    }

    public static void killAdbServer() {
        System.out.println("Shutting down any existing adb server...");
        System.out.flush();
        try {
            AndroidSDK.runADB("kill-server");
        }
        catch (Exception e) {
            System.err.println("failed.");
            System.err.println();
            e.printStackTrace(System.err);
        }
    }

    private Devices() {
        if (Base.DEBUG) {
            System.out.println("Starting up Devices");
        }
        Runtime.getRuntime().addShutdownHook(new Thread("AndroidEnvironment Shutdown"){

            public void run() {
                Devices.this.shutdown();
            }
        });
    }

    private void shutdown() {
        for (Device device : new ArrayList<Device>(this.devices.values())) {
            device.shutdown();
        }
    }

    public Future<Device> getEmulator() {
        Callable<Device> androidFinder = new Callable<Device>(){

            @Override
            public Device call() throws Exception {
                return Devices.this.blockingGetEmulator();
            }
        };
        FutureTask<Device> task = new FutureTask<Device>(androidFinder);
        this.deviceLaunchThread.execute(task);
        return task;
    }

    private final Device blockingGetEmulator() {
        Device emu = this.find(true);
        if (emu != null) {
            return emu;
        }
        EmulatorController emuController = EmulatorController.getInstance();
        if (emuController.getState() == EmulatorController.State.NOT_RUNNING) {
            try {
                emuController.launch();
            }
            catch (IOException e) {
                System.err.println("Problem while launching emulator.");
                e.printStackTrace(System.err);
                return null;
            }
        } else {
            System.out.println("Emulator is " + (Object)((Object)emuController.getState()) + ", which is not expected.");
        }
        while (!Thread.currentThread().isInterrupted()) {
            if (emuController.getState() == EmulatorController.State.NOT_RUNNING) {
                System.err.println("Ouch. Emulator got killed, I think.");
                return null;
            }
            emu = this.find(true);
            if (emu != null) {
                return emu;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.err.println("Devices: interrupted in loop.");
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Device find(boolean wantEmulator) {
        this.refresh();
        Map<String, Device> map = this.devices;
        synchronized (map) {
            for (Device device : this.devices.values()) {
                boolean isEmulator = device.getId().contains("emulator");
                if ((!isEmulator || !wantEmulator) && (isEmulator || wantEmulator)) continue;
                return device;
            }
        }
        return null;
    }

    public Future<Device> getHardware() {
        Callable<Device> androidFinder = new Callable<Device>(){

            @Override
            public Device call() throws Exception {
                return Devices.this.blockingGetHardware();
            }
        };
        FutureTask<Device> task = new FutureTask<Device>(androidFinder);
        this.deviceLaunchThread.execute(task);
        return task;
    }

    /*
     * Unable to fully structure code
     */
    private final Device blockingGetHardware() {
        hardware = this.find(false);
        if (hardware == null) ** GOTO lbl12
        return hardware;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                return null;
            }
            hardware = this.find(false);
            if (hardware == null) continue;
            return hardware;
lbl12:
            // 2 sources

            ** while (!Thread.currentThread().isInterrupted())
        }
lbl13:
        // 1 sources

        return null;
    }

    private void refresh() {
        List<String> activeDevices = Devices.list();
        for (String deviceId : activeDevices) {
            if (this.devices.containsKey(deviceId)) continue;
            this.addDevice(new Device(this, deviceId));
        }
    }

    private void addDevice(Device device) {
        try {
            device.initialize();
            if (this.devices.put(device.getId(), device) != null) {
                throw new IllegalStateException("Adding " + device + ", which already exists!");
            }
        }
        catch (Exception e) {
            System.err.println("While initializing " + device.getId() + ": " + e);
        }
    }

    void deviceRemoved(Device device) {
        if (this.devices.remove(device.getId()) == null) {
            throw new IllegalStateException("I didn't know about device " + device.getId() + "!");
        }
    }

    public static List<String> list() {
        ProcessResult result;
        try {
            result = AndroidSDK.runADB("devices");
        }
        catch (InterruptedException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            System.err.println("Problem inside Devices.list()");
            e.printStackTrace();
            return Collections.emptyList();
        }
        if (!result.succeeded()) {
            if (result.getStderr().contains("protocol fault (no status)")) {
                System.err.println("bleh: " + result);
            } else {
                System.err.println("nope: " + result);
            }
            return Collections.emptyList();
        }
        String stdout = result.getStdout();
        if (!stdout.startsWith("List of devices") && stdout.trim().length() != 0) {
            System.err.println(ADB_DEVICES_ERROR);
            System.err.println("Output was \u201c" + stdout + "\u201d");
            return Collections.emptyList();
        }
        ArrayList<String> devices = new ArrayList<String>();
        for (String line : result) {
            String[] fields;
            if (!line.contains("\t") || !(fields = line.split("\t"))[1].equals("device")) continue;
            devices.add(fields[0]);
        }
        return devices;
    }
}

