/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.exec.LineProcessor;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.StreamPump;
import processing.core.PApplet;
import processing.mode.android.AVD;

class EmulatorController {
    private static final EmulatorController INSTANCE = new EmulatorController();
    private volatile State state = State.NOT_RUNNING;

    EmulatorController() {
    }

    public static EmulatorController getInstance() {
        return INSTANCE;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        if (Base.DEBUG) {
            System.out.println("Emulator state: " + (Object)((Object)state));
            new Exception().printStackTrace(System.out);
        }
        this.state = state;
    }

    public synchronized void launch() throws IOException {
        if (this.state != State.NOT_RUNNING) {
            String illegal = "You can't launch an emulator whose state is " + (Object)((Object)this.state);
            throw new IllegalStateException(illegal);
        }
        String portString = Preferences.get("android.emulator.port");
        if (portString == null) {
            portString = "5566";
            Preferences.set("android.emulator.port", portString);
        }
        String[] cmd = new String[]{"emulator", "-avd", AVD.defaultAVD.name, "-port", portString, "-no-boot-anim"};
        final Process p = Runtime.getRuntime().exec(cmd);
        ProcessRegistry.watch(p);
        new StreamPump(p.getInputStream(), "emulator: ").addTarget(System.out).start();
        this.setState(State.WAITING_FOR_BOOT);
        final String title = PApplet.join((String[])cmd, (char)' ');
        StreamPump outie = new StreamPump(p.getInputStream(), "out: " + title);
        outie.addTarget(new LineProcessor(){

            public void processLine(String line) {
                if (!line.contains("the cache image is used by another emulator")) {
                    System.out.println(String.valueOf(title) + ": " + line);
                }
            }
        });
        StreamPump errie = new StreamPump(p.getErrorStream(), "err: " + title);
        errie.addTarget(new LineProcessor(){

            public void processLine(String line) {
                if (!line.contains("This application, or a library it uses, is using NSQuickDrawView")) {
                    System.err.println(String.valueOf(title) + ": " + line);
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, "EmulatorController: Wait for emulator to boot").start();
        new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException e) {
                            System.err.println("Emulator was interrupted.");
                            p.destroy();
                            ProcessRegistry.unwatch(p);
                        }
                    }
                    finally {
                        p.destroy();
                        ProcessRegistry.unwatch(p);
                    }
                }
                finally {
                    EmulatorController.this.setState(State.NOT_RUNNING);
                }
            }
        }, "EmulatorController: Process manager").start();
        try {
            latch.await();
        }
        catch (InterruptedException drop) {
            System.err.println("Interrupted while waiting for emulator to launch.");
        }
    }

    static /* synthetic */ State access$0(EmulatorController emulatorController) {
        return emulatorController.state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_RUNNING,
        WAITING_FOR_BOOT,
        RUNNING;

    }
}

