/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import processing.app.Base;
import processing.app.Sketch;
import processing.core.PApplet;
import processing.mode.android.AndroidMode;
import processing.xml.XMLElement;

public class Manifest {
    static final String MANIFEST_XML = "AndroidManifest.xml";
    static final String WORLD_OF_HURT_COMING = "Errors occurred while reading or writing AndroidManifest.xml,\nwhich means lots of things are likely to stop working properly.\nTo prevent losing any data, it's recommended that you use \u201cSave As\u201d\nto save a separate copy of your sketch, and the restart Processing.";
    static final String MULTIPLE_ACTIVITIES = "Processing only supports a single Activity in the AndroidManifest.xml\nfile. Only the first activity entry will be updated, and you better \nhope that's the right one, smartypants.";
    private Sketch sketch;
    private XMLElement xml;
    static final String PERMISSION_PREFIX = "android.permission.";

    public Manifest(Sketch sketch) {
        this.sketch = sketch;
        this.load();
    }

    private String defaultPackageName() {
        return "processing.android.test." + this.sketch.getName().toLowerCase();
    }

    public String getPackageName() {
        String pkg = this.xml.getString("package");
        return pkg.length() == 0 ? this.defaultPackageName() : pkg;
    }

    public void setPackageName(String packageName) {
        this.xml.setString("package", packageName);
        this.save();
    }

    public String[] getPermissions() {
        XMLElement[] elements = this.xml.getChildren("uses-permission");
        int count = elements.length;
        String[] names = new String[count];
        int i = 0;
        while (i < count) {
            names[i] = elements[i].getString("android:name").substring(PERMISSION_PREFIX.length());
            ++i;
        }
        return names;
    }

    public void setPermissions(String[] names) {
        Object[] objectArray = this.xml.getChildren("uses-permission");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLElement kid = objectArray[n2];
            this.xml.removeChild(kid);
            ++n2;
        }
        objectArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            XMLElement name = objectArray[n2];
            XMLElement newbie = new XMLElement("uses-permission");
            newbie.setString("android:name", PERMISSION_PREFIX + (String)name);
            this.xml.addChild(newbie);
            ++n2;
        }
        this.save();
    }

    public void setClassName(String className) {
        XMLElement activity;
        String currentName;
        XMLElement[] kids = this.xml.getChildren("application/activity");
        if (kids.length != 1) {
            Base.showWarning("Don't touch that", MULTIPLE_ACTIVITIES, null);
        }
        if ((currentName = (activity = kids[0]).getString("android:name")) == null || !currentName.equals(className)) {
            activity.setString("android:name", "." + className);
            this.save();
        }
    }

    private void writeBlankManifest(File file) {
        PrintWriter writer = PApplet.createWriter((File)file);
        writer.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.println("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\" ");
        writer.println("          package=\"\" ");
        writer.println("          android:versionCode=\"1\" ");
        writer.println("          android:versionName=\"1.0\">");
        writer.println("  <uses-sdk android:minSdkVersion=\"7\" />");
        writer.println("  <application android:label=\"\"");
        writer.println("               android:icon=\"@drawable/icon\"");
        writer.println("               android:debuggable=\"true\">");
        writer.println("    <activity android:name=\"\">");
        writer.println("      <intent-filter>");
        writer.println("        <action android:name=\"android.intent.action.MAIN\" />");
        writer.println("        <category android:name=\"android.intent.category.LAUNCHER\" />");
        writer.println("      </intent-filter>");
        writer.println("    </activity>");
        writer.println("  </application>");
        writer.println("</manifest>");
        writer.flush();
        writer.close();
    }

    protected void writeBuild(File file, String className, boolean debug) throws IOException {
        XMLElement app;
        String label;
        this.save(file);
        XMLElement mf = new XMLElement((Reader)new FileReader(file));
        String p = mf.getString("package").trim();
        if (p.length() == 0) {
            mf.setString("package", this.defaultPackageName());
        }
        if ((label = (app = mf.getChild("application")).getString("android:label")).length() == 0) {
            app.setString("android:label", className);
        }
        app.setString("android:debuggable", debug ? "true" : "false");
        XMLElement activity = app.getChild("activity");
        activity.setString("android:name", "." + className);
        PrintWriter writer = PApplet.createWriter((File)file);
        mf.write(writer);
        writer.close();
    }

    protected void load() {
        File manifestFile;
        block7: {
            manifestFile = this.getManifestFile();
            if (manifestFile.exists()) {
                try {
                    this.xml = new XMLElement((Reader)new FileReader(manifestFile));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Problem reading AndroidManifest.xml, creating a new version");
                    long lastModified = manifestFile.lastModified();
                    String stamp = AndroidMode.getDateStamp(lastModified);
                    File dest = new File(this.sketch.getFolder(), "AndroidManifest.xml." + stamp);
                    boolean moved = manifestFile.renameTo(dest);
                    if (moved) break block7;
                    System.err.println("Could not move/rename " + manifestFile.getAbsolutePath());
                    System.err.println("You'll have to move or remove it before continuing.");
                    return;
                }
            }
        }
        if (this.xml == null) {
            this.writeBlankManifest(manifestFile);
            try {
                this.xml = new XMLElement((Reader)new FileReader(manifestFile));
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not read " + manifestFile.getAbsolutePath());
                e.printStackTrace();
            }
        }
        if (this.xml == null) {
            Base.showWarning("Error handling AndroidManifest.xml", WORLD_OF_HURT_COMING, null);
        }
    }

    protected void save() {
        this.save(this.getManifestFile());
    }

    protected void save(File file) {
        PrintWriter writer = PApplet.createWriter((File)file);
        this.xml.write(writer);
        writer.close();
    }

    private File getManifestFile() {
        return new File(this.sketch.getFolder(), MANIFEST_XML);
    }
}

