/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import processing.app.Base;
import processing.app.SketchException;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaEditor;

public class Compiler {
    /*
     * Unable to fully structure code
     */
    public static boolean compile(JavaBuild build) throws SketchException {
        exception = null;
        success = false;
        baseCommand = new String[]{"-Xemacs", "-source", "1.5", "-target", "1.5", "-classpath", build.getClassPath(), "-nowarn", "-d", build.getBinFolder().getAbsolutePath()};
        sourceFiles = Base.listFiles(build.getSrcFolder(), false, ".java");
        command = PApplet.concat((String[])baseCommand, (String[])sourceFiles);
        try {
            errorBuffer = new StringBuffer();
            internalWriter = new Writer(){

                public void write(char[] buf, int off, int len) {
                    errorBuffer.append(buf, off, len);
                }

                public void flush() {
                }

                public void close() {
                }
            };
            writer = new PrintWriter(internalWriter);
            progress = null;
            outWriter = new PrintWriter(System.out);
            success = BatchCompiler.compile((String[])command, (PrintWriter)outWriter, (PrintWriter)writer, progress);
            writer.flush();
            writer.close();
            reader = new BufferedReader(new StringReader(errorBuffer.toString()));
            line = null;
            while ((line = reader.readLine()) != null) {
                block19: {
                    block18: {
                        block17: {
                            errorFormat = "([\\w\\d_]+.java):(\\d+):\\s*(.*):\\s*(.*)\\s*";
                            pieces = PApplet.match((String)line, (String)errorFormat);
                            if (pieces == null) {
                                exception = new SketchException("Cannot parse error text: " + line);
                                exception.hideStackTrace();
                                System.err.println(line);
                                while ((line = reader.readLine()) != null) {
                                    System.err.println(line);
                                }
                                break;
                            }
                            errorMessage = pieces[4];
                            dotJavaFilename = pieces[1];
                            dotJavaLineIndex = PApplet.parseInt((String)pieces[2]) - 1;
                            exception = build.placeException(errorMessage, dotJavaFilename, dotJavaLineIndex);
                            if (exception == null) {
                                exception = new SketchException(errorMessage);
                            }
                            if (!errorMessage.startsWith("The import ") || !errorMessage.endsWith("cannot be resolved")) break block17;
                            m = PApplet.match((String)errorMessage, (String)"The import (.*) cannot be resolved");
                            if (m != null) {
                                exception.setMessage("The package \u201c" + m[1] + "\u201d" + " does not exist. " + "You might be missing a library.");
                            }
                            System.err.println("As of release 1.0, libraries must be installed in a folder named 'libraries' inside the 'sketchbook' folder.");
                            ** GOTO lbl-1000
                        }
                        if (!errorMessage.endsWith("cannot be resolved to a type")) break block18;
                        what = errorMessage.substring(0, errorMessage.indexOf(32));
                        if (what.equals("BFont") || what.equals("BGraphics") || what.equals("BImage")) {
                            Compiler.handleCrustyCode(exception);
                        } else {
                            exception.setMessage("Cannot find a class or type named \u201c" + what + "\u201d");
                        }
                        ** GOTO lbl-1000
                    }
                    if (!errorMessage.endsWith("cannot be resolved")) break block19;
                    what = errorMessage.substring(0, errorMessage.indexOf(32));
                    if (what.equals("LINE_LOOP") || what.equals("LINE_STRIP") || what.equals("framerate")) {
                        Compiler.handleCrustyCode(exception);
                    } else {
                        exception.setMessage("Cannot find anything named \u201c" + what + "\u201d");
                    }
                    ** GOTO lbl-1000
                }
                if (errorMessage.startsWith("Duplicate")) ** GOTO lbl-1000
                parts = null;
                undefined = "The method (\\S+\\(.*\\)) is undefined for the type (.*)";
                parts = PApplet.match((String)errorMessage, (String)undefined);
                if (parts != null) {
                    if (parts[1].equals("framerate(int)") || parts[1].equals("push()")) {
                        Compiler.handleCrustyCode(exception);
                    } else {
                        mess = "The function " + parts[1] + " does not exist.";
                        exception.setMessage(mess);
                    }
                } else lbl-1000:
                // 7 sources

                {
                    if (exception == null) continue;
                    exception.hideStackTrace();
                }
                break;
            }
        }
        catch (IOException e) {
            bigSigh = "Error while compiling. (" + e.getMessage() + ")";
            exception = new SketchException(bigSigh);
            e.printStackTrace();
            success = false;
        }
        if (exception != null) {
            throw exception;
        }
        return success;
    }

    protected static void handleCrustyCode(SketchException rex) {
        rex.setMessage("This code needs to be updated, please read the Changes page on the Wiki.");
        JavaEditor.showChanges();
    }

    protected int caretColumn(String caretLine) {
        return caretLine.indexOf("^");
    }
}

